/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.SimpleModelFontRenderer;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

final class FancyMissingModel
implements IModel {
    private static final ResourceLocation font = new ResourceLocation("minecraft", "textures/font/ascii.png");
    private static final ResourceLocation font2 = new ResourceLocation("minecraft", "font/ascii");
    private static final TRSRTransformation smallTransformation = TRSRTransformation.blockCenterToCorner(new TRSRTransformation(null, null, new Vector3f(0.25f, 0.25f, 0.25f), null));
    private static final LoadingCache<VertexFormat, SimpleModelFontRenderer> fontCache = CacheBuilder.newBuilder().maximumSize(3L).build((CacheLoader)new CacheLoader<VertexFormat, SimpleModelFontRenderer>(){

        public SimpleModelFontRenderer load(VertexFormat format) throws Exception {
            Matrix4f m = new Matrix4f();
            m.m20 = 0.0078125f;
            m.m01 = m.m12 = -m.m20;
            m.m33 = 1.0f;
            m.setTranslation(new Vector3f(1.0f, 1.0039062f, 0.0f));
            return new SimpleModelFontRenderer(this, Minecraft.getMinecraft().gameSettings, font, Minecraft.getMinecraft().getTextureManager(), false, m, format){

                @Override
                protected float renderUnicodeChar(char c, boolean italic) {
                    return super.renderDefaultChar(126, italic);
                }
            };
        }
    });
    private final IModel missingModel;
    private final String message;

    public FancyMissingModel(IModel missingModel, String message) {
        this.missingModel = missingModel;
        this.message = message;
    }

    @Override
    public Collection<ResourceLocation> getTextures() {
        return ImmutableList.of((Object)font2);
    }

    @Override
    public Optional<ModelBlock> asVanillaModel() {
        return this.missingModel.asVanillaModel();
    }

    @Override
    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IBakedModel bigMissing = this.missingModel.bake(state, format, bakedTextureGetter);
        ModelStateComposition smallState = new ModelStateComposition(state, smallTransformation);
        IBakedModel smallMissing = this.missingModel.bake(smallState, format, bakedTextureGetter);
        return new BakedModel(bigMissing, smallMissing, (SimpleModelFontRenderer)fontCache.getUnchecked((Object)format), this.message, bakedTextureGetter.apply(font2));
    }

    static final class BakedModel
    implements IBakedModel {
        private final SimpleModelFontRenderer fontRenderer;
        private final String message;
        private final TextureAtlasSprite fontTexture;
        private final IBakedModel missingModel;
        private final IBakedModel otherModel;
        private final boolean big;
        private ImmutableList<BakedQuad> quads;

        public BakedModel(IBakedModel bigMissing, IBakedModel smallMissing, SimpleModelFontRenderer fontRenderer, String message, TextureAtlasSprite fontTexture) {
            this.missingModel = bigMissing;
            this.otherModel = new BakedModel(smallMissing, fontRenderer, message, fontTexture, this);
            this.big = true;
            this.fontRenderer = fontRenderer;
            this.message = message;
            this.fontTexture = fontTexture;
        }

        public BakedModel(IBakedModel smallMissing, SimpleModelFontRenderer fontRenderer, String message, TextureAtlasSprite fontTexture, BakedModel big) {
            this.missingModel = smallMissing;
            this.otherModel = big;
            this.big = false;
            this.fontRenderer = fontRenderer;
            this.message = message;
            this.fontTexture = fontTexture;
        }

        @Override
        public List<BakedQuad> getQuads(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            if (side == null) {
                if (this.quads == null) {
                    int y;
                    this.fontRenderer.setSprite(this.fontTexture);
                    this.fontRenderer.setFillBlanks(true);
                    String[] lines = this.message.split("\\r?\\n");
                    ArrayList splitLines = Lists.newArrayList();
                    for (y = 0; y < lines.length; ++y) {
                        splitLines.addAll(this.fontRenderer.listFormattedStringToWidth(lines[y], 128));
                    }
                    for (y = 0; y < splitLines.size(); ++y) {
                        this.fontRenderer.drawString((String)splitLines.get(y), 0, (int)(((float)y - (float)splitLines.size() / 2.0f) * (float)this.fontRenderer.FONT_HEIGHT) + 64, -16711681);
                    }
                    ImmutableList.Builder builder = ImmutableList.builder();
                    builder.addAll(this.missingModel.getQuads(state, side, rand));
                    builder.addAll(this.fontRenderer.build());
                    this.quads = builder.build();
                }
                return this.quads;
            }
            return this.missingModel.getQuads(state, side, rand);
        }

        @Override
        public boolean isAmbientOcclusion() {
            return true;
        }

        @Override
        public boolean isGui3d() {
            return false;
        }

        @Override
        public boolean isBuiltInRenderer() {
            return false;
        }

        @Override
        public TextureAtlasSprite getParticleTexture() {
            return this.fontTexture;
        }

        @Override
        public ItemOverrideList getOverrides() {
            return ItemOverrideList.NONE;
        }

        @Override
        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            TRSRTransformation transform = TRSRTransformation.identity();
            boolean big = true;
            switch (cameraTransformType) {
                case THIRD_PERSON_LEFT_HAND: {
                    break;
                }
                case THIRD_PERSON_RIGHT_HAND: {
                    break;
                }
                case FIRST_PERSON_LEFT_HAND: {
                    transform = new TRSRTransformation(new Vector3f(-0.62f, 0.5f, -0.5f), new Quat4f(1.0f, -1.0f, -1.0f, 1.0f), null, null);
                    big = false;
                    break;
                }
                case FIRST_PERSON_RIGHT_HAND: {
                    transform = new TRSRTransformation(new Vector3f(-0.5f, 0.5f, -0.5f), new Quat4f(1.0f, 1.0f, 1.0f, 1.0f), null, null);
                    big = false;
                    break;
                }
                case HEAD: {
                    break;
                }
                case GUI: {
                    if (ForgeModContainer.zoomInMissingModelTextInGui) {
                        transform = new TRSRTransformation(null, new Quat4f(1.0f, 1.0f, 1.0f, 1.0f), new Vector3f(4.0f, 4.0f, 4.0f), null);
                        big = false;
                        break;
                    }
                    transform = new TRSRTransformation(null, new Quat4f(1.0f, 1.0f, 1.0f, 1.0f), null, null);
                    big = true;
                    break;
                }
                case FIXED: {
                    transform = new TRSRTransformation(null, new Quat4f(-1.0f, -1.0f, 1.0f, 1.0f), null, null);
                    break;
                }
            }
            if (big != this.big) {
                return Pair.of((Object)this.otherModel, (Object)transform.getMatrix());
            }
            return Pair.of((Object)this, (Object)transform.getMatrix());
        }
    }
}

