/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.model.animation.IClip;

public interface IModel {
    default public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of();
    }

    default public Collection<ResourceLocation> getTextures() {
        return ImmutableList.of();
    }

    public IBakedModel bake(IModelState var1, VertexFormat var2, Function<ResourceLocation, TextureAtlasSprite> var3);

    default public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    default public Optional<? extends IClip> getClip(String name) {
        return Optional.empty();
    }

    default public IModel process(ImmutableMap<String, String> customData) {
        return this;
    }

    default public IModel smoothLighting(boolean value) {
        return this;
    }

    default public IModel gui3d(boolean value) {
        return this;
    }

    default public IModel uvlock(boolean value) {
        return this;
    }

    default public IModel retexture(ImmutableMap<String, String> textures) {
        return this;
    }

    default public Optional<ModelBlock> asVanillaModel() {
        return Optional.empty();
    }
}

