/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.TRSRTransformer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public final class ItemLayerModel
implements IModel {
    public static final ItemLayerModel INSTANCE = new ItemLayerModel((ImmutableList<ResourceLocation>)ImmutableList.of());
    private static final EnumFacing[] HORIZONTALS = new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN};
    private static final EnumFacing[] VERTICALS = new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST};
    private final ImmutableList<ResourceLocation> textures;
    private final ItemOverrideList overrides;

    public ItemLayerModel(ImmutableList<ResourceLocation> textures) {
        this(textures, ItemOverrideList.NONE);
    }

    public ItemLayerModel(ImmutableList<ResourceLocation> textures, ItemOverrideList overrides) {
        this.textures = textures;
        this.overrides = overrides;
    }

    public ItemLayerModel(ModelBlock model) {
        this(ItemLayerModel.getTextures(model), model.createOverrides());
    }

    private static ImmutableList<ResourceLocation> getTextures(ModelBlock model) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int i = 0;
        while (model.isTexturePresent("layer" + i)) {
            builder.add((Object)new ResourceLocation(model.resolveTextureName("layer" + i)));
            ++i;
        }
        return builder.build();
    }

    @Override
    public Collection<ResourceLocation> getTextures() {
        return this.textures;
    }

    @Override
    public ItemLayerModel retexture(ImmutableMap<String, String> textures) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < textures.size() + this.textures.size(); ++i) {
            if (textures.containsKey((Object)("layer" + i))) {
                builder.add((Object)new ResourceLocation((String)textures.get((Object)("layer" + i))));
                continue;
            }
            if (i >= this.textures.size()) continue;
            builder.add((Object)((ResourceLocation)this.textures.get(i)));
        }
        return new ItemLayerModel((ImmutableList<ResourceLocation>)builder.build(), this.overrides);
    }

    @Override
    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Optional<TRSRTransformation> transform = state.apply(Optional.empty());
        boolean identity = !transform.isPresent() || transform.get().isIdentity();
        for (int i = 0; i < this.textures.size(); ++i) {
            TextureAtlasSprite sprite = bakedTextureGetter.apply((ResourceLocation)this.textures.get(i));
            builder.addAll(ItemLayerModel.getQuadsForSprite(i, sprite, format, transform));
        }
        TextureAtlasSprite particle = bakedTextureGetter.apply(this.textures.isEmpty() ? new ResourceLocation("missingno") : (ResourceLocation)this.textures.get(0));
        ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> map = PerspectiveMapWrapper.getTransforms(state);
        return new BakedItemModel((ImmutableList<BakedQuad>)builder.build(), particle, map, this.overrides, identity);
    }

    public static ImmutableList<BakedQuad> getQuadsForSprite(int tint, TextureAtlasSprite sprite, VertexFormat format, Optional<TRSRTransformation> transform) {
        int off;
        int off2;
        boolean face;
        boolean building;
        int u;
        int v;
        ImmutableList.Builder builder = ImmutableList.builder();
        int uMax = sprite.getIconWidth();
        int vMax = sprite.getIconHeight();
        FaceData faceData = new FaceData(uMax, vMax);
        boolean translucent = false;
        for (int f = 0; f < sprite.getFrameCount(); ++f) {
            int[] pixels = sprite.getFrameTextureData(f)[0];
            boolean[] ptv = new boolean[uMax];
            Arrays.fill(ptv, true);
            for (v = 0; v < vMax; ++v) {
                boolean ptu = true;
                for (int u2 = 0; u2 < uMax; ++u2) {
                    boolean t;
                    int alpha = ItemLayerModel.getAlpha(pixels, uMax, vMax, u2, v);
                    boolean bl = t = (float)alpha / 255.0f <= 0.1f;
                    if (!t && alpha < 255) {
                        translucent = true;
                    }
                    if (ptu && !t) {
                        faceData.set(EnumFacing.WEST, u2, v);
                    }
                    if (!ptu && t) {
                        faceData.set(EnumFacing.EAST, u2 - 1, v);
                    }
                    if (ptv[u2] && !t) {
                        faceData.set(EnumFacing.UP, u2, v);
                    }
                    if (!ptv[u2] && t) {
                        faceData.set(EnumFacing.DOWN, u2, v - 1);
                    }
                    ptu = t;
                    ptv[u2] = t;
                }
                if (ptu) continue;
                faceData.set(EnumFacing.EAST, uMax - 1, v);
            }
            for (u = 0; u < uMax; ++u) {
                if (ptv[u]) continue;
                faceData.set(EnumFacing.DOWN, u, vMax - 1);
            }
        }
        for (EnumFacing facing : HORIZONTALS) {
            for (v = 0; v < vMax; ++v) {
                int uStart = 0;
                int uEnd = uMax;
                building = false;
                for (int u3 = 0; u3 < uMax; ++u3) {
                    face = faceData.get(facing, u3, v);
                    if (!translucent) {
                        if (!face) continue;
                        if (!building) {
                            building = true;
                            uStart = u3;
                        }
                        uEnd = u3 + 1;
                        continue;
                    }
                    if (building && !face) {
                        off2 = facing == EnumFacing.DOWN ? 1 : 0;
                        builder.add((Object)ItemLayerModel.buildSideQuad(format, transform, facing, tint, sprite, uStart, v + off2, u3 - uStart));
                        building = false;
                        continue;
                    }
                    if (building || !face) continue;
                    building = true;
                    uStart = u3;
                }
                if (!building) continue;
                off = facing == EnumFacing.DOWN ? 1 : 0;
                builder.add((Object)ItemLayerModel.buildSideQuad(format, transform, facing, tint, sprite, uStart, v + off, uEnd - uStart));
            }
        }
        for (EnumFacing facing : VERTICALS) {
            for (u = 0; u < uMax; ++u) {
                int vStart = 0;
                int vEnd = vMax;
                building = false;
                for (int v2 = 0; v2 < vMax; ++v2) {
                    face = faceData.get(facing, u, v2);
                    if (!translucent) {
                        if (!face) continue;
                        if (!building) {
                            building = true;
                            vStart = v2;
                        }
                        vEnd = v2 + 1;
                        continue;
                    }
                    if (building && !face) {
                        off2 = facing == EnumFacing.EAST ? 1 : 0;
                        builder.add((Object)ItemLayerModel.buildSideQuad(format, transform, facing, tint, sprite, u + off2, vStart, v2 - vStart));
                        building = false;
                        continue;
                    }
                    if (building || !face) continue;
                    building = true;
                    vStart = v2;
                }
                if (!building) continue;
                off = facing == EnumFacing.EAST ? 1 : 0;
                builder.add((Object)ItemLayerModel.buildSideQuad(format, transform, facing, tint, sprite, u + off, vStart, vEnd - vStart));
            }
        }
        builder.add((Object)ItemLayerModel.buildQuad(format, transform, EnumFacing.NORTH, sprite, tint, 0.0f, 0.0f, 0.46875f, sprite.getMinU(), sprite.getMaxV(), 0.0f, 1.0f, 0.46875f, sprite.getMinU(), sprite.getMinV(), 1.0f, 1.0f, 0.46875f, sprite.getMaxU(), sprite.getMinV(), 1.0f, 0.0f, 0.46875f, sprite.getMaxU(), sprite.getMaxV()));
        builder.add((Object)ItemLayerModel.buildQuad(format, transform, EnumFacing.SOUTH, sprite, tint, 0.0f, 0.0f, 0.53125f, sprite.getMinU(), sprite.getMaxV(), 1.0f, 0.0f, 0.53125f, sprite.getMaxU(), sprite.getMaxV(), 1.0f, 1.0f, 0.53125f, sprite.getMaxU(), sprite.getMinV(), 0.0f, 1.0f, 0.53125f, sprite.getMinU(), sprite.getMinV()));
        return builder.build();
    }

    private static int getAlpha(int[] pixels, int uMax, int vMax, int u, int v) {
        return pixels[u + (vMax - 1 - v) * uMax] >> 24 & 0xFF;
    }

    private static BakedQuad buildSideQuad(VertexFormat format, Optional<TRSRTransformation> transform, EnumFacing side, int tint, TextureAtlasSprite sprite, int u, int v, int size) {
        float eps = 0.01f;
        int width = sprite.getIconWidth();
        int height = sprite.getIconHeight();
        float x0 = (float)u / (float)width;
        float y0 = (float)v / (float)height;
        float x1 = x0;
        float y1 = y0;
        float z0 = 0.46875f;
        float z1 = 0.53125f;
        switch (side) {
            case WEST: {
                z0 = 0.53125f;
                z1 = 0.46875f;
            }
            case EAST: {
                y1 = (float)(v + size) / (float)height;
                break;
            }
            case DOWN: {
                z0 = 0.53125f;
                z1 = 0.46875f;
            }
            case UP: {
                x1 = (float)(u + size) / (float)width;
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        float dx = (float)side.getDirectionVec().getX() * 0.01f / (float)width;
        float dy = (float)side.getDirectionVec().getY() * 0.01f / (float)height;
        float u0 = 16.0f * (x0 - dx);
        float u1 = 16.0f * (x1 - dx);
        float v0 = 16.0f * (1.0f - y0 - dy);
        float v1 = 16.0f * (1.0f - y1 - dy);
        return ItemLayerModel.buildQuad(format, transform, ItemLayerModel.remap(side), sprite, tint, x0, y0, z0, sprite.getInterpolatedU(u0), sprite.getInterpolatedV(v0), x1, y1, z0, sprite.getInterpolatedU(u1), sprite.getInterpolatedV(v1), x1, y1, z1, sprite.getInterpolatedU(u1), sprite.getInterpolatedV(v1), x0, y0, z1, sprite.getInterpolatedU(u0), sprite.getInterpolatedV(v0));
    }

    private static EnumFacing remap(EnumFacing side) {
        return side.getAxis() == EnumFacing.Axis.Y ? side.getOpposite() : side;
    }

    private static BakedQuad buildQuad(VertexFormat format, Optional<TRSRTransformation> transform, EnumFacing side, TextureAtlasSprite sprite, int tint, float x0, float y0, float z0, float u0, float v0, float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2, float x3, float y3, float z3, float u3, float v3) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
        builder.setQuadTint(tint);
        builder.setQuadOrientation(side);
        builder.setTexture(sprite);
        boolean hasTransform = transform.isPresent() && !transform.get().isIdentity();
        IVertexConsumer consumer = hasTransform ? new TRSRTransformer(builder, transform.get()) : builder;
        ItemLayerModel.putVertex(consumer, format, side, x0, y0, z0, u0, v0);
        ItemLayerModel.putVertex(consumer, format, side, x1, y1, z1, u1, v1);
        ItemLayerModel.putVertex(consumer, format, side, x2, y2, z2, u2, v2);
        ItemLayerModel.putVertex(consumer, format, side, x3, y3, z3, u3, v3);
        return builder.build();
    }

    private static void putVertex(IVertexConsumer consumer, VertexFormat format, EnumFacing side, float x, float y, float z, float u, float v) {
        block6: for (int e = 0; e < format.getElementCount(); ++e) {
            switch (format.getElement(e).getUsage()) {
                case POSITION: {
                    consumer.put(e, x, y, z, 1.0f);
                    continue block6;
                }
                case COLOR: {
                    consumer.put(e, 1.0f, 1.0f, 1.0f, 1.0f);
                    continue block6;
                }
                case NORMAL: {
                    float offX = side.getXOffset();
                    float offY = side.getYOffset();
                    float offZ = side.getZOffset();
                    consumer.put(e, offX, offY, offZ, 0.0f);
                    continue block6;
                }
                case UV: {
                    if (format.getElement(e).getIndex() == 0) {
                        consumer.put(e, u, v, 0.0f, 1.0f);
                        continue block6;
                    }
                }
                default: {
                    consumer.put(e, new float[0]);
                }
            }
        }
    }

    private static class FaceData {
        private final EnumMap<EnumFacing, BitSet> data = new EnumMap(EnumFacing.class);
        private final int vMax;

        FaceData(int uMax, int vMax) {
            this.vMax = vMax;
            this.data.put(EnumFacing.WEST, new BitSet(uMax * vMax));
            this.data.put(EnumFacing.EAST, new BitSet(uMax * vMax));
            this.data.put(EnumFacing.UP, new BitSet(uMax * vMax));
            this.data.put(EnumFacing.DOWN, new BitSet(uMax * vMax));
        }

        public void set(EnumFacing facing, int u, int v) {
            this.data.get(facing).set(this.getIndex(u, v));
        }

        public boolean get(EnumFacing facing, int u, int v) {
            return this.data.get(facing).get(this.getIndex(u, v));
        }

        private int getIndex(int u, int v) {
            return v * this.vMax + u;
        }
    }

    public static enum Loader implements ICustomModelLoader
    {
        INSTANCE;


        @Override
        public void onResourceManagerReload(IResourceManager resourceManager) {
        }

        @Override
        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.getNamespace().equals("forge") && (modelLocation.getPath().equals("item-layer") || modelLocation.getPath().equals("models/block/item-layer") || modelLocation.getPath().equals("models/item/item-layer"));
        }

        @Override
        public IModel loadModel(ResourceLocation modelLocation) {
            return INSTANCE;
        }
    }
}

