/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Quat4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ItemTextureQuadConverter;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.FMLLog;

public final class ModelDynBucket
implements IModel {
    public static final ModelResourceLocation LOCATION = new ModelResourceLocation(new ResourceLocation("forge", "dynbucket"), "inventory");
    private static final float NORTH_Z_COVER = 0.4685f;
    private static final float SOUTH_Z_COVER = 0.5315f;
    private static final float NORTH_Z_FLUID = 0.468625f;
    private static final float SOUTH_Z_FLUID = 0.531375f;
    public static final IModel MODEL = new ModelDynBucket();
    @Nullable
    private final ResourceLocation baseLocation;
    @Nullable
    private final ResourceLocation liquidLocation;
    @Nullable
    private final ResourceLocation coverLocation;
    @Nullable
    private final Fluid fluid;
    private final boolean flipGas;
    private final boolean tint;

    public ModelDynBucket() {
        this(null, null, null, null, false, true);
    }

    @Deprecated
    public ModelDynBucket(@Nullable ResourceLocation baseLocation, @Nullable ResourceLocation liquidLocation, @Nullable ResourceLocation coverLocation, @Nullable Fluid fluid, boolean flipGas) {
        this(baseLocation, liquidLocation, coverLocation, fluid, flipGas, true);
    }

    public ModelDynBucket(@Nullable ResourceLocation baseLocation, @Nullable ResourceLocation liquidLocation, @Nullable ResourceLocation coverLocation, @Nullable Fluid fluid, boolean flipGas, boolean tint) {
        this.baseLocation = baseLocation;
        this.liquidLocation = liquidLocation;
        this.coverLocation = coverLocation;
        this.fluid = fluid;
        this.flipGas = flipGas;
        this.tint = tint;
    }

    @Override
    public Collection<ResourceLocation> getTextures() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (this.baseLocation != null) {
            builder.add((Object)this.baseLocation);
        }
        if (this.liquidLocation != null) {
            builder.add((Object)this.liquidLocation);
        }
        if (this.coverLocation != null) {
            builder.add((Object)this.coverLocation);
        }
        if (this.fluid != null) {
            builder.add((Object)this.fluid.getStill());
        }
        return builder.build();
    }

    @Override
    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transformMap = PerspectiveMapWrapper.getTransforms(state);
        if (this.flipGas && this.fluid != null && this.fluid.isLighterThanAir()) {
            state = new ModelStateComposition(state, TRSRTransformation.blockCenterToCorner(new TRSRTransformation(null, new Quat4f(0.0f, 0.0f, 1.0f, 0.0f), null, null)));
        }
        TRSRTransformation transform = state.apply(Optional.empty()).orElse(TRSRTransformation.identity());
        TextureAtlasSprite fluidSprite = null;
        TextureAtlasSprite particleSprite = null;
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.fluid != null) {
            fluidSprite = bakedTextureGetter.apply(this.fluid.getStill());
        }
        if (this.baseLocation != null) {
            IBakedModel model = new ItemLayerModel((ImmutableList<ResourceLocation>)ImmutableList.of((Object)this.baseLocation)).bake(state, format, bakedTextureGetter);
            builder.addAll(model.getQuads(null, null, 0L));
            particleSprite = model.getParticleTexture();
        }
        if (this.liquidLocation != null && fluidSprite != null) {
            TextureAtlasSprite liquid = bakedTextureGetter.apply(this.liquidLocation);
            builder.addAll(ItemTextureQuadConverter.convertTexture(format, transform, liquid, fluidSprite, 0.468625f, EnumFacing.NORTH, this.tint ? this.fluid.getColor() : -1, 1));
            builder.addAll(ItemTextureQuadConverter.convertTexture(format, transform, liquid, fluidSprite, 0.531375f, EnumFacing.SOUTH, this.tint ? this.fluid.getColor() : -1, 1));
            particleSprite = fluidSprite;
        }
        if (this.coverLocation != null) {
            TextureAtlasSprite cover = bakedTextureGetter.apply(this.coverLocation);
            builder.add((Object)ItemTextureQuadConverter.genQuad(format, transform, 0.0f, 0.0f, 16.0f, 16.0f, 0.4685f, cover, EnumFacing.NORTH, -1, 2));
            builder.add((Object)ItemTextureQuadConverter.genQuad(format, transform, 0.0f, 0.0f, 16.0f, 16.0f, 0.5315f, cover, EnumFacing.SOUTH, -1, 2));
            if (particleSprite == null) {
                particleSprite = cover;
            }
        }
        return new BakedDynBucket(this, (ImmutableList<BakedQuad>)builder.build(), particleSprite, format, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)Maps.immutableEnumMap(transformMap), Maps.newHashMap(), transform.isIdentity());
    }

    @Override
    public ModelDynBucket process(ImmutableMap<String, String> customData) {
        String fluidName = (String)customData.get((Object)"fluid");
        Fluid fluid = FluidRegistry.getFluid(fluidName);
        if (fluid == null) {
            fluid = this.fluid;
        }
        boolean flip = this.flipGas;
        if (customData.containsKey((Object)"flipGas")) {
            String flipStr = (String)customData.get((Object)"flipGas");
            if (flipStr.equals("true")) {
                flip = true;
            } else if (flipStr.equals("false")) {
                flip = false;
            } else {
                throw new IllegalArgumentException(String.format("DynBucket custom data \"flipGas\" must have value 'true' or 'false' (was '%s')", flipStr));
            }
        }
        boolean tint = this.tint;
        if (customData.containsKey((Object)"applyTint")) {
            String string;
            switch (string = (String)customData.get((Object)"applyTint")) {
                case "true": {
                    tint = true;
                    break;
                }
                case "false": {
                    tint = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("DynBucket custom data \"applyTint\" must have value 'true' or 'false' (was '%s')", string));
                }
            }
        }
        return new ModelDynBucket(this.baseLocation, this.liquidLocation, this.coverLocation, fluid, flip, tint);
    }

    @Override
    public ModelDynBucket retexture(ImmutableMap<String, String> textures) {
        ResourceLocation base = this.baseLocation;
        ResourceLocation liquid = this.liquidLocation;
        ResourceLocation cover = this.coverLocation;
        if (textures.containsKey((Object)"base")) {
            base = new ResourceLocation((String)textures.get((Object)"base"));
        }
        if (textures.containsKey((Object)"fluid")) {
            liquid = new ResourceLocation((String)textures.get((Object)"fluid"));
        }
        if (textures.containsKey((Object)"cover")) {
            cover = new ResourceLocation((String)textures.get((Object)"cover"));
        }
        return new ModelDynBucket(base, liquid, cover, this.fluid, this.flipGas, this.tint);
    }

    private static final class BakedDynBucket
    extends BakedItemModel {
        private final ModelDynBucket parent;
        private final Map<String, IBakedModel> cache;
        private final VertexFormat format;

        BakedDynBucket(ModelDynBucket parent, ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, VertexFormat format, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, Map<String, IBakedModel> cache, boolean untransformed) {
            super(quads, particle, transforms, BakedDynBucketOverrideHandler.INSTANCE, untransformed);
            this.format = format;
            this.parent = parent;
            this.cache = cache;
        }
    }

    private static final class BakedDynBucketOverrideHandler
    extends ItemOverrideList {
        public static final BakedDynBucketOverrideHandler INSTANCE = new BakedDynBucketOverrideHandler();

        private BakedDynBucketOverrideHandler() {
            super((List<ItemOverride>)ImmutableList.of());
        }

        @Override
        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            FluidStack fluidStack = FluidUtil.getFluidContained(stack);
            if (fluidStack == null) {
                return originalModel;
            }
            BakedDynBucket model = (BakedDynBucket)originalModel;
            Fluid fluid = fluidStack.getFluid();
            String name = fluid.getName();
            if (!model.cache.containsKey(name)) {
                IModel parent = model.parent.process(ImmutableMap.of((Object)"fluid", (Object)name));
                Function<ResourceLocation, TextureAtlasSprite> textureGetter = location -> Minecraft.getMinecraft().getTextureMapBlocks().getAtlasSprite(location.toString());
                IBakedModel bakedModel = parent.bake(new SimpleModelState((ImmutableMap<? extends IModelPart, TRSRTransformation>)model.transforms), model.format, textureGetter);
                model.cache.put(name, bakedModel);
                return bakedModel;
            }
            return model.cache.get(name);
        }
    }

    private static final class BucketCoverSprite
    extends TextureAtlasSprite {
        private final ResourceLocation bucket = new ResourceLocation("items/bucket_empty");
        private final ResourceLocation bucketCoverMask = new ResourceLocation("forge", "items/vanilla_bucket_cover_mask");
        private final ImmutableList<ResourceLocation> dependencies = ImmutableList.of((Object)this.bucket, (Object)this.bucketCoverMask);

        private BucketCoverSprite(ResourceLocation resourceLocation) {
            super(resourceLocation.toString());
        }

        @Override
        public boolean hasCustomLoader(@Nonnull IResourceManager manager, @Nonnull ResourceLocation location) {
            return true;
        }

        @Override
        public Collection<ResourceLocation> getDependencies() {
            return this.dependencies;
        }

        @Override
        public boolean load(@Nonnull IResourceManager manager, @Nonnull ResourceLocation location, @Nonnull Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
            TextureAtlasSprite sprite = textureGetter.apply(this.bucket);
            TextureAtlasSprite alphaMask = textureGetter.apply(this.bucketCoverMask);
            this.width = sprite.getIconWidth();
            this.height = sprite.getIconHeight();
            int[][] pixels = new int[Minecraft.getMinecraft().gameSettings.mipmapLevels + 1][];
            pixels[0] = new int[this.width * this.height];
            try (IResource empty = LoaderDynBucket.getResource(new ResourceLocation("textures/items/bucket_empty.png"));
                 IResource mask = LoaderDynBucket.getResource(new ResourceLocation("forge", "textures/items/vanilla_bucket_cover_mask.png"));){
                if (empty != null && mask != null && Objects.equals(empty.getResourcePackName(), mask.getResourcePackName()) && alphaMask.getIconWidth() == this.width && alphaMask.getIconHeight() == this.height) {
                    int[][] oldPixels = sprite.getFrameTextureData(0);
                    int[][] alphaPixels = alphaMask.getFrameTextureData(0);
                    for (int p = 0; p < this.width * this.height; ++p) {
                        int alphaMultiplier = alphaPixels[0][p] >>> 24;
                        int oldPixel = oldPixels[0][p];
                        int oldPixelAlpha = oldPixel >>> 24;
                        int newAlpha = oldPixelAlpha * alphaMultiplier / 255;
                        pixels[0][p] = (oldPixel & 0xFFFFFF) + (newAlpha << 24);
                    }
                }
            }
            catch (IOException e) {
                FMLLog.log.error("Failed to close resource", (Throwable)e);
            }
            this.clearFramesTextureData();
            this.framesTextureData.add(pixels);
            return false;
        }
    }

    private static final class BucketBaseSprite
    extends TextureAtlasSprite {
        private final ResourceLocation bucket = new ResourceLocation("items/bucket_empty");
        private final ImmutableList<ResourceLocation> dependencies = ImmutableList.of((Object)this.bucket);

        private BucketBaseSprite(ResourceLocation resourceLocation) {
            super(resourceLocation.toString());
        }

        @Override
        public boolean hasCustomLoader(@Nonnull IResourceManager manager, @Nonnull ResourceLocation location) {
            return true;
        }

        @Override
        public Collection<ResourceLocation> getDependencies() {
            return this.dependencies;
        }

        @Override
        public boolean load(@Nonnull IResourceManager manager, @Nonnull ResourceLocation location, @Nonnull Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
            TextureAtlasSprite sprite = textureGetter.apply(this.bucket);
            this.width = sprite.getIconWidth();
            this.height = sprite.getIconHeight();
            int[][] pixels = sprite.getFrameTextureData(0);
            this.clearFramesTextureData();
            this.framesTextureData.add(pixels);
            return false;
        }
    }

    public static enum LoaderDynBucket implements ICustomModelLoader
    {
        INSTANCE;


        @Override
        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.getNamespace().equals("forge") && modelLocation.getPath().contains("forgebucket");
        }

        @Override
        public IModel loadModel(ResourceLocation modelLocation) {
            return MODEL;
        }

        @Override
        public void onResourceManagerReload(IResourceManager resourceManager) {
        }

        public void register(TextureMap map) {
            try (IResource cover = LoaderDynBucket.getResource(new ResourceLocation("forge", "textures/items/bucket_cover.png"));
                 IResource base = LoaderDynBucket.getResource(new ResourceLocation("forge", "textures/items/bucket_base.png"));){
                if (cover == null) {
                    ResourceLocation bucketCover = new ResourceLocation("forge", "items/bucket_cover");
                    BucketCoverSprite bucketCoverSprite = new BucketCoverSprite(bucketCover);
                    map.setTextureEntry(bucketCoverSprite);
                }
                if (base == null) {
                    ResourceLocation bucketBase = new ResourceLocation("forge", "items/bucket_base");
                    BucketBaseSprite bucketBaseSprite = new BucketBaseSprite(bucketBase);
                    map.setTextureEntry(bucketBaseSprite);
                }
            }
            catch (IOException e) {
                FMLLog.log.error("Failed to close resource", (Throwable)e);
            }
        }

        @Nullable
        protected static IResource getResource(ResourceLocation resourceLocation) {
            try {
                return Minecraft.getMinecraft().getResourceManager().getResource(resourceLocation);
            }
            catch (IOException ignored) {
                return null;
            }
        }
    }
}

