/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.TRSRTransformer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.tuple.Pair;

public final class ModelFluid
implements IModel {
    public static final ModelFluid WATER = new ModelFluid(FluidRegistry.WATER);
    public static final ModelFluid LAVA = new ModelFluid(FluidRegistry.LAVA);
    private final Fluid fluid;

    public ModelFluid(Fluid fluid) {
        this.fluid = fluid;
    }

    @Override
    public Collection<ResourceLocation> getTextures() {
        return this.fluid.getOverlay() != null ? ImmutableSet.of((Object)this.fluid.getStill(), (Object)this.fluid.getFlowing(), (Object)this.fluid.getOverlay()) : ImmutableSet.of((Object)this.fluid.getStill(), (Object)this.fluid.getFlowing());
    }

    @Override
    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return new CachingBakedFluid(state.apply(Optional.empty()), PerspectiveMapWrapper.getTransforms(state), format, this.fluid.getColor(), bakedTextureGetter.apply(this.fluid.getStill()), bakedTextureGetter.apply(this.fluid.getFlowing()), Optional.ofNullable(this.fluid.getOverlay()).map(bakedTextureGetter), this.fluid.isLighterThanAir(), Optional.empty());
    }

    @Override
    public ModelFluid process(ImmutableMap<String, String> customData) {
        if (!customData.containsKey((Object)"fluid")) {
            return this;
        }
        String fluidStr = (String)customData.get((Object)"fluid");
        JsonElement e = JsonParser.parseString((String)fluidStr);
        String fluid = e.getAsString();
        if (!FluidRegistry.isFluidRegistered(fluid)) {
            FMLLog.log.fatal("fluid '{}' not found", (Object)fluid);
            return WATER;
        }
        return new ModelFluid(FluidRegistry.getFluid(fluid));
    }

    private static final class CachingBakedFluid
    extends BakedFluid {
        private final LoadingCache<Long, BakedFluid> modelCache = CacheBuilder.newBuilder().maximumSize(200L).build((CacheLoader)new CacheLoader<Long, BakedFluid>(){

            public BakedFluid load(Long key) {
                boolean statePresent = (key & 1L) != 0L;
                key = key >>> 1;
                int[] cornerRound = new int[4];
                for (int i = 0; i < 4; ++i) {
                    cornerRound[i] = (int)(key & 0x3FFL);
                    key = key >>> 10;
                }
                int flowRound = (int)(key & 0x7FFL) - 1024;
                key = key >>> 11;
                boolean[] overlaySides = new boolean[4];
                for (int i = 0; i < 4; ++i) {
                    overlaySides[i] = (key & 1L) != 0L;
                    key = key >>> 1;
                }
                return new BakedFluid(transformation, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)transforms, format, color, still, flowing, overlay, gas, statePresent, cornerRound, flowRound, overlaySides);
            }
        });

        public CachingBakedFluid(Optional<TRSRTransformation> transformation, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, VertexFormat format, int color, TextureAtlasSprite still, TextureAtlasSprite flowing, Optional<TextureAtlasSprite> overlay, boolean gas, Optional<IExtendedBlockState> stateOption) {
            super(transformation, transforms, format, color, still, flowing, overlay, gas, stateOption.isPresent(), CachingBakedFluid.getCorners(stateOption), CachingBakedFluid.getFlow(stateOption), CachingBakedFluid.getOverlay(stateOption));
        }

        private static int[] getCorners(Optional<IExtendedBlockState> stateOption) {
            int[] cornerRound = new int[]{0, 0, 0, 0};
            if (stateOption.isPresent()) {
                IExtendedBlockState state = stateOption.get();
                for (int i = 0; i < 4; ++i) {
                    Float level = state.getValue(BlockFluidBase.LEVEL_CORNERS[i]);
                    cornerRound[i] = Math.round((level == null ? 0.8888889f : level.floatValue()) * 864.0f);
                }
            }
            return cornerRound;
        }

        private static int getFlow(Optional<IExtendedBlockState> stateOption) {
            Float flow = Float.valueOf(-1000.0f);
            if (stateOption.isPresent() && (flow = stateOption.get().getValue(BlockFluidBase.FLOW_DIRECTION)) == null) {
                flow = Float.valueOf(-1000.0f);
            }
            int flowRound = (int)Math.round(Math.toDegrees(flow.floatValue()));
            flowRound = MathHelper.clamp(flowRound, -1000, 1000);
            return flowRound;
        }

        private static boolean[] getOverlay(Optional<IExtendedBlockState> stateOption) {
            boolean[] overlaySides = new boolean[4];
            if (stateOption.isPresent()) {
                IExtendedBlockState state = stateOption.get();
                for (int i = 0; i < 4; ++i) {
                    Boolean overlay = state.getValue(BlockFluidBase.SIDE_OVERLAYS[i]);
                    if (overlay == null) continue;
                    overlaySides[i] = overlay;
                }
            }
            return overlaySides;
        }

        @Override
        public List<BakedQuad> getQuads(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            if (side != null && state instanceof IExtendedBlockState) {
                int i;
                Optional<IExtendedBlockState> exState = Optional.of((IExtendedBlockState)state);
                int[] cornerRound = CachingBakedFluid.getCorners(exState);
                int flowRound = CachingBakedFluid.getFlow(exState);
                boolean[] overlaySides = CachingBakedFluid.getOverlay(exState);
                long key = 0L;
                for (i = 3; i >= 0; --i) {
                    key <<= 1;
                    key |= overlaySides[i] ? 1L : 0L;
                }
                key <<= 11;
                key |= (long)(flowRound + 1024);
                for (i = 3; i >= 0; --i) {
                    key <<= 10;
                    key |= (long)cornerRound[i];
                }
                key <<= 1;
                return ((BakedFluid)this.modelCache.getUnchecked((Object)(key |= 1L))).getQuads(state, side, rand);
            }
            return super.getQuads(state, side, rand);
        }
    }

    private static class BakedFluid
    implements IBakedModel {
        private static final int[] x = new int[]{0, 0, 1, 1};
        private static final int[] z = new int[]{0, 1, 1, 0};
        private static final float eps = 0.001f;
        protected final Optional<TRSRTransformation> transformation;
        protected final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        protected final VertexFormat format;
        protected final int color;
        protected final TextureAtlasSprite still;
        protected final TextureAtlasSprite flowing;
        protected final Optional<TextureAtlasSprite> overlay;
        protected final boolean gas;
        protected final ImmutableMap<EnumFacing, ImmutableList<BakedQuad>> faceQuads;

        public BakedFluid(Optional<TRSRTransformation> transformation, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, VertexFormat format, int color, TextureAtlasSprite still, TextureAtlasSprite flowing, Optional<TextureAtlasSprite> overlay, boolean gas, boolean statePresent, int[] cornerRound, int flowRound, boolean[] sideOverlays) {
            this.transformation = transformation;
            this.transforms = transforms;
            this.format = format;
            this.color = color;
            this.still = still;
            this.flowing = flowing;
            this.overlay = overlay;
            this.gas = gas;
            this.faceQuads = this.buildQuads(statePresent, cornerRound, flowRound, sideOverlays);
        }

        private ImmutableMap<EnumFacing, ImmutableList<BakedQuad>> buildQuads(boolean statePresent, int[] cornerRound, int flowRound, boolean[] sideOverlays) {
            EnumMap<EnumFacing, ImmutableList> faceQuads = new EnumMap<EnumFacing, ImmutableList>(EnumFacing.class);
            for (EnumFacing side : EnumFacing.values()) {
                faceQuads.put(side, ImmutableList.of());
            }
            if (statePresent) {
                float[] y = new float[4];
                boolean fullVolume = true;
                for (int i2 = 0; i2 < 4; ++i2) {
                    float value = (float)cornerRound[i2] / 864.0f;
                    if (value < 1.0f) {
                        fullVolume = false;
                    }
                    y[i2] = this.gas ? 1.0f - value : value;
                }
                boolean isFlowing = flowRound > -1000;
                float flow = isFlowing ? (float)Math.toRadians(flowRound) : 0.0f;
                TextureAtlasSprite topSprite = isFlowing ? this.flowing : this.still;
                float scale = isFlowing ? 4.0f : 8.0f;
                float c = MathHelper.cos(flow) * scale;
                float s = MathHelper.sin(flow) * scale;
                EnumFacing top = this.gas ? EnumFacing.DOWN : EnumFacing.UP;
                VertexParameter uv = i -> c * (float)(x[i] * 2 - 1) + s * (float)(z[i] * 2 - 1);
                VertexParameter topX = i -> x[i];
                VertexParameter topY = i -> y[i];
                VertexParameter topZ = i -> z[i];
                VertexParameter topU = i -> 8.0f + uv.get(i);
                VertexParameter topV = i -> 8.0f + uv.get((i + 1) % 4);
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.add((Object)this.buildQuad(top, topSprite, this.gas, false, topX, topY, topZ, topU, topV));
                if (!fullVolume) {
                    builder.add((Object)this.buildQuad(top, topSprite, !this.gas, true, topX, topY, topZ, topU, topV));
                }
                faceQuads.put(top, builder.build());
                EnumFacing bottom = top.getOpposite();
                faceQuads.put(bottom, ImmutableList.of((Object)this.buildQuad(bottom, this.still, this.gas, false, i -> z[i], i -> this.gas ? 1.0f : 0.0f, i -> x[i], i -> z[i] * 16, i -> x[i] * 16)));
                for (int i3 = 0; i3 < 4; ++i3) {
                    EnumFacing side = EnumFacing.byHorizontalIndex((5 - i3) % 4);
                    boolean useOverlay = this.overlay.isPresent() && sideOverlays[side.getHorizontalIndex()];
                    int si = i3;
                    VertexParameter sideX = j -> x[(si + x[j]) % 4];
                    VertexParameter sideY = j -> z[j] == 0 ? (float)(this.gas ? 1 : 0) : y[(si + x[j]) % 4];
                    VertexParameter sideZ = j -> z[(si + x[j]) % 4];
                    VertexParameter sideU = j -> x[j] * 8;
                    VertexParameter sideV = j -> (this.gas ? sideY.get(j) : 1.0f - sideY.get(j)) * 8.0f;
                    ImmutableList.Builder builder2 = ImmutableList.builder();
                    if (!useOverlay) {
                        builder2.add((Object)this.buildQuad(side, this.flowing, this.gas, true, sideX, sideY, sideZ, sideU, sideV));
                    }
                    builder2.add((Object)this.buildQuad(side, useOverlay ? this.overlay.get() : this.flowing, !this.gas, false, sideX, sideY, sideZ, sideU, sideV));
                    faceQuads.put(side, builder2.build());
                }
            } else {
                faceQuads.put(EnumFacing.SOUTH, ImmutableList.of((Object)this.buildQuad(EnumFacing.UP, this.still, false, false, i -> z[i], i -> x[i], i -> 0.0f, i -> z[i] * 16, i -> x[i] * 16)));
            }
            return ImmutableMap.copyOf(faceQuads);
        }

        private BakedQuad buildQuad(EnumFacing side, TextureAtlasSprite texture, boolean flip, boolean offset, VertexParameter x, VertexParameter y, VertexParameter z, VertexParameter u, VertexParameter v) {
            UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(this.format);
            builder.setQuadOrientation(side);
            builder.setTexture(texture);
            builder.setQuadTint(0);
            boolean hasTransform = this.transformation.isPresent() && !this.transformation.get().isIdentity();
            IVertexConsumer consumer = hasTransform ? new TRSRTransformer(builder, this.transformation.get()) : builder;
            for (int i = 0; i < 4; ++i) {
                int vertex = flip ? 3 - i : i;
                this.putVertex(consumer, side, offset, x.get(vertex), y.get(vertex), z.get(vertex), texture.getInterpolatedU(u.get(vertex)), texture.getInterpolatedV(v.get(vertex)));
            }
            return builder.build();
        }

        private void putVertex(IVertexConsumer consumer, EnumFacing side, boolean offset, float x, float y, float z, float u, float v) {
            block6: for (int e = 0; e < this.format.getElementCount(); ++e) {
                switch (this.format.getElement(e).getUsage()) {
                    case POSITION: {
                        float dx = offset ? (float)side.getDirectionVec().getX() * 0.001f : 0.0f;
                        float dy = offset ? (float)side.getDirectionVec().getY() * 0.001f : 0.0f;
                        float dz = offset ? (float)side.getDirectionVec().getZ() * 0.001f : 0.0f;
                        consumer.put(e, x - dx, y - dy, z - dz, 1.0f);
                        continue block6;
                    }
                    case COLOR: {
                        float r = (float)(this.color >> 16 & 0xFF) / 255.0f;
                        float g = (float)(this.color >> 8 & 0xFF) / 255.0f;
                        float b = (float)(this.color & 0xFF) / 255.0f;
                        float a = (float)(this.color >> 24 & 0xFF) / 255.0f;
                        consumer.put(e, r, g, b, a);
                        continue block6;
                    }
                    case NORMAL: {
                        float offX = side.getXOffset();
                        float offY = side.getYOffset();
                        float offZ = side.getZOffset();
                        consumer.put(e, offX, offY, offZ, 0.0f);
                        continue block6;
                    }
                    case UV: {
                        if (this.format.getElement(e).getIndex() == 0) {
                            consumer.put(e, u, v, 0.0f, 1.0f);
                            continue block6;
                        }
                    }
                    default: {
                        consumer.put(e, new float[0]);
                    }
                }
            }
        }

        @Override
        public boolean isAmbientOcclusion() {
            return true;
        }

        @Override
        public boolean isGui3d() {
            return false;
        }

        @Override
        public boolean isBuiltInRenderer() {
            return false;
        }

        @Override
        public TextureAtlasSprite getParticleTexture() {
            return this.still;
        }

        @Override
        public List<BakedQuad> getQuads(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            return side == null ? ImmutableList.of() : (List)this.faceQuads.get((Object)side);
        }

        @Override
        public ItemOverrideList getOverrides() {
            return ItemOverrideList.NONE;
        }

        @Override
        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, type);
        }

        private static interface VertexParameter {
            public float get(int var1);
        }
    }

    public static enum FluidLoader implements ICustomModelLoader
    {
        INSTANCE;


        @Override
        public void onResourceManagerReload(IResourceManager resourceManager) {
        }

        @Override
        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.getNamespace().equals("forge") && (modelLocation.getPath().equals("fluid") || modelLocation.getPath().equals("models/block/fluid") || modelLocation.getPath().equals("models/item/fluid"));
        }

        @Override
        public IModel loadModel(ResourceLocation modelLocation) {
            return WATER;
        }
    }
}

