/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableList;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.TRSRTransformation;

public abstract class SimpleModelFontRenderer
extends FontRenderer {
    private float r;
    private float g;
    private float b;
    private float a;
    private final TRSRTransformation transform;
    private ImmutableList.Builder<BakedQuad> builder = ImmutableList.builder();
    private final VertexFormat format;
    private final Vector3f normal = new Vector3f(0.0f, 0.0f, 1.0f);
    private final EnumFacing orientation;
    private boolean fillBlanks = false;
    private TextureAtlasSprite sprite;
    private final Vector4f vec = new Vector4f();

    public SimpleModelFontRenderer(GameSettings settings, ResourceLocation font, TextureManager manager, boolean isUnicode, Matrix4f matrix, VertexFormat format) {
        super(settings, font, manager, isUnicode);
        this.transform = new TRSRTransformation(matrix);
        this.format = format;
        this.transform.transformNormal(this.normal);
        this.orientation = EnumFacing.getFacingFromVector(this.normal.x, this.normal.y, this.normal.z);
    }

    public void setSprite(TextureAtlasSprite sprite) {
        this.sprite = sprite;
        super.onResourceManagerReload(null);
    }

    public void setFillBlanks(boolean fillBlanks) {
        this.fillBlanks = fillBlanks;
    }

    @Override
    protected float renderDefaultChar(int pos, boolean italic) {
        float x = (float)(pos % 16) / 16.0f;
        float y = (float)(pos / 16) / 16.0f;
        float sh = italic ? 1.0f : 0.0f;
        float w = (float)this.charWidth[pos] - 1.01f;
        float h = (float)this.FONT_HEIGHT - 1.01f;
        float wt = w / 128.0f;
        float ht = h / 128.0f;
        UnpackedBakedQuad.Builder quadBuilder = new UnpackedBakedQuad.Builder(this.format);
        quadBuilder.setTexture(this.sprite);
        quadBuilder.setQuadOrientation(this.orientation);
        this.addVertex(quadBuilder, this.posX + sh, this.posY, x, y);
        this.addVertex(quadBuilder, this.posX - sh, this.posY + h, x, y + ht);
        this.addVertex(quadBuilder, this.posX + w + sh, this.posY + h, x + wt, y + ht);
        this.addVertex(quadBuilder, this.posX + w - sh, this.posY, x + wt, y);
        this.builder.add((Object)quadBuilder.build());
        if (this.fillBlanks) {
            float cuv = 0.9375f;
            quadBuilder = new UnpackedBakedQuad.Builder(this.format);
            quadBuilder.setTexture(this.sprite);
            quadBuilder.setQuadOrientation(this.orientation);
            this.addVertex(quadBuilder, this.posX + w + sh, this.posY, cuv, cuv);
            this.addVertex(quadBuilder, this.posX + w - sh, this.posY + h, cuv, cuv);
            this.addVertex(quadBuilder, this.posX + (float)this.charWidth[pos] + sh, this.posY + h, cuv, cuv);
            this.addVertex(quadBuilder, this.posX + (float)this.charWidth[pos] - sh, this.posY, cuv, cuv);
            this.builder.add((Object)quadBuilder.build());
            quadBuilder = new UnpackedBakedQuad.Builder(this.format);
            quadBuilder.setTexture(this.sprite);
            quadBuilder.setQuadOrientation(this.orientation);
            this.addVertex(quadBuilder, this.posX + sh, this.posY + h, cuv, cuv);
            this.addVertex(quadBuilder, this.posX - sh, this.posY + (float)this.FONT_HEIGHT, cuv, cuv);
            this.addVertex(quadBuilder, this.posX + (float)this.charWidth[pos] + sh, this.posY + (float)this.FONT_HEIGHT, cuv, cuv);
            this.addVertex(quadBuilder, this.posX + (float)this.charWidth[pos] - sh, this.posY + h, cuv, cuv);
            this.builder.add((Object)quadBuilder.build());
        }
        return this.charWidth[pos];
    }

    private void addVertex(UnpackedBakedQuad.Builder quadBuilder, float x, float y, float u, float v) {
        block6: for (int e = 0; e < this.format.getElementCount(); ++e) {
            switch (this.format.getElement(e).getUsage()) {
                case POSITION: {
                    this.vec.set(x, y, 0.0f, 1.0f);
                    this.transform.transformPosition(this.vec);
                    quadBuilder.put(e, this.vec.x, this.vec.y, this.vec.z, this.vec.w);
                    continue block6;
                }
                case COLOR: {
                    quadBuilder.put(e, this.r, this.g, this.b, this.a);
                    continue block6;
                }
                case NORMAL: {
                    quadBuilder.put(e, 0.0f, 0.0f, 1.0f, 1.0f);
                    continue block6;
                }
                case UV: {
                    if (this.format.getElement(e).getIndex() == 0) {
                        quadBuilder.put(e, this.sprite.getInterpolatedU(u * 16.0f), this.sprite.getInterpolatedV(v * 16.0f), 0.0f, 1.0f);
                        continue block6;
                    }
                }
                default: {
                    quadBuilder.put(e, new float[0]);
                }
            }
        }
    }

    @Override
    public void onResourceManagerReload(IResourceManager resourceManager) {
        super.onResourceManagerReload(resourceManager);
        String p = this.locationFontTexture.getPath();
        if (p.startsWith("textures/")) {
            p = p.substring("textures/".length(), p.length());
        }
        if (p.endsWith(".png")) {
            p = p.substring(0, p.length() - ".png".length());
        }
        String f = this.locationFontTexture.getNamespace() + ":" + p;
        this.sprite = Minecraft.getMinecraft().getTextureMapBlocks().getAtlasSprite(f);
    }

    @Override
    protected abstract float renderUnicodeChar(char var1, boolean var2);

    @Override
    protected void doDraw(float shift) {
        this.posX += (float)((int)shift);
    }

    @Override
    protected void setColor(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    @Override
    public void enableAlpha() {
    }

    @Override
    protected void bindTexture(ResourceLocation location) {
    }

    public ImmutableList<BakedQuad> build() {
        ImmutableList ret = this.builder.build();
        this.builder = ImmutableList.builder();
        return ret;
    }
}

