/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.animation;

import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.pipeline.VertexBufferConsumer;
import net.minecraftforge.client.model.pipeline.VertexLighterFlat;
import net.minecraftforge.common.animation.Event;
import net.minecraftforge.common.animation.IEventHandler;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.animation.CapabilityAnimation;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;
import org.apache.commons.lang3.tuple.Pair;

@Deprecated
public class AnimationModelBase<T extends Entity>
extends ModelBase
implements IEventHandler<T> {
    private final VertexLighterFlat lighter;
    private final ResourceLocation modelLocation;

    public AnimationModelBase(ResourceLocation modelLocation, VertexLighterFlat lighter) {
        this.modelLocation = modelLocation;
        this.lighter = lighter;
    }

    @Override
    public void render(Entity entity, float limbSwing, float limbSwingSpeed, float timeAlive, float yawHead, float rotationPitch, float scale) {
        IAnimationStateMachine capability = entity.getCapability(CapabilityAnimation.ANIMATION_CAPABILITY, null);
        if (capability == null) {
            return;
        }
        Pair<IModelState, Iterable<Event>> pair = capability.apply(timeAlive / 20.0f);
        this.handleEvents(entity, timeAlive / 20.0f, (Iterable<Event>)((Iterable)pair.getRight()));
        IModel model = ModelLoaderRegistry.getModelOrMissing(this.modelLocation);
        IBakedModel bakedModel = model.bake((IModelState)pair.getLeft(), DefaultVertexFormats.ITEM, ModelLoader.defaultTextureGetter());
        BlockPos pos = new BlockPos(entity.posX, entity.posY + (double)entity.height, entity.posZ);
        RenderHelper.disableStandardItemLighting();
        GlStateManager.pushMatrix();
        GlStateManager.rotate(180.0f, 0.0f, 0.0f, 1.0f);
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder builder = tessellator.getBuffer();
        builder.begin(7, DefaultVertexFormats.BLOCK);
        builder.setTranslation(-0.5, -1.5, -0.5);
        this.lighter.setParent(new VertexBufferConsumer(builder));
        this.lighter.setWorld(entity.world);
        this.lighter.setState(Blocks.AIR.getDefaultState());
        this.lighter.setBlockPos(pos);
        boolean empty = true;
        List<BakedQuad> quads = bakedModel.getQuads(null, null, 0L);
        if (!quads.isEmpty()) {
            this.lighter.updateBlockInfo();
            empty = false;
            for (BakedQuad quad : quads) {
                quad.pipe(this.lighter);
            }
        }
        for (EnumFacing side : EnumFacing.values()) {
            quads = bakedModel.getQuads(null, side, 0L);
            if (quads.isEmpty()) continue;
            if (empty) {
                this.lighter.updateBlockInfo();
            }
            empty = false;
            for (BakedQuad quad : quads) {
                quad.pipe(this.lighter);
            }
        }
        builder.setTranslation(0.0, 0.0, 0.0);
        tessellator.draw();
        GlStateManager.popMatrix();
        RenderHelper.enableStandardItemLighting();
    }

    @Override
    public void handleEvents(T instance, float time, Iterable<Event> pastEvents) {
    }
}

