/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.obj;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.io.IOUtils;

public enum OBJLoader implements ICustomModelLoader
{
    INSTANCE;

    private IResourceManager manager;
    private final Set<String> enabledDomains = new HashSet<String>();

    public void addDomain(String domain) {
        this.enabledDomains.add(domain.toLowerCase());
        FMLLog.log.info("OBJLoader: Domain {} has been added.", (Object)domain.toLowerCase());
    }

    @Override
    public void onResourceManagerReload(IResourceManager resourceManager) {
        this.manager = resourceManager;
    }

    @Override
    public boolean accepts(ResourceLocation modelLocation) {
        return this.enabledDomains.contains(modelLocation.getNamespace()) && modelLocation.getPath().endsWith(".obj");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IModel loadModel(ResourceLocation modelLocation) throws Exception {
        OBJModel oBJModel;
        ResourceLocation file = new ResourceLocation(modelLocation.getNamespace(), modelLocation.getPath());
        IResource resource = null;
        try {
            OBJModel model;
            try {
                resource = this.manager.getResource(file);
            }
            catch (FileNotFoundException e) {
                if (modelLocation.getPath().startsWith("models/block/")) {
                    resource = this.manager.getResource(new ResourceLocation(file.getNamespace(), "models/item/" + file.getPath().substring("models/block/".length())));
                }
                if (modelLocation.getPath().startsWith("models/item/")) {
                    resource = this.manager.getResource(new ResourceLocation(file.getNamespace(), "models/block/" + file.getPath().substring("models/item/".length())));
                }
                throw e;
            }
            OBJModel.Parser parser = new OBJModel.Parser(resource, this.manager);
            try {
                model = parser.parse();
            }
            catch (Exception e) {
                throw new ModelLoaderRegistry.LoaderException("Error loading model previously: " + String.valueOf(file), e);
            }
            oBJModel = model;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(resource);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)resource);
        return oBJModel;
    }
}

