/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;

public class DungeonHooks {
    private static ArrayList<DungeonMob> dungeonMobs = new ArrayList();

    public static float addDungeonMob(ResourceLocation name, int rarity) {
        if (rarity <= 0) {
            throw new IllegalArgumentException("Rarity must be greater then zero");
        }
        for (DungeonMob mob : dungeonMobs) {
            if (!name.equals(mob.type)) continue;
            return mob.itemWeight += rarity;
        }
        dungeonMobs.add(new DungeonMob(rarity, name));
        return rarity;
    }

    public static int removeDungeonMob(ResourceLocation name) {
        for (DungeonMob mob : dungeonMobs) {
            if (!name.equals(mob.type)) continue;
            dungeonMobs.remove(mob);
            return mob.itemWeight;
        }
        return 0;
    }

    public static ResourceLocation getRandomDungeonMob(Random rand) {
        DungeonMob mob = WeightedRandom.getRandomItem(rand, dungeonMobs);
        return mob.type;
    }

    static {
        DungeonHooks.addDungeonMob(new ResourceLocation("skeleton"), 100);
        DungeonHooks.addDungeonMob(new ResourceLocation("zombie"), 200);
        DungeonHooks.addDungeonMob(new ResourceLocation("spider"), 100);
    }

    public static class DungeonMob
    extends WeightedRandom.Item {
        public ResourceLocation type;

        public DungeonMob(int weight, ResourceLocation type) {
            super(weight);
            this.type = type;
        }

        public boolean equals(Object target) {
            return target instanceof DungeonMob && this.type.equals(((DungeonMob)target).type);
        }
    }
}

