/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.WorldWorkerManager;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ForgeInternalHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity newEntity;
        ItemStack stack;
        Item item;
        Entity entity;
        if (!event.getWorld().isRemote) {
            ForgeChunkManager.loadEntity(event.getEntity());
        }
        if ((entity = event.getEntity()).getClass().equals(EntityItem.class) && (item = (stack = ((EntityItem)entity).getItem()).getItem()).hasCustomEntity(stack) && (newEntity = item.createEntity(event.getWorld(), entity, stack)) != null) {
            entity.setDead();
            event.setCanceled(true);
            event.getWorld().spawnEntity(newEntity);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDimensionLoad(WorldEvent.Load event) {
        ForgeChunkManager.loadWorld(event.getWorld());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDimensionSave(WorldEvent.Save event) {
        ForgeChunkManager.saveWorld(event.getWorld());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDimensionUnload(WorldEvent.Unload event) {
        ForgeChunkManager.unloadWorld(event.getWorld());
        if (event.getWorld() instanceof WorldServer) {
            FakePlayerFactory.unloadWorld((WorldServer)event.getWorld());
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        WorldWorkerManager.tick(event.phase == TickEvent.Phase.START);
    }

    @SubscribeEvent
    public void checkSettings(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            FMLClientHandler.instance().updateCloudSettings();
        }
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload event) {
        if (!event.getWorld().isRemote) {
            FarmlandWaterManager.removeTickets(event.getChunk());
        }
    }
}

