/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeInternalHandler;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ICrashCallable;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.oredict.OreDictionary;

public class MinecraftForge {
    public static final EventBus EVENT_BUS = new EventBus();
    public static final EventBus TERRAIN_GEN_BUS = new EventBus();
    public static final EventBus ORE_GEN_BUS = new EventBus();
    public static final String MC_VERSION = "1.12.2";
    static final ForgeInternalHandler INTERNAL_HANDLER = new ForgeInternalHandler();

    public static void addGrassSeed(@Nonnull ItemStack seed, int weight) {
        MinecraftForge.addGrassSeed(new ForgeHooks.SeedEntry(seed, weight));
    }

    public static void addGrassSeed(ForgeHooks.SeedEntry seed) {
        ForgeHooks.seedList.add(seed);
    }

    public static void initialize() {
        FMLLog.log.info("Cleanroom v{} Initialized", (Object)"0.3.35-alpha");
        OreDictionary.getOreName(0);
        UsernameCache.load();
        FluidRegistry.validateFluidRegistry();
        ForgeHooks.initTools();
        new CrashReport("ThisIsFake", new Exception("Not real"));
    }

    public static void preloadCrashClasses(ASMDataTable table, String modID, Set<String> classes) {
        ArrayList all = Lists.newArrayList();
        for (ASMDataTable.ASMData asm : table.getAll(ICrashReportDetail.class)) {
            all.add(asm.getClassName());
        }
        for (ASMDataTable.ASMData asm : table.getAll(ICrashCallable.class)) {
            all.add(asm.getClassName());
        }
        all.retainAll(classes);
        if (all.size() == 0) {
            return;
        }
        ForgeModContainer.log.debug("Preloading CrashReport Classes");
        Collections.sort(all);
        for (String name : all) {
            ForgeModContainer.log.debug("\t{}", (Object)name);
            try {
                Class.forName(name.replace('/', '.'), false, MinecraftForge.class.getClassLoader());
            }
            catch (Exception e) {
                FMLLog.log.error("Could not find class for name '{}'.", (Object)name, (Object)e);
            }
        }
    }
}

