/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.brewing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.brewing.BrewingOreRecipe;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.brewing.VanillaBrewingRecipe;

public class BrewingRecipeRegistry {
    private static List<IBrewingRecipe> recipes = new ArrayList<IBrewingRecipe>();

    public static boolean addRecipe(@Nonnull ItemStack input, @Nonnull ItemStack ingredient, @Nonnull ItemStack output) {
        return BrewingRecipeRegistry.addRecipe(new BrewingRecipe(input, ingredient, output));
    }

    public static boolean addRecipe(@Nonnull ItemStack input, @Nonnull String ingredient, @Nonnull ItemStack output) {
        return BrewingRecipeRegistry.addRecipe(new BrewingOreRecipe(input, ingredient, output));
    }

    public static boolean addRecipe(IBrewingRecipe recipe) {
        return recipes.add(recipe);
    }

    @Nonnull
    public static ItemStack getOutput(@Nonnull ItemStack input, @Nonnull ItemStack ingredient) {
        if (input.isEmpty() || input.getCount() != 1) {
            return ItemStack.EMPTY;
        }
        if (ingredient.isEmpty()) {
            return ItemStack.EMPTY;
        }
        for (IBrewingRecipe recipe : recipes) {
            ItemStack output = recipe.getOutput(input, ingredient);
            if (output.isEmpty()) continue;
            return output;
        }
        return ItemStack.EMPTY;
    }

    public static boolean hasOutput(@Nonnull ItemStack input, @Nonnull ItemStack ingredient) {
        return !BrewingRecipeRegistry.getOutput(input, ingredient).isEmpty();
    }

    public static boolean canBrew(NonNullList<ItemStack> inputs, @Nonnull ItemStack ingredient, int[] inputIndexes) {
        if (ingredient.isEmpty()) {
            return false;
        }
        for (int i : inputIndexes) {
            if (!BrewingRecipeRegistry.hasOutput(inputs.get(i), ingredient)) continue;
            return true;
        }
        return false;
    }

    public static void brewPotions(NonNullList<ItemStack> inputs, @Nonnull ItemStack ingredient, int[] inputIndexes) {
        for (int i : inputIndexes) {
            ItemStack output = BrewingRecipeRegistry.getOutput(inputs.get(i), ingredient);
            if (output.isEmpty()) continue;
            inputs.set(i, output);
        }
    }

    public static boolean isValidIngredient(@Nonnull ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        for (IBrewingRecipe recipe : recipes) {
            if (!recipe.isIngredient(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidInput(@Nonnull ItemStack stack) {
        if (stack.getCount() != 1) {
            return false;
        }
        for (IBrewingRecipe recipe : recipes) {
            if (!recipe.isInput(stack)) continue;
            return true;
        }
        return false;
    }

    public static List<IBrewingRecipe> getRecipes() {
        return Collections.unmodifiableList(recipes);
    }

    static {
        BrewingRecipeRegistry.addRecipe(new VanillaBrewingRecipe());
    }
}

