/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.chunkio;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.chunkio.ChunkIOProvider;
import net.minecraftforge.common.chunkio.ChunkIOThreadPoolExecutor;
import net.minecraftforge.common.chunkio.QueuedChunk;
import net.minecraftforge.fml.common.FMLLog;

public class ChunkIOExecutor {
    private static final int BASE_THREADS = 1;
    private static final int PLAYERS_PER_THREAD = 50;
    private static final Map<QueuedChunk, ChunkIOProvider> tasks = Maps.newConcurrentMap();
    private static final ThreadPoolExecutor pool = new ChunkIOThreadPoolExecutor(1, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
        private AtomicInteger count = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "Chunk I/O Executor Thread-" + this.count.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Chunk syncChunkLoad(World world, AnvilChunkLoader loader, ChunkProviderServer provider, int x, int z) {
        QueuedChunk key = new QueuedChunk(x, z, world);
        ChunkIOProvider task = tasks.remove(key);
        if (task != null) {
            if (!pool.remove(task)) {
                ChunkIOProvider chunkIOProvider = task;
                synchronized (chunkIOProvider) {
                    while (!task.runFinished()) {
                        try {
                            task.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else {
                task.run();
            }
        } else {
            task = new ChunkIOProvider(key, loader, provider);
            task.run();
        }
        task.syncCallback();
        return task.getChunk();
    }

    public static void queueChunkLoad(World world, AnvilChunkLoader loader, ChunkProviderServer provider, int x, int z, Runnable runnable) {
        QueuedChunk key = new QueuedChunk(x, z, world);
        ChunkIOProvider task = tasks.get(key);
        if (task == null) {
            task = new ChunkIOProvider(key, loader, provider);
            task.addCallback(runnable);
            tasks.put(key, task);
            pool.execute(task);
        } else {
            task.addCallback(runnable);
        }
    }

    public static void dropQueuedChunkLoad(World world, int x, int z, Runnable runnable) {
        QueuedChunk key = new QueuedChunk(x, z, world);
        ChunkIOProvider task = tasks.get(key);
        if (task == null) {
            FMLLog.log.warn("Attempted to dequeue chunk that wasn't queued? {} @ ({}, {})", (Object)world.provider.getDimension(), (Object)x, (Object)z);
            return;
        }
        task.removeCallback(runnable);
        if (!task.hasCallback()) {
            tasks.remove(key);
            pool.remove(task);
        }
    }

    public static void adjustPoolSize(int players) {
        pool.setCorePoolSize(Math.max(1, players / 50));
    }

    public static void tick() {
        Iterator<ChunkIOProvider> itr = tasks.values().iterator();
        while (itr.hasNext()) {
            ChunkIOProvider task = itr.next();
            if (!task.runFinished()) continue;
            if (task.hasCallback()) {
                task.syncCallback();
            }
            itr.remove();
        }
    }
}

