/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.chunkio;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.chunkio.QueuedChunk;
import net.minecraftforge.event.world.ChunkDataEvent;

class ChunkIOProvider
implements Runnable {
    private final QueuedChunk chunkInfo;
    private final AnvilChunkLoader loader;
    private final ChunkProviderServer provider;
    private Chunk chunk;
    private NBTTagCompound nbt;
    private final ConcurrentLinkedQueue<Runnable> callbacks = new ConcurrentLinkedQueue();
    private boolean ran = false;

    ChunkIOProvider(QueuedChunk chunk, AnvilChunkLoader loader, ChunkProviderServer provider) {
        this.chunkInfo = chunk;
        this.loader = loader;
        this.provider = provider;
    }

    public void addCallback(Runnable callback) {
        this.callbacks.add(callback);
    }

    public void removeCallback(Runnable callback) {
        this.callbacks.remove(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ChunkIOProvider chunkIOProvider = this;
        synchronized (chunkIOProvider) {
            try {
                Object[] data = null;
                try {
                    data = this.loader.loadChunk__Async(this.chunkInfo.world, this.chunkInfo.x, this.chunkInfo.z);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (data != null) {
                    this.nbt = (NBTTagCompound)data[1];
                    this.chunk = (Chunk)data[0];
                }
            }
            finally {
                this.ran = true;
                this.notifyAll();
            }
        }
    }

    public void syncCallback() {
        if (this.chunk == null) {
            this.runCallbacks();
            return;
        }
        this.loader.loadEntities(this.chunkInfo.world, this.nbt.getCompoundTag("Level"), this.chunk);
        MinecraftForge.EVENT_BUS.post(new ChunkDataEvent.Load(this.chunk, this.nbt));
        this.chunk.setLastSaveTime(this.provider.world.getTotalWorldTime());
        this.provider.chunkGenerator.recreateStructures(this.chunk, this.chunkInfo.x, this.chunkInfo.z);
        this.provider.loadedChunks.put(ChunkPos.asLong(this.chunkInfo.x, this.chunkInfo.z), (Object)this.chunk);
        this.chunk.onLoad();
        this.chunk.populate(this.provider, this.provider.chunkGenerator);
        this.runCallbacks();
    }

    public Chunk getChunk() {
        return this.chunk;
    }

    public boolean runFinished() {
        return this.ran;
    }

    public boolean hasCallback() {
        return this.callbacks.size() > 0;
    }

    public void runCallbacks() {
        for (Runnable r : this.callbacks) {
            r.run();
        }
        this.callbacks.clear();
    }

    public QueuedChunk getChunkInfo() {
        return this.chunkInfo;
    }
}

