/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;

public class CompoundIngredient
extends Ingredient {
    private Collection<Ingredient> children;
    private ItemStack[] stacks;
    private IntList itemIds;
    private final boolean isSimple;

    protected CompoundIngredient(Collection<Ingredient> children) {
        super(0);
        this.children = children;
        boolean simple = true;
        for (Ingredient child : children) {
            simple &= child.isSimple();
        }
        this.isSimple = simple;
    }

    @Override
    @Nonnull
    public ItemStack[] getMatchingStacks() {
        if (this.stacks == null) {
            ArrayList tmp = Lists.newArrayList();
            for (Ingredient child : this.children) {
                Collections.addAll(tmp, child.getMatchingStacks());
            }
            this.stacks = tmp.toArray(new ItemStack[tmp.size()]);
        }
        return this.stacks;
    }

    @Override
    @Nonnull
    public IntList getValidItemStacksPacked() {
        if (this.itemIds == null) {
            this.itemIds = new IntArrayList();
            for (Ingredient child : this.children) {
                this.itemIds.addAll(child.getValidItemStacksPacked());
            }
            this.itemIds.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.itemIds;
    }

    @Override
    public boolean apply(@Nullable ItemStack target) {
        if (target == null) {
            return false;
        }
        for (Ingredient child : this.children) {
            if (!child.apply(target)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void invalidate() {
        this.itemIds = null;
        this.stacks = null;
    }

    @Override
    public boolean isSimple() {
        return this.isSimple;
    }

    @Nonnull
    public Collection<Ingredient> getChildren() {
        return Collections.unmodifiableCollection(this.children);
    }
}

