/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.IConditionFactory;
import net.minecraftforge.common.crafting.IIngredientFactory;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.IngredientNBT;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.RegistryManager;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class CraftingHelper {
    private static final boolean DEBUG_LOAD_MINECRAFT = false;
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Map<ResourceLocation, IConditionFactory> conditions = Maps.newHashMap();
    private static final Map<ResourceLocation, IIngredientFactory> ingredients = Maps.newHashMap();
    private static final Map<ResourceLocation, IRecipeFactory> recipes = Maps.newHashMap();
    public static final FactoryLoader<IIngredientFactory> INGREDIENTS;
    public static final FactoryLoader<IRecipeFactory> RECIPES;
    public static final FactoryLoader<IConditionFactory> CONDITIONS;

    public static void register(ResourceLocation key, IConditionFactory factory) {
        if (conditions.containsKey(key)) {
            throw new IllegalStateException("Duplicate recipe condition factory: " + String.valueOf(key));
        }
        conditions.put(key, factory);
    }

    public static void register(ResourceLocation key, IRecipeFactory factory) {
        if (recipes.containsKey(key)) {
            throw new IllegalStateException("Duplicate recipe factory: " + String.valueOf(key));
        }
        recipes.put(key, factory);
    }

    public static void register(ResourceLocation key, IIngredientFactory factory) {
        if (ingredients.containsKey(key)) {
            throw new IllegalStateException("Duplicate recipe ingredient factory: " + String.valueOf(key));
        }
        ingredients.put(key, factory);
    }

    public static Ingredient getIngredient(Object obj) {
        if (obj instanceof Ingredient) {
            return (Ingredient)obj;
        }
        if (obj instanceof ItemStack) {
            return Ingredient.fromStacks(((ItemStack)obj).copy());
        }
        if (obj instanceof Item) {
            return Ingredient.fromItem((Item)obj);
        }
        if (obj instanceof Block) {
            return Ingredient.fromStacks(new ItemStack((Block)obj, 1, Short.MAX_VALUE));
        }
        if (obj instanceof String) {
            return new OreIngredient((String)obj);
        }
        if (obj instanceof JsonElement) {
            throw new IllegalArgumentException("JsonObjects must use getIngredient(JsonObject, JsonContext)");
        }
        return null;
    }

    @Nonnull
    public static Ingredient getIngredient(JsonElement json, JsonContext context) {
        String item;
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Json cannot be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("getIngredient Context cannot be null");
        }
        if (json.isJsonArray()) {
            ArrayList ingredients = Lists.newArrayList();
            ArrayList vanilla = Lists.newArrayList();
            json.getAsJsonArray().forEach(ele -> {
                Ingredient ing = CraftingHelper.getIngredient(ele, context);
                if (ing.getClass() == Ingredient.class) {
                    vanilla.add(ing);
                } else {
                    ingredients.add(ing);
                }
            });
            if (!vanilla.isEmpty()) {
                ingredients.add(Ingredient.merge(vanilla));
            }
            if (ingredients.isEmpty()) {
                throw new JsonSyntaxException("Item array cannot be empty, at least one item must be defined");
            }
            if (ingredients.size() == 1) {
                return (Ingredient)ingredients.getFirst();
            }
            return new CompoundIngredient(ingredients);
        }
        if (!json.isJsonObject()) {
            throw new JsonSyntaxException("Expcted ingredient to be a object or array of objects");
        }
        JsonObject obj = (JsonObject)json;
        String type = context.appendModId(JsonUtils.getString(obj, "type", "minecraft:item"));
        if (type.isEmpty()) {
            throw new JsonSyntaxException("Ingredient type can not be an empty string");
        }
        if (type.equals("minecraft:item") && (item = JsonUtils.getString(obj, "item")).startsWith("#")) {
            Ingredient constant = context.getConstant(item.substring(1));
            if (constant == null) {
                throw new JsonSyntaxException("Ingredient referenced invalid constant: " + item);
            }
            return constant;
        }
        IIngredientFactory factory = ingredients.get(new ResourceLocation(type));
        if (factory == null) {
            throw new JsonSyntaxException("Unknown ingredient type: " + type);
        }
        return factory.parse(context, obj);
    }

    public static ItemStack getItemStack(JsonObject json, JsonContext context) {
        String itemName = context.appendModId(JsonUtils.getString(json, "item"));
        Item item = ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
        if (item == null) {
            throw new JsonSyntaxException("Unknown item '" + itemName + "'");
        }
        if (item.getHasSubtypes() && !json.has("data")) {
            throw new JsonParseException("Missing data for item '" + itemName + "'");
        }
        if (json.has("nbt")) {
            try {
                JsonElement element = json.get("nbt");
                NBTTagCompound nbt = element.isJsonObject() ? JsonToNBT.getTagFromJson(GSON.toJson(element)) : JsonToNBT.getTagFromJson(JsonUtils.getString(element, "nbt"));
                NBTTagCompound tmp = new NBTTagCompound();
                if (nbt.hasKey("ForgeCaps")) {
                    tmp.setTag("ForgeCaps", nbt.getTag("ForgeCaps"));
                    nbt.removeTag("ForgeCaps");
                }
                tmp.setTag("tag", nbt);
                tmp.setString("id", itemName);
                tmp.setInteger("Count", JsonUtils.getInt(json, "count", 1));
                tmp.setInteger("Damage", JsonUtils.getInt(json, "data", 0));
                return new ItemStack(tmp);
            }
            catch (NBTException e) {
                throw new JsonSyntaxException("Invalid NBT Entry: " + e.toString());
            }
        }
        return new ItemStack(item, JsonUtils.getInt(json, "count", 1), JsonUtils.getInt(json, "data", 0));
    }

    public static ItemStack getItemStackBasic(JsonObject json, JsonContext context) {
        String itemName = context.appendModId(JsonUtils.getString(json, "item"));
        Item item = ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
        if (item == null) {
            throw new JsonSyntaxException("Unknown item '" + itemName + "'");
        }
        if (item.getHasSubtypes() && !json.has("data")) {
            throw new JsonParseException("Missing data for item '" + itemName + "'");
        }
        return new ItemStack(item, 1, JsonUtils.getInt(json, "data", 0));
    }

    public static ShapedPrimer parseShaped(Object ... recipe) {
        ShapedPrimer ret = new ShapedPrimer();
        Object shape = "";
        int idx = 0;
        if (recipe[idx] instanceof Boolean) {
            ret.mirrored = (Boolean)recipe[idx];
            if (recipe[idx + 1] instanceof Object[]) {
                recipe = (Object[])recipe[idx + 1];
            } else {
                idx = 1;
            }
        }
        if (recipe[idx] instanceof String[]) {
            String[] parts = (String[])recipe[idx++];
            for (String s : parts) {
                ret.width = s.length();
                shape = (String)shape + s;
            }
            ret.height = parts.length;
        } else {
            while (recipe[idx] instanceof String) {
                String s = (String)recipe[idx++];
                shape = (String)shape + s;
                ret.width = s.length();
                ++ret.height;
            }
        }
        if (ret.width * ret.height != ((String)shape).length() || ((String)shape).isEmpty()) {
            Object err = "Invalid shaped recipe: ";
            for (Object tmp : recipe) {
                err = (String)err + String.valueOf(tmp) + ", ";
            }
            throw new RuntimeException((String)err);
        }
        HashMap itemMap = Maps.newHashMap();
        itemMap.put(Character.valueOf(' '), Ingredient.EMPTY);
        while (idx < recipe.length) {
            Character chr = (Character)recipe[idx];
            Object in = recipe[idx + 1];
            Ingredient ing = CraftingHelper.getIngredient(in);
            if (' ' == chr.charValue()) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            if (ing == null) {
                Object err = "Invalid shaped ore recipe: ";
                for (Object tmp : recipe) {
                    err = (String)err + String.valueOf(tmp) + ", ";
                }
                throw new RuntimeException((String)err);
            }
            itemMap.put(chr, ing);
            idx += 2;
        }
        ret.input = NonNullList.withSize(ret.width * ret.height, Ingredient.EMPTY);
        HashSet keys = Sets.newHashSet(itemMap.keySet());
        keys.remove(Character.valueOf(' '));
        int x = 0;
        for (char chr : ((String)shape).toCharArray()) {
            Ingredient ing = (Ingredient)itemMap.get(Character.valueOf(chr));
            if (ing == null) {
                throw new IllegalArgumentException("Pattern references symbol '" + chr + "' but it's not defined in the key");
            }
            ret.input.set(x++, ing);
            keys.remove(Character.valueOf(chr));
        }
        if (!keys.isEmpty()) {
            throw new IllegalArgumentException("Key defines symbols that aren't used in pattern: " + String.valueOf(keys));
        }
        return ret;
    }

    public static boolean processConditions(JsonObject json, String memberName, JsonContext context) {
        return !json.has(memberName) || CraftingHelper.processConditions(JsonUtils.getJsonArray(json, memberName), context);
    }

    public static boolean processConditions(JsonArray conditions, JsonContext context) {
        for (int x = 0; x < conditions.size(); ++x) {
            if (!conditions.get(x).isJsonObject()) {
                throw new JsonSyntaxException("Conditions must be an array of JsonObjects");
            }
            JsonObject json = conditions.get(x).getAsJsonObject();
            BooleanSupplier cond = CraftingHelper.getCondition(json, context);
            if (cond.getAsBoolean()) continue;
            return false;
        }
        return true;
    }

    public static BooleanSupplier getCondition(JsonObject json, JsonContext context) {
        ResourceLocation type = new ResourceLocation(context.appendModId(JsonUtils.getString(json, "type")));
        IConditionFactory factory = conditions.get(type);
        if (factory == null) {
            throw new JsonSyntaxException("Unknown condition type: " + type.toString());
        }
        return factory.parse(context, json);
    }

    public static IRecipe getRecipe(JsonObject json, JsonContext context) {
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Json cannot be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("getRecipe Context cannot be null");
        }
        String type = context.appendModId(JsonUtils.getString(json, "type"));
        if (type.isEmpty()) {
            throw new JsonSyntaxException("Recipe type can not be an empty string");
        }
        IRecipeFactory factory = recipes.get(new ResourceLocation(type));
        if (factory == null) {
            throw new JsonSyntaxException("Unknown recipe type: " + type);
        }
        return factory.parse(context, json);
    }

    public static void init() {
        conditions.clear();
        ingredients.clear();
        recipes.clear();
        CraftingHelper.registerC("forge:mod_loaded", (context, json) -> {
            String modid = JsonUtils.getString(json, "modid");
            return () -> Loader.isModLoaded(modid);
        });
        CraftingHelper.registerC("minecraft:item_exists", (context, json) -> {
            String itemName = context.appendModId(JsonUtils.getString(json, "item"));
            return () -> ForgeRegistries.ITEMS.containsKey(new ResourceLocation(itemName));
        });
        CraftingHelper.registerC("forge:not", (context, json) -> {
            BooleanSupplier child = CraftingHelper.getCondition(JsonUtils.getJsonObject(json, "value"), context);
            return () -> !child.getAsBoolean();
        });
        CraftingHelper.registerC("forge:or", (context, json) -> {
            JsonArray values = JsonUtils.getJsonArray(json, "values");
            ArrayList children = Lists.newArrayList();
            for (JsonElement j : values) {
                if (!j.isJsonObject()) {
                    throw new JsonSyntaxException("Or condition values must be an array of JsonObjects");
                }
                children.add(CraftingHelper.getCondition(j.getAsJsonObject(), context));
            }
            return () -> children.stream().anyMatch(BooleanSupplier::getAsBoolean);
        });
        CraftingHelper.registerC("forge:and", (context, json) -> {
            JsonArray values = JsonUtils.getJsonArray(json, "values");
            ArrayList children = Lists.newArrayList();
            for (JsonElement j : values) {
                if (!j.isJsonObject()) {
                    throw new JsonSyntaxException("And condition values must be an array of JsonObjects");
                }
                children.add(CraftingHelper.getCondition(j.getAsJsonObject(), context));
            }
            return () -> children.stream().allMatch(BooleanSupplier::getAsBoolean);
        });
        CraftingHelper.registerC("forge:false", (context, json) -> () -> false);
        CraftingHelper.registerR("minecraft:crafting_shaped", (context, json) -> {
            String group = JsonUtils.getString(json, "group", "");
            HashMap ingMap = Maps.newHashMap();
            for (Map.Entry entry : JsonUtils.getJsonObject(json, "key").entrySet()) {
                if (((String)entry.getKey()).length() != 1) {
                    throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
                }
                if (" ".equals(entry.getKey())) {
                    throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
                }
                ingMap.put(Character.valueOf(((String)entry.getKey()).toCharArray()[0]), CraftingHelper.getIngredient((JsonElement)entry.getValue(), context));
            }
            ingMap.put(Character.valueOf(' '), Ingredient.EMPTY);
            JsonArray patternJ = JsonUtils.getJsonArray(json, "pattern");
            if (patternJ.isEmpty()) {
                throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
            }
            if (patternJ.size() > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
            }
            String[] pattern = new String[patternJ.size()];
            for (int x = 0; x < pattern.length; ++x) {
                String line = JsonUtils.getString(patternJ.get(x), "pattern[" + x + "]");
                if (line.length() > 3) {
                    throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
                }
                if (x > 0 && pattern[0].length() != line.length()) {
                    throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
                }
                pattern[x] = line;
            }
            NonNullList<Ingredient> input = NonNullList.withSize(pattern[0].length() * pattern.length, Ingredient.EMPTY);
            HashSet keys = Sets.newHashSet(ingMap.keySet());
            keys.remove(Character.valueOf(' '));
            int x = 0;
            for (String line : pattern) {
                for (char chr : line.toCharArray()) {
                    Ingredient ing = (Ingredient)ingMap.get(Character.valueOf(chr));
                    if (ing == null) {
                        throw new JsonSyntaxException("Pattern references symbol '" + chr + "' but it's not defined in the key");
                    }
                    input.set(x++, ing);
                    keys.remove(Character.valueOf(chr));
                }
            }
            if (!keys.isEmpty()) {
                throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + String.valueOf(keys));
            }
            ItemStack result = CraftingHelper.getItemStack(JsonUtils.getJsonObject(json, "result"), context);
            return new ShapedRecipes(group, pattern[0].length(), pattern.length, input, result);
        });
        CraftingHelper.registerR("minecraft:crafting_shapeless", (context, json) -> {
            String group = JsonUtils.getString(json, "group", "");
            NonNullList<Ingredient> ings = NonNullList.create();
            for (JsonElement ele : JsonUtils.getJsonArray(json, "ingredients")) {
                ings.add(CraftingHelper.getIngredient(ele, context));
            }
            if (ings.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (ings.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe");
            }
            ItemStack itemstack = CraftingHelper.getItemStack(JsonUtils.getJsonObject(json, "result"), context);
            return new ShapelessRecipes(group, itemstack, ings);
        });
        CraftingHelper.registerR("forge:ore_shaped", ShapedOreRecipe::factory);
        CraftingHelper.registerR("forge:ore_shapeless", ShapelessOreRecipe::factory);
        CraftingHelper.registerI("minecraft:item", (context, json) -> Ingredient.fromStacks(CraftingHelper.getItemStackBasic(json, context)));
        CraftingHelper.registerI("minecraft:empty", (context, json) -> Ingredient.EMPTY);
        CraftingHelper.registerI("minecraft:item_nbt", (context, json) -> new IngredientNBT(CraftingHelper.getItemStack(json, context)));
        CraftingHelper.registerI("forge:ore_dict", (context, json) -> new OreIngredient(JsonUtils.getString(json, "ore")));
    }

    private static void registerC(String name, IConditionFactory fac) {
        CraftingHelper.register(new ResourceLocation(name), fac);
    }

    private static void registerR(String name, IRecipeFactory fac) {
        CraftingHelper.register(new ResourceLocation(name), fac);
    }

    private static void registerI(String name, IIngredientFactory fac) {
        CraftingHelper.register(new ResourceLocation(name), fac);
    }

    private static void loadFactories(JsonObject json, JsonContext context, FactoryLoader<?> ... loaders) {
        for (FactoryLoader<?> loader : loaders) {
            CraftingHelper.loadFactory(json, context, loader);
        }
    }

    private static <T> void loadFactory(JsonObject json, JsonContext context, FactoryLoader<T> loader) {
        if (json.has(loader.name)) {
            for (Map.Entry entry : JsonUtils.getJsonObject(json, loader.name).entrySet()) {
                ResourceLocation key = new ResourceLocation(context.getModId(), (String)entry.getKey());
                String clsName = JsonUtils.getString((JsonElement)entry.getValue(), loader.name + "[" + String.valueOf(entry.getValue()) + "]");
                loader.consumer.accept(key, (ResourceLocation)CraftingHelper.getClassInstance(clsName, loader.type));
            }
        }
    }

    private static <T> T getClassInstance(String clsName, Class<T> expected) {
        try {
            Class<?> cls = Class.forName(clsName);
            if (!expected.isAssignableFrom(cls)) {
                throw new JsonSyntaxException("Class '" + clsName + "' is not an " + expected.getSimpleName());
            }
            return (T)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new JsonSyntaxException("Could not find " + expected.getSimpleName() + ": " + clsName, (Throwable)e);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new JsonSyntaxException("Could not instantiate " + expected.getSimpleName() + ": " + clsName, (Throwable)e);
        }
    }

    public static void loadRecipes(boolean revertFrozen) {
        CraftingHelper.init();
        ForgeRegistry reg = (ForgeRegistry)ForgeRegistries.RECIPES;
        if (revertFrozen) {
            GameData.revert(RegistryManager.FROZEN, GameData.RECIPES, false);
        }
        Loader.instance().setActiveModContainer(null);
        Loader.instance().getActiveModList().forEach(CraftingHelper::loadFactories);
        Loader.instance().getActiveModList().forEach(CraftingHelper::loadRecipes);
        Loader.instance().setActiveModContainer(null);
        GameData.fireRegistryEvents(rl -> rl.equals(GameData.RECIPES));
        FMLCommonHandler.instance().resetClientRecipeBook();
    }

    private static void loadFactories(ModContainer mod) {
        CraftingHelper.loadFactories(mod, "assets/" + mod.getModId() + "/recipes", INGREDIENTS, RECIPES, CONDITIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFactories(ModContainer mod, String base, FactoryLoader<?> ... loaders) {
        FileSystem fs = null;
        try {
            Path fPath = null;
            JsonContext ctx = new JsonContext(mod.getModId());
            if (mod.getResource().isFile()) {
                fs = FileSystems.newFileSystem(mod.getResource().toPath(), (ClassLoader)Launch.classLoader);
                fPath = fs.getPath("/" + base, "_factories.json");
            } else if (mod.getResource().isDirectory()) {
                fPath = mod.getResource().toPath().resolve(base).resolve("_factories.json");
            }
            if (fPath != null && Files.exists(fPath, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(fPath);){
                    JsonObject json = JsonUtils.fromJson(GSON, (Reader)reader, JsonObject.class);
                    CraftingHelper.loadFactories(json, ctx, loaders);
                }
            }
            IOUtils.closeQuietly((Closeable)fs);
        }
        catch (JsonParseException | IOException e) {
            FMLLog.log.error("Error loading _factories.json: ", e);
        }
        finally {
            IOUtils.closeQuietly(fs);
        }
    }

    private static boolean loadRecipes(ModContainer mod) {
        JsonContext ctx = new JsonContext(mod.getModId());
        return CraftingHelper.findFiles(mod, "assets/" + mod.getModId() + "/recipes", root -> {
            Path fPath = root.resolve("_constants.json");
            if (fPath != null && Files.exists(fPath, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(fPath);){
                    JsonObject[] json = JsonUtils.fromJson(GSON, (Reader)reader, JsonObject[].class);
                    ctx.loadConstants(json);
                }
                catch (JsonParseException | IOException e) {
                    FMLLog.log.error("Error loading _constants.json: ", e);
                    return false;
                }
            }
            return true;
        }, (root, file) -> {
            Loader.instance().setActiveModContainer(mod);
            String relative = root.relativize((Path)file).toString();
            if (!"json".equals(FilenameUtils.getExtension((String)file.toString()))) return true;
            if (relative.startsWith("_")) {
                return true;
            }
            String name = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
            ResourceLocation key = new ResourceLocation(ctx.getModId(), name);
            try (BufferedReader reader = Files.newBufferedReader(file);){
                JsonObject json = JsonUtils.fromJson(GSON, (Reader)reader, JsonObject.class);
                if (!CraftingHelper.processConditions(json, "conditions", ctx)) {
                    Boolean bl = true;
                    return bl;
                }
                IRecipe recipe = CraftingHelper.getRecipe(json, ctx);
                ForgeRegistries.RECIPES.register((IRecipe)recipe.setRegistryName(key));
                return true;
            }
            catch (JsonParseException e) {
                FMLLog.log.error("Parsing error loading recipe {}", (Object)key, (Object)e);
                return false;
            }
            catch (IOException e) {
                FMLLog.log.error("Couldn't read recipe {} from {}", (Object)key, file, (Object)e);
                return false;
            }
        }, true, true);
    }

    @Deprecated
    public static boolean findFiles(ModContainer mod, String base, Function<Path, Boolean> preprocessor, BiFunction<Path, Path, Boolean> processor) {
        return CraftingHelper.findFiles(mod, base, preprocessor, processor, false, false);
    }

    @Deprecated
    public static boolean findFiles(ModContainer mod, String base, Function<Path, Boolean> preprocessor, BiFunction<Path, Path, Boolean> processor, boolean defaultUnfoundRoot) {
        return CraftingHelper.findFiles(mod, base, preprocessor, processor, defaultUnfoundRoot, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean findFiles(ModContainer mod, String base, Function<Path, Boolean> preprocessor, BiFunction<Path, Path, Boolean> processor, boolean defaultUnfoundRoot, boolean visitAllFiles) {
        boolean success;
        FileSystem fs;
        block19: {
            Iterator itr;
            Path root;
            block18: {
                Boolean cont;
                block17: {
                    File source = mod.getResource();
                    if ("minecraft".equals(mod.getModId())) {
                        return true;
                    }
                    fs = null;
                    success = true;
                    root = null;
                    if (source.isFile()) {
                        try {
                            fs = FileSystems.newFileSystem(source.toPath(), (ClassLoader)null);
                            root = fs.getPath("/" + base, new String[0]);
                        }
                        catch (IOException e) {
                            FMLLog.log.error("Error loading FileSystem from jar: ", (Throwable)e);
                            boolean bl = false;
                            IOUtils.closeQuietly((Closeable)fs);
                            return bl;
                        }
                    } else if (source.isDirectory()) {
                        root = source.toPath().resolve(base);
                    }
                    if (root != null && Files.exists(root, new LinkOption[0])) break block17;
                    boolean e = defaultUnfoundRoot;
                    IOUtils.closeQuietly((Closeable)fs);
                    return e;
                }
                if (preprocessor == null || (cont = preprocessor.apply(root)) != null && cont.booleanValue()) break block18;
                boolean bl = false;
                IOUtils.closeQuietly((Closeable)fs);
                return bl;
            }
            try {
                if (processor == null) break block19;
                itr = null;
                try {
                    itr = Files.walk(root, new FileVisitOption[0]).iterator();
                }
                catch (IOException e) {
                    FMLLog.log.error("Error iterating filesystem for: {}", (Object)mod.getModId(), (Object)e);
                    boolean bl = false;
                    IOUtils.closeQuietly((Closeable)fs);
                    return bl;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fs);
                throw throwable;
            }
            while (true) {
                block20: {
                    if (itr == null || !itr.hasNext()) break;
                    Boolean cont = processor.apply(root, (Path)itr.next());
                    if (visitAllFiles) {
                        success &= cont != null && cont != false;
                        break block20;
                    }
                    if (cont != null && cont.booleanValue()) break block20;
                    boolean bl = false;
                    IOUtils.closeQuietly((Closeable)fs);
                    return bl;
                }
                continue;
                break;
            }
        }
        IOUtils.closeQuietly((Closeable)fs);
        return success;
    }

    public static JsonContext loadContext(ResourceLocation path) throws IOException {
        ModContainer mod = Loader.instance().activeModContainer();
        if (mod == null) {
            throw new IllegalStateException("No active mod container");
        }
        return CraftingHelper.loadContext(path, mod);
    }

    public static JsonContext loadContext(ResourceLocation path, ModContainer mod) throws IOException {
        return CraftingHelper.loadContext(mod, new JsonContext(mod.getModId()), path);
    }

    private static JsonContext loadContext(JsonContext ctx, File file) throws IOException {
        JsonContext jsonContext;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            JsonObject[] json = JsonUtils.fromJson(GSON, (Reader)reader, JsonObject[].class);
            ctx.loadConstants(json);
            jsonContext = ctx;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IOException("Error loading constants from file: " + file.getAbsolutePath(), e);
            }
        }
        reader.close();
        return jsonContext;
    }

    private static JsonContext loadContext(ModContainer mod, JsonContext ctx, ResourceLocation path) throws IOException {
        Path fPath = null;
        if (mod.getResource().isFile()) {
            try (FileSystem fs = FileSystems.newFileSystem(mod.getResource().toPath(), (ClassLoader)null);){
                fPath = fs.getPath("assets", path.getNamespace(), path.getPath());
            }
        } else if (mod.getResource().isDirectory()) {
            fPath = mod.getResource().toPath().resolve(Paths.get("assets", path.getNamespace(), path.getPath()));
        }
        if (fPath != null && Files.exists(fPath, new LinkOption[0])) {
            return CraftingHelper.loadContext(ctx, fPath.toFile());
        }
        throw new FileNotFoundException(fPath != null ? fPath.toString() : path.toString());
    }

    static {
        CraftingHelper.init();
        INGREDIENTS = new FactoryLoader<IIngredientFactory>("ingredients", IIngredientFactory.class, CraftingHelper::register);
        RECIPES = new FactoryLoader<IRecipeFactory>("recipes", IRecipeFactory.class, CraftingHelper::register);
        CONDITIONS = new FactoryLoader<IConditionFactory>("conditions", IConditionFactory.class, CraftingHelper::register);
    }

    public static class ShapedPrimer {
        public int height;
        public int width;
        public boolean mirrored = true;
        public NonNullList<Ingredient> input;
    }

    public static final class FactoryLoader<T> {
        final String name;
        final Class<T> type;
        final BiConsumer<ResourceLocation, T> consumer;

        FactoryLoader(String name, Class<T> type, BiConsumer<ResourceLocation, T> consumer) {
            this.name = name;
            this.type = type;
            this.consumer = consumer;
        }
    }
}

