/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.property;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class ExtendedBlockState
extends BlockStateContainer {
    private final ImmutableSet<IUnlistedProperty<?>> unlistedProperties;

    public ExtendedBlockState(Block blockIn, IProperty<?>[] properties, IUnlistedProperty<?>[] unlistedProperties) {
        super(blockIn, properties, ExtendedBlockState.buildUnlistedMap(unlistedProperties));
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (IUnlistedProperty<?> property : unlistedProperties) {
            builder.add(property);
        }
        this.unlistedProperties = builder.build();
    }

    public Collection<IUnlistedProperty<?>> getUnlistedProperties() {
        return this.unlistedProperties;
    }

    private static ImmutableMap<IUnlistedProperty<?>, Optional<?>> buildUnlistedMap(IUnlistedProperty<?>[] unlistedProperties) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (IUnlistedProperty<?> p : unlistedProperties) {
            builder.put(p, Optional.empty());
        }
        return builder.build();
    }

    @Override
    @Nonnull
    protected BlockStateContainer.StateImplementation createState(@Nonnull Block block, @Nonnull ImmutableMap<IProperty<?>, Comparable<?>> properties, @Nullable ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties) {
        if (unlistedProperties == null || unlistedProperties.isEmpty()) {
            return super.createState(block, properties, unlistedProperties);
        }
        return new ExtendedStateImplementation(block, properties, unlistedProperties, null, null);
    }

    protected static class ExtendedStateImplementation
    extends BlockStateContainer.StateImplementation
    implements IExtendedBlockState {
        private final ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties;
        private IBlockState cleanState;

        protected ExtendedStateImplementation(Block block, ImmutableMap<IProperty<?>, Comparable<?>> properties, ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties, @Nullable ImmutableTable<IProperty<?>, Comparable<?>, IBlockState> table, IBlockState clean) {
            super(block, properties, table);
            this.unlistedProperties = unlistedProperties;
            this.cleanState = clean == null ? this : clean;
        }

        @Override
        @Nonnull
        public <T extends Comparable<T>, V extends T> IBlockState withProperty(@Nonnull IProperty<T> property, @Nonnull V value) {
            IBlockState clean = super.withProperty(property, value);
            if (clean == this.cleanState) {
                return this;
            }
            if (this == this.cleanState) {
                return clean;
            }
            return new ExtendedStateImplementation(this.getBlock(), clean.getProperties(), this.unlistedProperties, ((BlockStateContainer.StateImplementation)clean).getPropertyValueTable(), this.cleanState);
        }

        @Override
        public <V> IExtendedBlockState withProperty(IUnlistedProperty<V> property, @Nullable V value) {
            Optional oldValue = (Optional)this.unlistedProperties.get(property);
            if (oldValue == null) {
                throw new IllegalArgumentException("Cannot set unlisted property " + String.valueOf(property) + " as it does not exist in " + String.valueOf(this.getBlock().getBlockState()));
            }
            if (Objects.equals(oldValue.orElse(null), value)) {
                return this;
            }
            if (!property.isValid(value)) {
                throw new IllegalArgumentException("Cannot set unlisted property " + String.valueOf(property) + " to " + String.valueOf(value) + " on block " + String.valueOf(Block.REGISTRY.getNameForObject(this.getBlock())) + ", it is not an allowed value");
            }
            boolean clean = true;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry entry : this.unlistedProperties.entrySet()) {
                Optional newValue;
                IUnlistedProperty key = (IUnlistedProperty)entry.getKey();
                Optional optional = newValue = key.equals(property) ? Optional.ofNullable(value) : (Optional)entry.getValue();
                if (newValue.isPresent()) {
                    clean = false;
                }
                builder.put((Object)key, (Object)newValue);
            }
            if (clean) {
                return (IExtendedBlockState)this.cleanState;
            }
            return new ExtendedStateImplementation(this.getBlock(), this.getProperties(), builder.build(), this.propertyValueTable, this.cleanState);
        }

        @Override
        public Collection<IUnlistedProperty<?>> getUnlistedNames() {
            return this.unlistedProperties.keySet();
        }

        @Override
        @Nullable
        public <V> V getValue(IUnlistedProperty<V> property) {
            Optional value = (Optional)this.unlistedProperties.get(property);
            if (value == null) {
                throw new IllegalArgumentException("Cannot get unlisted property " + String.valueOf(property) + " as it does not exist in " + String.valueOf(this.getBlock().getBlockState()));
            }
            return property.getType().cast(value.orElse(null));
        }

        @Override
        public ImmutableMap<IUnlistedProperty<?>, Optional<?>> getUnlistedProperties() {
            return this.unlistedProperties;
        }

        @Override
        public IBlockState getClean() {
            return this.cleanState;
        }
    }
}

