/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import java.lang.ref.WeakReference;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BlockSnapshot {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("forge.debugBlockSnapshot", "false"));
    private final BlockPos pos;
    private final int dimId;
    @Nullable
    private IBlockState replacedBlock;
    private int flag;
    @Nullable
    private final NBTTagCompound nbt;
    @Nullable
    private WeakReference<World> world;
    private final ResourceLocation registryName;
    private final int meta;

    public BlockSnapshot(World world, BlockPos pos, IBlockState state) {
        this(world, pos, state, BlockSnapshot.getTileNBT(world.getTileEntity(pos)));
    }

    public BlockSnapshot(World world, BlockPos pos, IBlockState state, @Nullable NBTTagCompound nbt) {
        this.setWorld(world);
        this.dimId = world.provider.getDimension();
        this.pos = pos.toImmutable();
        this.setReplacedBlock(state);
        this.registryName = state.getBlock().getRegistryName();
        this.meta = state.getBlock().getMetaFromState(state);
        this.setFlag(3);
        this.nbt = nbt;
        if (DEBUG) {
            System.out.printf("Created BlockSnapshot - [World: %s ][Location: %d,%d,%d ][Block: %s ][Meta: %d ]", world.getWorldInfo().getWorldName(), pos.getX(), pos.getY(), pos.getZ(), this.getRegistryName(), this.getMeta());
        }
    }

    public BlockSnapshot(World world, BlockPos pos, IBlockState state, int flag) {
        this(world, pos, state);
        this.setFlag(flag);
    }

    @Deprecated
    public BlockSnapshot(int dimension, BlockPos pos, String modId, String blockName, int meta, int flag, @Nullable NBTTagCompound nbt) {
        this(dimension, pos, new ResourceLocation(modId, blockName), meta, flag, nbt);
    }

    public BlockSnapshot(int dimension, BlockPos pos, ResourceLocation registryName, int meta, int flag, @Nullable NBTTagCompound nbt) {
        this.dimId = dimension;
        this.pos = pos.toImmutable();
        this.setFlag(flag);
        this.registryName = registryName;
        this.meta = meta;
        this.nbt = nbt;
    }

    public static BlockSnapshot getBlockSnapshot(World world, BlockPos pos) {
        return new BlockSnapshot(world, pos, world.getBlockState(pos));
    }

    public static BlockSnapshot getBlockSnapshot(World world, BlockPos pos, int flag) {
        return new BlockSnapshot(world, pos, world.getBlockState(pos), flag);
    }

    public static BlockSnapshot readFromNBT(NBTTagCompound tag) {
        return new BlockSnapshot(tag.getInteger("dimension"), new BlockPos(tag.getInteger("posX"), tag.getInteger("posY"), tag.getInteger("posZ")), new ResourceLocation(tag.getString("blockMod"), tag.getString("blockName")), tag.getInteger("metadata"), tag.getInteger("flag"), tag.getBoolean("hasTE") ? tag.getCompoundTag("tileEntity") : null);
    }

    @Nullable
    private static NBTTagCompound getTileNBT(@Nullable TileEntity te) {
        if (te == null) {
            return null;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        te.writeToNBT(nbt);
        return nbt;
    }

    public IBlockState getCurrentBlock() {
        return this.getWorld().getBlockState(this.getPos());
    }

    public World getWorld() {
        World world;
        World world2 = world = this.world != null ? (World)this.world.get() : null;
        if (world == null) {
            world = FMLCommonHandler.instance().getMinecraftServerInstance().getWorld(this.getDimId());
            this.world = new WeakReference<World>(world);
        }
        return world;
    }

    public IBlockState getReplacedBlock() {
        if (this.replacedBlock == null) {
            this.replacedBlock = ForgeRegistries.BLOCKS.getValue(this.getRegistryName()).getStateFromMeta(this.getMeta());
        }
        return this.replacedBlock;
    }

    @Nullable
    public TileEntity getTileEntity() {
        return this.getNbt() != null ? TileEntity.create(this.getWorld(), this.getNbt()) : null;
    }

    public boolean restore() {
        return this.restore(false);
    }

    public boolean restore(boolean force) {
        return this.restore(force, true);
    }

    public boolean restore(boolean force, boolean notifyNeighbors) {
        return this.restoreToLocation(this.getWorld(), this.getPos(), force, notifyNeighbors);
    }

    public boolean restoreToLocation(World world, BlockPos pos, boolean force, boolean notifyNeighbors) {
        int flags;
        IBlockState current = this.getCurrentBlock();
        IBlockState replaced = this.getReplacedBlock();
        int n = flags = notifyNeighbors ? 3 : 2;
        if (current.getBlock() != replaced.getBlock() || current.getBlock().getMetaFromState(current) != replaced.getBlock().getMetaFromState(replaced)) {
            if (force) {
                world.setBlockState(pos, replaced, flags);
            } else {
                return false;
            }
        }
        world.setBlockState(pos, replaced, flags);
        world.notifyBlockUpdate(pos, current, replaced, flags);
        TileEntity te = null;
        if (this.getNbt() != null && (te = world.getTileEntity(pos)) != null) {
            te.readFromNBT(this.getNbt());
            te.markDirty();
        }
        if (DEBUG) {
            System.out.printf("Restored BlockSnapshot with data [World: %s ][Location: %d,%d,%d ][Meta: %d ][Block: %s ][TileEntity: %s ][force: %s ][notifyNeighbors: %s]", world.getWorldInfo().getWorldName(), pos.getX(), pos.getY(), pos.getZ(), replaced.getBlock().getMetaFromState(replaced), replaced.getBlock().delegate.name(), te, force, notifyNeighbors);
        }
        return true;
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.setString("blockMod", this.getRegistryName().getNamespace());
        compound.setString("blockName", this.getRegistryName().getPath());
        compound.setInteger("posX", this.getPos().getX());
        compound.setInteger("posY", this.getPos().getY());
        compound.setInteger("posZ", this.getPos().getZ());
        compound.setInteger("flag", this.getFlag());
        compound.setInteger("dimension", this.getDimId());
        compound.setInteger("metadata", this.getMeta());
        compound.setBoolean("hasTE", this.getNbt() != null);
        if (this.getNbt() != null) {
            compound.setTag("tileEntity", this.getNbt());
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockSnapshot other = (BlockSnapshot)obj;
        if (this.getMeta() != other.getMeta()) {
            return false;
        }
        if (this.getDimId() != other.getDimId()) {
            return false;
        }
        if (!this.getPos().equals(other.getPos())) {
            return false;
        }
        if (!this.getRegistryName().equals(other.getRegistryName())) {
            return false;
        }
        return Objects.equals(this.getNbt(), other.getNbt());
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + this.getMeta();
        hash = 73 * hash + this.getDimId();
        hash = 73 * hash + this.getPos().hashCode();
        hash = 73 * hash + this.getRegistryName().hashCode();
        hash = 73 * hash + Objects.hashCode(this.getNbt());
        return hash;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getDimId() {
        return this.dimId;
    }

    public void setReplacedBlock(IBlockState replacedBlock) {
        this.replacedBlock = replacedBlock;
    }

    public int getFlag() {
        return this.flag;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    @Nullable
    public NBTTagCompound getNbt() {
        return this.nbt;
    }

    public void setWorld(World world) {
        this.world = new WeakReference<World>(world);
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public int getMeta() {
        return this.meta;
    }
}

