/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.common.util.IDataFixerData;
import net.minecraftforge.common.util.ModFixs;

public class CompoundDataFixer
extends DataFixer {
    private final ModFixs vanilla;
    private final Map<String, ModFixs> modFixers = Maps.newHashMap();
    private final Map<IFixType, List<IDataWalker>> walkers = Maps.newHashMap();

    public CompoundDataFixer(DataFixer vanilla) {
        super(0);
        this.vanilla = this.init("minecraft", vanilla.version);
    }

    @Override
    public NBTTagCompound process(IFixType type, NBTTagCompound nbt) {
        final Map<String, Integer> versions = this.getVersions(nbt);
        int mcversion = versions.get("minecraft") == null ? -1 : versions.get("minecraft");
        IDataFixerData holder = new IDataFixerData(){

            @Override
            public NBTTagCompound process(IFixType type, NBTTagCompound nbt, int version) {
                for (Map.Entry<String, ModFixs> e : CompoundDataFixer.this.modFixers.entrySet()) {
                    ModFixs fixer = e.getValue();
                    int ver = this.getVersion(e.getKey());
                    if (ver >= fixer.version) continue;
                    for (IFixableData fix : fixer.getFixes(type)) {
                        if (fix.getFixVersion() <= ver) continue;
                        nbt = fix.fixTagCompound(nbt);
                    }
                    for (IDataWalker walker : CompoundDataFixer.this.getWalkers(type)) {
                        nbt = walker.process(this, nbt, version);
                    }
                }
                return nbt;
            }

            @Override
            public int getVersion(String mod) {
                Integer ret = (Integer)versions.get(mod);
                return ret == null ? -1 : ret;
            }
        };
        return holder.process(type, nbt, mcversion);
    }

    @Override
    @Deprecated
    public NBTTagCompound process(IFixType type, NBTTagCompound nbt, int mcversion) {
        if (type != FixTypes.OPTIONS) {
            throw new IllegalStateException("Do not call recursive process directly on DataFixer!");
        }
        for (IFixableData fix : this.vanilla.getFixes(type)) {
            if (fix.getFixVersion() <= mcversion) continue;
            nbt = fix.fixTagCompound(nbt);
        }
        return nbt;
    }

    private List<IDataWalker> getWalkers(IFixType type) {
        return this.walkers.computeIfAbsent(type, k -> Lists.newArrayList());
    }

    @Override
    @Deprecated
    public void registerFix(IFixType type, IFixableData fixable) {
        this.vanilla.registerFix(type, fixable);
    }

    @Override
    @Deprecated
    public void registerWalker(FixTypes type, IDataWalker walker) {
        this.registerVanillaWalker(type, walker);
    }

    @Override
    public void registerVanillaWalker(IFixType type, IDataWalker walker) {
        this.getWalkers(type).add(walker);
    }

    private void validateModId(String mod) {
        if (!mod.equals(mod.toLowerCase(Locale.ENGLISH))) {
            throw new IllegalArgumentException("Mod ID is not lower case: " + mod);
        }
        if (mod.length() > 64) {
            throw new IllegalArgumentException("Mod ID is to long: " + mod);
        }
    }

    public ModFixs init(String modid, int version) {
        this.validateModId(modid);
        if (this.modFixers.containsKey(modid)) {
            throw new IllegalStateException("Attempted to initalize DataFixer for " + modid + " twice");
        }
        ModFixs ret = new ModFixs(modid, version);
        this.modFixers.put(modid, ret);
        return ret;
    }

    private Map<String, Integer> getVersions(NBTTagCompound nbt) {
        HashMap ret = Maps.newHashMap();
        ret.put("minecraft", nbt.hasKey("DataVersion", 99) ? nbt.getInteger("DataVersion") : -1);
        if (nbt.hasKey("ForgeDataVersion", 10)) {
            NBTTagCompound sub = nbt.getCompoundTag("ForgeDataVersion");
            for (String key : sub.getKeySet()) {
                ret.put(key, sub.hasKey(key, 99) ? sub.getInteger(key) : -1);
            }
        }
        return ret;
    }

    public void writeVersionData(NBTTagCompound nbt) {
        NBTTagCompound sub = new NBTTagCompound();
        nbt.setTag("ForgeDataVersion", sub);
        for (ModFixs mod : this.modFixers.values()) {
            sub.setInteger(mod.mod, mod.version);
        }
    }
}

