/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;

public class PacketUtil {
    private PacketUtil() {
    }

    public static void writeItemStackFromClientToServer(PacketBuffer buffer, ItemStack stack) {
        if (stack.isEmpty()) {
            buffer.writeShort(-1);
        } else {
            buffer.writeShort(Item.getIdFromItem(stack.getItem()));
            buffer.writeByte(stack.getCount());
            buffer.writeShort(stack.getMetadata());
            NBTTagCompound nbttagcompound = null;
            if (stack.getItem().isDamageable() || stack.getItem().getShareTag()) {
                nbttagcompound = stack.getTagCompound();
            }
            buffer.writeCompoundTag(nbttagcompound);
        }
    }
}

