/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.player;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;

public class PlayerInteractEvent
extends PlayerEvent {
    private final EnumHand hand;
    private final BlockPos pos;
    @Nullable
    private final EnumFacing face;
    private EnumActionResult cancellationResult = EnumActionResult.PASS;

    private PlayerInteractEvent(EntityPlayer player, EnumHand hand, BlockPos pos, @Nullable EnumFacing face) {
        super((EntityPlayer)Preconditions.checkNotNull((Object)player, (Object)"Null player in PlayerInteractEvent!"));
        this.hand = (EnumHand)((Object)Preconditions.checkNotNull((Object)((Object)hand), (Object)"Null hand in PlayerInteractEvent!"));
        this.pos = (BlockPos)Preconditions.checkNotNull((Object)pos, (Object)"Null position in PlayerInteractEvent!");
        this.face = face;
    }

    @Nonnull
    public EnumHand getHand() {
        return this.hand;
    }

    @Nonnull
    public ItemStack getItemStack() {
        return this.getEntityPlayer().getHeldItem(this.hand);
    }

    @Nonnull
    public BlockPos getPos() {
        return this.pos;
    }

    @Nullable
    public EnumFacing getFace() {
        return this.face;
    }

    public World getWorld() {
        return this.getEntityPlayer().getEntityWorld();
    }

    public Side getSide() {
        return this.getWorld().isRemote ? Side.CLIENT : Side.SERVER;
    }

    public EnumActionResult getCancellationResult() {
        return this.cancellationResult;
    }

    public void setCancellationResult(EnumActionResult result) {
        this.cancellationResult = result;
    }

    public static class LeftClickEmpty
    extends PlayerInteractEvent {
        public LeftClickEmpty(EntityPlayer player) {
            super(player, EnumHand.MAIN_HAND, new BlockPos(player), null);
        }
    }

    @Cancelable
    public static class LeftClickBlock
    extends PlayerInteractEvent {
        private Event.Result useBlock = Event.Result.DEFAULT;
        private Event.Result useItem = Event.Result.DEFAULT;
        private final Vec3d hitVec;

        public LeftClickBlock(EntityPlayer player, BlockPos pos, EnumFacing face, Vec3d hitVec) {
            super(player, EnumHand.MAIN_HAND, pos, face);
            this.hitVec = hitVec;
        }

        public Vec3d getHitVec() {
            return this.hitVec;
        }

        public Event.Result getUseBlock() {
            return this.useBlock;
        }

        public Event.Result getUseItem() {
            return this.useItem;
        }

        public void setUseBlock(Event.Result triggerBlock) {
            this.useBlock = triggerBlock;
        }

        public void setUseItem(Event.Result triggerItem) {
            this.useItem = triggerItem;
        }

        @Override
        public void setCanceled(boolean canceled) {
            super.setCanceled(canceled);
            if (canceled) {
                this.useBlock = Event.Result.DENY;
                this.useItem = Event.Result.DENY;
            }
        }
    }

    public static class RightClickEmpty
    extends PlayerInteractEvent {
        public RightClickEmpty(EntityPlayer player, EnumHand hand) {
            super(player, hand, new BlockPos(player), null);
        }
    }

    @Cancelable
    public static class RightClickItem
    extends PlayerInteractEvent {
        public RightClickItem(EntityPlayer player, EnumHand hand) {
            super(player, hand, new BlockPos(player), null);
        }
    }

    @Cancelable
    public static class RightClickBlock
    extends PlayerInteractEvent {
        private Event.Result useBlock = Event.Result.DEFAULT;
        private Event.Result useItem = Event.Result.DEFAULT;
        private final Vec3d hitVec;

        public RightClickBlock(EntityPlayer player, EnumHand hand, BlockPos pos, EnumFacing face, Vec3d hitVec) {
            super(player, hand, pos, face);
            this.hitVec = hitVec;
        }

        public Vec3d getHitVec() {
            return this.hitVec;
        }

        public Event.Result getUseBlock() {
            return this.useBlock;
        }

        public Event.Result getUseItem() {
            return this.useItem;
        }

        public void setUseBlock(Event.Result triggerBlock) {
            this.useBlock = triggerBlock;
        }

        public void setUseItem(Event.Result triggerItem) {
            this.useItem = triggerItem;
        }

        @Override
        public void setCanceled(boolean canceled) {
            super.setCanceled(canceled);
            if (canceled) {
                this.useBlock = Event.Result.DENY;
                this.useItem = Event.Result.DENY;
            }
        }
    }

    @Cancelable
    public static class EntityInteract
    extends PlayerInteractEvent {
        private final Entity target;

        public EntityInteract(EntityPlayer player, EnumHand hand, Entity target) {
            super(player, hand, new BlockPos(target), null);
            this.target = target;
        }

        public Entity getTarget() {
            return this.target;
        }
    }

    @Cancelable
    public static class EntityInteractSpecific
    extends PlayerInteractEvent {
        private final Vec3d localPos;
        private final Entity target;

        public EntityInteractSpecific(EntityPlayer player, EnumHand hand, Entity target, Vec3d localPos) {
            super(player, hand, new BlockPos(target), null);
            this.localPos = localPos;
            this.target = target;
        }

        public Vec3d getLocalPos() {
            return this.localPos;
        }

        public Entity getTarget() {
            return this.target;
        }
    }
}

