/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.common.property.PropertyFloat;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockFluidBase
extends Block
implements IFluidBlock {
    protected static final Map<Block, Boolean> defaultDisplacements = Maps.newHashMap();
    protected Map<Block, Boolean> displacements = Maps.newHashMap();
    public static final PropertyInteger LEVEL;
    public static final PropertyFloat[] LEVEL_CORNERS;
    public static final PropertyFloat FLOW_DIRECTION;
    public static final UnlistedPropertyBool[] SIDE_OVERLAYS;
    public static final ImmutableList<IUnlistedProperty<?>> FLUID_RENDER_PROPS;
    protected int quantaPerBlock = 8;
    protected float quantaPerBlockFloat = 8.0f;
    protected float quantaFraction = 0.8888889f;
    protected int density = 1;
    protected int densityDir = -1;
    protected int temperature = 295;
    protected int tickRate = 20;
    protected BlockRenderLayer renderLayer = BlockRenderLayer.TRANSLUCENT;
    protected int maxScaledLight = 0;
    protected final String fluidName;
    protected final Fluid definedFluid;

    public BlockFluidBase(Fluid fluid, Material material, MapColor mapColor) {
        super(material, mapColor);
        this.setTickRandomly(true);
        this.disableStats();
        this.fluidName = fluid.getName();
        this.density = fluid.density;
        this.temperature = fluid.temperature;
        this.maxScaledLight = fluid.luminosity;
        this.tickRate = fluid.viscosity / 200;
        this.densityDir = fluid.density > 0 ? -1 : 1;
        fluid.setBlock(this);
        this.definedFluid = fluid;
        this.displacements.putAll(defaultDisplacements);
        this.setDefaultState(this.blockState.getBaseState().withProperty(LEVEL, this.getMaxRenderHeightMeta()));
    }

    public BlockFluidBase(Fluid fluid, Material material) {
        this(fluid, material, material.getMaterialMapColor());
    }

    @Override
    @Nonnull
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer.Builder(this).add(LEVEL).add((IUnlistedProperty[])FLUID_RENDER_PROPS.toArray((Object[])new IUnlistedProperty[0])).build();
    }

    @Override
    public int getMetaFromState(@Nonnull IBlockState state) {
        return state.getValue(LEVEL);
    }

    @Override
    @Deprecated
    @Nonnull
    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty(LEVEL, meta);
    }

    public BlockFluidBase setQuantaPerBlock(int quantaPerBlock) {
        if (quantaPerBlock > 16 || quantaPerBlock < 1) {
            quantaPerBlock = 8;
        }
        this.quantaPerBlock = quantaPerBlock;
        this.quantaPerBlockFloat = quantaPerBlock;
        this.quantaFraction = (float)quantaPerBlock / ((float)quantaPerBlock + 1.0f);
        return this;
    }

    public BlockFluidBase setDensity(int density) {
        if (density == 0) {
            density = 1;
        }
        this.density = density;
        this.densityDir = density > 0 ? -1 : 1;
        return this;
    }

    public BlockFluidBase setTemperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public BlockFluidBase setTickRate(int tickRate) {
        if (tickRate <= 0) {
            tickRate = 20;
        }
        this.tickRate = tickRate;
        return this;
    }

    public BlockFluidBase setRenderLayer(BlockRenderLayer renderLayer) {
        this.renderLayer = renderLayer;
        return this;
    }

    public BlockFluidBase setMaxScaledLight(int maxScaledLight) {
        this.maxScaledLight = maxScaledLight;
        return this;
    }

    public final int getDensity() {
        return this.density;
    }

    public final int getTemperature() {
        return this.temperature;
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (block.isAir(state, world, pos)) {
            return true;
        }
        if (block == this) {
            return false;
        }
        if (this.displacements.containsKey(block)) {
            return this.displacements.get(block);
        }
        Material material = state.getMaterial();
        if (material.blocksMovement() || material == Material.PORTAL || material == Material.STRUCTURE_VOID) {
            return false;
        }
        int density = BlockFluidBase.getDensity(world, pos);
        if (density == Integer.MAX_VALUE) {
            return true;
        }
        return this.density > density;
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        IBlockState state;
        Block block;
        boolean canDisplace = this.canDisplace(world, pos);
        if (canDisplace && !(block = (state = world.getBlockState(pos)).getBlock()).isAir(state, world, pos) && !BlockFluidBase.isFluid(state) && block != Blocks.SNOW_LAYER) {
            block.dropBlockAsItem(world, pos, state, 0);
        }
        return canDisplace;
    }

    public abstract int getQuantaValue(IBlockAccess var1, BlockPos var2);

    @Override
    public abstract boolean canCollideCheck(@Nonnull IBlockState var1, boolean var2);

    public abstract int getMaxRenderHeightMeta();

    @Override
    public void onBlockAdded(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        world.scheduleUpdate(pos, this, this.tickRate);
    }

    @Override
    public void neighborChanged(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Block neighborBlock, @Nonnull BlockPos neighbourPos) {
        world.scheduleUpdate(pos, this, this.tickRate);
    }

    @Override
    public boolean requiresUpdates() {
        return false;
    }

    @Override
    public boolean isPassable(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return true;
    }

    @Override
    @Nonnull
    public Item getItemDropped(@Nonnull IBlockState state, @Nonnull Random rand, int fortune) {
        return Items.AIR;
    }

    @Override
    public int quantityDropped(@Nonnull Random par1Random) {
        return 0;
    }

    @Override
    public int tickRate(@Nonnull World world) {
        return this.tickRate;
    }

    @Override
    @Nonnull
    public Vec3d modifyAcceleration(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Entity entity, @Nonnull Vec3d vec) {
        return this.densityDir > 0 ? vec : vec.add(this.getFlowVector(world, pos));
    }

    @Override
    public int getLightValue(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        if (this.maxScaledLight == 0) {
            return super.getLightValue(state, world, pos);
        }
        return (int)(this.getQuantaPercentage(world, pos) * (float)this.maxScaledLight);
    }

    @Override
    public boolean isOpaqueCube(@Nonnull IBlockState state) {
        return false;
    }

    @Override
    public boolean isFullCube(@Nonnull IBlockState state) {
        return false;
    }

    @Override
    public int getPackedLightmapCoords(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        int lightThis = world.getCombinedLight(pos, 0);
        int lightUp = world.getCombinedLight(pos.down(this.densityDir), 0);
        int lightThisBase = lightThis & 0xFF;
        int lightUpBase = lightUp & 0xFF;
        int lightThisExt = lightThis >> 16 & 0xFF;
        int lightUpExt = lightUp >> 16 & 0xFF;
        return (lightThisBase > lightUpBase ? lightThisBase : lightUpBase) | (lightThisExt > lightUpExt ? lightThisExt : lightUpExt) << 16;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer getRenderLayer() {
        return this.renderLayer;
    }

    @Override
    @Nonnull
    public BlockFaceShape getBlockFaceShape(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public boolean shouldSideBeRendered(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        IBlockState neighbor = world.getBlockState(pos.offset(side));
        if (neighbor.getMaterial() == state.getMaterial()) {
            return false;
        }
        if (side == (this.densityDir < 0 ? EnumFacing.UP : EnumFacing.DOWN)) {
            return true;
        }
        return super.shouldSideBeRendered(state, world, pos, side);
    }

    private static boolean isFluid(@Nonnull IBlockState blockstate) {
        return blockstate.getMaterial().isLiquid() || blockstate.getBlock() instanceof IFluidBlock;
    }

    @Override
    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState oldState, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        int i;
        IExtendedBlockState state = (IExtendedBlockState)oldState;
        state = state.withProperty(FLOW_DIRECTION, Float.valueOf((float)BlockFluidBase.getFlowDirection(world, pos)));
        IBlockState[][] upBlockState = new IBlockState[3][3];
        float[][] height = new float[3][3];
        float[][] corner = new float[2][2];
        upBlockState[1][1] = world.getBlockState(pos.down(this.densityDir));
        height[1][1] = this.getFluidHeightForRender(world, pos, upBlockState[1][1]);
        if (height[1][1] == 1.0f) {
            for (i = 0; i < 2; ++i) {
                for (j = 0; j < 2; ++j) {
                    corner[i][j] = 1.0f;
                }
            }
        } else {
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    if (i == 1 && j == 1) continue;
                    upBlockState[i][j] = world.getBlockState(pos.add(i - 1, 0, j - 1).down(this.densityDir));
                    height[i][j] = this.getFluidHeightForRender(world, pos.add(i - 1, 0, j - 1), upBlockState[i][j]);
                }
            }
            for (i = 0; i < 2; ++i) {
                for (j = 0; j < 2; ++j) {
                    corner[i][j] = this.getFluidHeightAverage(height[i][j], height[i][j + 1], height[i + 1][j], height[i + 1][j + 1]);
                }
            }
            boolean n = BlockFluidBase.isFluid(upBlockState[0][1]);
            boolean s = BlockFluidBase.isFluid(upBlockState[2][1]);
            boolean w = BlockFluidBase.isFluid(upBlockState[1][0]);
            boolean e = BlockFluidBase.isFluid(upBlockState[1][2]);
            boolean nw = BlockFluidBase.isFluid(upBlockState[0][0]);
            boolean ne = BlockFluidBase.isFluid(upBlockState[0][2]);
            boolean sw = BlockFluidBase.isFluid(upBlockState[2][0]);
            boolean se = BlockFluidBase.isFluid(upBlockState[2][2]);
            if (nw || n || w) {
                corner[0][0] = 1.0f;
            }
            if (ne || n || e) {
                corner[0][1] = 1.0f;
            }
            if (sw || s || w) {
                corner[1][0] = 1.0f;
            }
            if (se || s || e) {
                corner[1][1] = 1.0f;
            }
        }
        for (i = 0; i < 4; ++i) {
            EnumFacing side = EnumFacing.byHorizontalIndex(i);
            BlockPos offset = pos.offset(side);
            boolean useOverlay = world.getBlockState(offset).getBlockFaceShape(world, offset, side.getOpposite()) == BlockFaceShape.SOLID;
            state = state.withProperty(SIDE_OVERLAYS[i], Boolean.valueOf(useOverlay));
        }
        state = state.withProperty(LEVEL_CORNERS[0], Float.valueOf(corner[0][0]));
        state = state.withProperty(LEVEL_CORNERS[1], Float.valueOf(corner[0][1]));
        state = state.withProperty(LEVEL_CORNERS[2], Float.valueOf(corner[1][1]));
        state = state.withProperty(LEVEL_CORNERS[3], Float.valueOf(corner[1][0]));
        return state;
    }

    public static int getDensity(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof BlockFluidBase) {
            return ((BlockFluidBase)block).getDensity();
        }
        Fluid fluid = BlockFluidBase.getFluid(state);
        if (fluid != null) {
            return fluid.getDensity();
        }
        return Integer.MAX_VALUE;
    }

    public static int getTemperature(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof BlockFluidBase) {
            return ((BlockFluidBase)block).getTemperature();
        }
        Fluid fluid = BlockFluidBase.getFluid(state);
        if (fluid != null) {
            return fluid.getTemperature();
        }
        return Integer.MAX_VALUE;
    }

    @Nullable
    private static Fluid getFluid(IBlockState state) {
        Block block = state.getBlock();
        if (block instanceof IFluidBlock) {
            return ((IFluidBlock)((Object)block)).getFluid();
        }
        if (block instanceof BlockLiquid) {
            if (state.getMaterial() == Material.WATER) {
                return FluidRegistry.WATER;
            }
            if (state.getMaterial() == Material.LAVA) {
                return FluidRegistry.LAVA;
            }
        }
        return null;
    }

    public static double getFlowDirection(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.getBlockState(pos);
        if (!state.getMaterial().isLiquid()) {
            return -1000.0;
        }
        Vec3d vec = ((BlockFluidBase)state.getBlock()).getFlowVector(world, pos);
        return vec.x == 0.0 && vec.z == 0.0 ? -1000.0 : MathHelper.atan2(vec.z, vec.x) - 1.5707963267948966;
    }

    public final int getQuantaValueBelow(IBlockAccess world, BlockPos pos, int belowThis) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        if (quantaRemaining >= belowThis) {
            return -1;
        }
        return quantaRemaining;
    }

    public final int getQuantaValueAbove(IBlockAccess world, BlockPos pos, int aboveThis) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        if (quantaRemaining <= aboveThis) {
            return -1;
        }
        return quantaRemaining;
    }

    public final float getQuantaPercentage(IBlockAccess world, BlockPos pos) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        return (float)quantaRemaining / this.quantaPerBlockFloat;
    }

    public float getFluidHeightAverage(float ... flow) {
        float total = 0.0f;
        int count = 0;
        for (int i = 0; i < flow.length; ++i) {
            if (flow[i] >= this.quantaFraction) {
                total += flow[i] * 10.0f;
                count += 10;
            }
            if (!(flow[i] >= 0.0f)) continue;
            total += flow[i];
            ++count;
        }
        return total / (float)count;
    }

    public float getFluidHeightForRender(IBlockAccess world, BlockPos pos, @Nonnull IBlockState up) {
        IBlockState here = world.getBlockState(pos);
        if (here.getBlock() == this) {
            if (BlockFluidBase.isFluid(up)) {
                return 1.0f;
            }
            if (this.getMetaFromState(here) == this.getMaxRenderHeightMeta()) {
                return this.quantaFraction;
            }
        }
        if (here.getBlock() instanceof BlockLiquid) {
            return Math.min(1.0f - BlockLiquid.getLiquidHeightPercent(here.getValue(BlockLiquid.LEVEL)), this.quantaFraction);
        }
        return !here.getMaterial().isSolid() && up.getBlock() == this ? 1.0f : this.getQuantaPercentage(world, pos) * this.quantaFraction;
    }

    public Vec3d getFlowVector(IBlockAccess world, BlockPos pos) {
        BlockPos offset;
        Vec3d vec = new Vec3d(0.0, 0.0, 0.0);
        int decay = this.getFlowDecay(world, pos);
        for (EnumFacing side : EnumFacing.Plane.HORIZONTAL) {
            int power;
            offset = pos.offset(side);
            int otherDecay = this.getFlowDecay(world, offset);
            if (otherDecay >= this.quantaPerBlock) {
                if (world.getBlockState(offset).getMaterial().blocksMovement() || (otherDecay = this.getFlowDecay(world, offset.up(this.densityDir))) >= this.quantaPerBlock) continue;
                power = otherDecay - (decay - this.quantaPerBlock);
                vec = vec.add(side.getXOffset() * power, 0.0, side.getZOffset() * power);
                continue;
            }
            power = otherDecay - decay;
            vec = vec.add(side.getXOffset() * power, 0.0, side.getZOffset() * power);
        }
        if (this.hasVerticalFlow(world, pos)) {
            for (EnumFacing side : EnumFacing.Plane.HORIZONTAL) {
                offset = pos.offset(side);
                if (!this.causesDownwardCurrent(world, offset, side) && !this.causesDownwardCurrent(world, offset.down(this.densityDir), side)) continue;
                vec = vec.normalize().add(0.0, 6.0 * (double)this.densityDir, 0.0);
                break;
            }
        }
        return vec.normalize();
    }

    private int getFlowDecay(IBlockAccess world, BlockPos pos) {
        return this.quantaPerBlock - this.getEffectiveQuanta(world, pos);
    }

    final int getEffectiveQuanta(IBlockAccess world, BlockPos pos) {
        int quantaValue = this.getQuantaValue(world, pos);
        return quantaValue > 0 && quantaValue < this.quantaPerBlock && this.hasVerticalFlow(world, pos) ? this.quantaPerBlock : quantaValue;
    }

    final boolean hasVerticalFlow(IBlockAccess world, BlockPos pos) {
        return world.getBlockState(pos.down(this.densityDir)).getBlock() == this;
    }

    protected boolean causesDownwardCurrent(IBlockAccess world, BlockPos pos, EnumFacing face) {
        IBlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (block == this) {
            return false;
        }
        if (face == (this.densityDir < 0 ? EnumFacing.UP : EnumFacing.DOWN)) {
            return true;
        }
        if (state.getMaterial() == Material.ICE) {
            return false;
        }
        boolean flag = BlockFluidBase.isExceptBlockForAttachWithPiston(block) || block instanceof BlockStairs;
        return !flag && state.getBlockFaceShape(world, pos, face) == BlockFaceShape.SOLID;
    }

    @Override
    public Fluid getFluid() {
        return FluidRegistry.getFluid(this.fluidName);
    }

    @Override
    public float getFilledPercentage(World world, BlockPos pos) {
        return this.getFilledPercentage((IBlockAccess)world, pos);
    }

    public float getFilledPercentage(IBlockAccess world, BlockPos pos) {
        int quantaRemaining = this.getEffectiveQuanta(world, pos);
        float remaining = ((float)quantaRemaining + 1.0f) / (this.quantaPerBlockFloat + 1.0f);
        return remaining * (float)(this.density > 0 ? 1 : -1);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBox(@Nonnull IBlockState blockState, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return NULL_AABB;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vec3d getFogColor(World world, BlockPos pos, IBlockState state, Entity entity, Vec3d originalColor, float partialTicks) {
        if (!this.isWithinFluid(world, pos, ActiveRenderInfo.projectViewFromEntity(entity, partialTicks))) {
            BlockPos otherPos = pos.down(this.densityDir);
            IBlockState otherState = world.getBlockState(otherPos);
            return otherState.getBlock().getFogColor(world, otherPos, otherState, entity, originalColor, partialTicks);
        }
        if (this.getFluid() != null) {
            int color = this.getFluid().getColor();
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            return new Vec3d(red, green, blue);
        }
        return super.getFogColor(world, pos, state, entity, originalColor, partialTicks);
    }

    @Override
    public IBlockState getStateAtViewpoint(IBlockState state, IBlockAccess world, BlockPos pos, Vec3d viewpoint) {
        if (!this.isWithinFluid(world, pos, viewpoint)) {
            return world.getBlockState(pos.down(this.densityDir));
        }
        return super.getStateAtViewpoint(state, world, pos, viewpoint);
    }

    private boolean isWithinFluid(IBlockAccess world, BlockPos pos, Vec3d vec) {
        float filled = this.getFilledPercentage(world, pos);
        return filled < 0.0f ? vec.y > (double)((float)pos.getY() + filled + 1.0f) : vec.y < (double)((float)pos.getY() + filled);
    }

    @Override
    public float getBlockLiquidHeight(World world, BlockPos pos, IBlockState state, Material material) {
        float filled = this.getFilledPercentage(world, pos);
        return Math.max(filled, 0.0f);
    }

    static {
        defaultDisplacements.put(Blocks.OAK_DOOR, false);
        defaultDisplacements.put(Blocks.SPRUCE_DOOR, false);
        defaultDisplacements.put(Blocks.BIRCH_DOOR, false);
        defaultDisplacements.put(Blocks.JUNGLE_DOOR, false);
        defaultDisplacements.put(Blocks.ACACIA_DOOR, false);
        defaultDisplacements.put(Blocks.DARK_OAK_DOOR, false);
        defaultDisplacements.put(Blocks.TRAPDOOR, false);
        defaultDisplacements.put(Blocks.IRON_TRAPDOOR, false);
        defaultDisplacements.put(Blocks.OAK_FENCE, false);
        defaultDisplacements.put(Blocks.SPRUCE_FENCE, false);
        defaultDisplacements.put(Blocks.BIRCH_FENCE, false);
        defaultDisplacements.put(Blocks.JUNGLE_FENCE, false);
        defaultDisplacements.put(Blocks.DARK_OAK_FENCE, false);
        defaultDisplacements.put(Blocks.ACACIA_FENCE, false);
        defaultDisplacements.put(Blocks.NETHER_BRICK_FENCE, false);
        defaultDisplacements.put(Blocks.OAK_FENCE_GATE, false);
        defaultDisplacements.put(Blocks.SPRUCE_FENCE_GATE, false);
        defaultDisplacements.put(Blocks.BIRCH_FENCE_GATE, false);
        defaultDisplacements.put(Blocks.JUNGLE_FENCE_GATE, false);
        defaultDisplacements.put(Blocks.DARK_OAK_FENCE_GATE, false);
        defaultDisplacements.put(Blocks.ACACIA_FENCE_GATE, false);
        defaultDisplacements.put(Blocks.WOODEN_PRESSURE_PLATE, false);
        defaultDisplacements.put(Blocks.STONE_PRESSURE_PLATE, false);
        defaultDisplacements.put(Blocks.LIGHT_WEIGHTED_PRESSURE_PLATE, false);
        defaultDisplacements.put(Blocks.HEAVY_WEIGHTED_PRESSURE_PLATE, false);
        defaultDisplacements.put(Blocks.LADDER, false);
        defaultDisplacements.put(Blocks.IRON_BARS, false);
        defaultDisplacements.put(Blocks.GLASS_PANE, false);
        defaultDisplacements.put(Blocks.STAINED_GLASS_PANE, false);
        defaultDisplacements.put(Blocks.PORTAL, false);
        defaultDisplacements.put(Blocks.END_PORTAL, false);
        defaultDisplacements.put(Blocks.COBBLESTONE_WALL, false);
        defaultDisplacements.put(Blocks.BARRIER, false);
        defaultDisplacements.put(Blocks.STANDING_BANNER, false);
        defaultDisplacements.put(Blocks.WALL_BANNER, false);
        defaultDisplacements.put(Blocks.CAKE, false);
        defaultDisplacements.put(Blocks.IRON_DOOR, false);
        defaultDisplacements.put(Blocks.STANDING_SIGN, false);
        defaultDisplacements.put(Blocks.WALL_SIGN, false);
        defaultDisplacements.put(Blocks.REEDS, false);
        LEVEL = PropertyInteger.create("level", 0, 15);
        LEVEL_CORNERS = new PropertyFloat[4];
        FLOW_DIRECTION = new PropertyFloat("flow_direction", -1000.0f, 1000.0f);
        SIDE_OVERLAYS = new UnlistedPropertyBool[4];
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)FLOW_DIRECTION);
        for (int i = 0; i < 4; ++i) {
            BlockFluidBase.LEVEL_CORNERS[i] = new PropertyFloat("level_corner_" + i, 0.0f, 1.0f);
            builder.add((Object)LEVEL_CORNERS[i]);
            BlockFluidBase.SIDE_OVERLAYS[i] = new UnlistedPropertyBool("side_overlay_" + i);
            builder.add((Object)SIDE_OVERLAYS[i]);
        }
        FLUID_RENDER_PROPS = builder.build();
    }

    private static final class UnlistedPropertyBool
    extends Properties.PropertyAdapter<Boolean> {
        public UnlistedPropertyBool(String name) {
            super(PropertyBool.create(name));
        }
    }
}

