/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class BlockFluidClassic
extends BlockFluidBase {
    protected static final List<EnumFacing> SIDES = Collections.unmodifiableList(Arrays.asList(EnumFacing.WEST, EnumFacing.EAST, EnumFacing.NORTH, EnumFacing.SOUTH));
    protected boolean[] isOptimalFlowDirection = new boolean[4];
    protected int[] flowCost = new int[4];
    protected boolean canCreateSources = false;
    protected FluidStack stack;

    public BlockFluidClassic(Fluid fluid, Material material, MapColor mapColor) {
        super(fluid, material, mapColor);
        this.stack = new FluidStack(fluid, 1000);
    }

    public BlockFluidClassic(Fluid fluid, Material material) {
        this(fluid, material, material.getMaterialMapColor());
    }

    public BlockFluidClassic setFluidStack(FluidStack stack) {
        this.stack = stack;
        return this;
    }

    public BlockFluidClassic setFluidStackAmount(int amount) {
        this.stack.amount = amount;
        return this;
    }

    @Override
    public int getQuantaValue(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.getBlockState(pos);
        if (state.getBlock().isAir(state, world, pos)) {
            return 0;
        }
        if (state.getBlock() != this) {
            return -1;
        }
        return this.quantaPerBlock - state.getValue(LEVEL);
    }

    @Override
    public boolean canCollideCheck(@Nonnull IBlockState state, boolean fullHit) {
        return fullHit && state.getValue(LEVEL) == 0;
    }

    @Override
    public int getMaxRenderHeightMeta() {
        return 0;
    }

    @Override
    public void updateTick(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
        int quantaRemaining = this.quantaPerBlock - state.getValue(LEVEL);
        int expQuanta = -101;
        if (quantaRemaining < this.quantaPerBlock) {
            int adjacentSourceBlocks = 0;
            if (ForgeEventFactory.canCreateFluidSource(world, pos, state, this.canCreateSources)) {
                for (Object side : EnumFacing.Plane.HORIZONTAL) {
                    if (!this.isSourceBlock(world, pos.offset((EnumFacing)side))) continue;
                    ++adjacentSourceBlocks;
                }
            }
            if (adjacentSourceBlocks >= 2 && (world.getBlockState(pos.up(this.densityDir)).getMaterial().isSolid() || this.isSourceBlock(world, pos.up(this.densityDir)))) {
                expQuanta = this.quantaPerBlock;
            } else if (this.hasVerticalFlow(world, pos)) {
                expQuanta = this.quantaPerBlock - 1;
            } else {
                int maxQuanta = -100;
                for (EnumFacing side : EnumFacing.Plane.HORIZONTAL) {
                    maxQuanta = this.getLargerQuanta(world, pos.offset(side), maxQuanta);
                }
                expQuanta = maxQuanta - 1;
            }
            if (expQuanta != quantaRemaining) {
                quantaRemaining = expQuanta;
                if (expQuanta <= 0) {
                    world.setBlockToAir(pos);
                } else {
                    world.setBlockState(pos, state.withProperty(LEVEL, this.quantaPerBlock - expQuanta), 2);
                    world.scheduleUpdate(pos, this, this.tickRate);
                    world.notifyNeighborsOfStateChange(pos, this, false);
                }
            }
        }
        if (this.canDisplace(world, pos.up(this.densityDir))) {
            this.flowIntoBlock(world, pos.up(this.densityDir), 1);
            return;
        }
        int flowMeta = this.quantaPerBlock - quantaRemaining + 1;
        if (flowMeta >= this.quantaPerBlock) {
            return;
        }
        if (this.isSourceBlock(world, pos) || !this.isFlowingVertically(world, pos)) {
            if (this.hasVerticalFlow(world, pos)) {
                flowMeta = 1;
            }
            boolean[] flowTo = this.getOptimalFlowDirections(world, pos);
            for (int i = 0; i < 4; ++i) {
                if (!flowTo[i]) continue;
                this.flowIntoBlock(world, pos.offset(SIDES.get(i)), flowMeta);
            }
        }
    }

    protected final boolean hasDownhillFlow(IBlockAccess world, BlockPos pos, EnumFacing direction) {
        return world.getBlockState(pos.offset(direction).down(this.densityDir)).getBlock() == this && (this.canFlowInto(world, pos.offset(direction)) || this.canFlowInto(world, pos.down(this.densityDir)));
    }

    public boolean isFlowingVertically(IBlockAccess world, BlockPos pos) {
        return world.getBlockState(pos.up(this.densityDir)).getBlock() == this || world.getBlockState(pos).getBlock() == this && this.canFlowInto(world, pos.up(this.densityDir));
    }

    public boolean isSourceBlock(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.getBlockState(pos);
        return state.getBlock() == this && state.getValue(LEVEL) == 0;
    }

    protected boolean[] getOptimalFlowDirections(World world, BlockPos pos) {
        for (int side = 0; side < 4; ++side) {
            this.flowCost[side] = 1000;
            BlockPos pos2 = pos.offset(SIDES.get(side));
            if (!this.canFlowInto(world, pos2) || this.isSourceBlock(world, pos2)) continue;
            this.flowCost[side] = this.canFlowInto(world, pos2.up(this.densityDir)) ? 0 : this.calculateFlowCost(world, pos2, 1, side);
        }
        int min = Ints.min((int[])this.flowCost);
        for (int side = 0; side < 4; ++side) {
            this.isOptimalFlowDirection[side] = this.flowCost[side] == min;
        }
        return this.isOptimalFlowDirection;
    }

    protected int calculateFlowCost(World world, BlockPos pos, int recurseDepth, int side) {
        int cost = 1000;
        for (int adjSide = 0; adjSide < 4; ++adjSide) {
            BlockPos pos2;
            if (SIDES.get(adjSide) == SIDES.get(side).getOpposite() || !this.canFlowInto(world, pos2 = pos.offset(SIDES.get(adjSide))) || this.isSourceBlock(world, pos2)) continue;
            if (this.canFlowInto(world, pos2.up(this.densityDir))) {
                return recurseDepth;
            }
            if (recurseDepth >= this.quantaPerBlock / 2) continue;
            cost = Math.min(cost, this.calculateFlowCost(world, pos2, recurseDepth + 1, adjSide));
        }
        return cost;
    }

    protected void flowIntoBlock(World world, BlockPos pos, int meta) {
        if (meta < 0) {
            return;
        }
        if (this.displaceIfPossible(world, pos)) {
            world.setBlockState(pos, this.getDefaultState().withProperty(LEVEL, meta));
        }
    }

    protected boolean canFlowInto(IBlockAccess world, BlockPos pos) {
        return world.getBlockState(pos).getBlock() == this || this.canDisplace(world, pos);
    }

    protected int getLargerQuanta(IBlockAccess world, BlockPos pos, int compare) {
        int quantaRemaining = this.getEffectiveQuanta(world, pos);
        if (quantaRemaining <= 0) {
            return compare;
        }
        return quantaRemaining >= compare ? quantaRemaining : compare;
    }

    @Override
    public int place(World world, BlockPos pos, @Nonnull FluidStack fluidStack, boolean doPlace) {
        if (fluidStack.amount < 1000) {
            return 0;
        }
        if (doPlace) {
            FluidUtil.destroyBlockOnFluidPlacement(world, pos);
            world.setBlockState(pos, this.getDefaultState(), 11);
        }
        return 1000;
    }

    @Override
    @Nullable
    public FluidStack drain(World world, BlockPos pos, boolean doDrain) {
        if (!this.isSourceBlock(world, pos)) {
            return null;
        }
        if (doDrain) {
            world.setBlockToAir(pos);
        }
        return this.stack.copy();
    }

    @Override
    public boolean canDrain(World world, BlockPos pos) {
        return this.isSourceBlock(world, pos);
    }
}

