/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.common.eventhandler.Event;

public class FluidEvent
extends Event {
    private final FluidStack fluid;
    private final World world;
    private final BlockPos pos;

    public FluidEvent(FluidStack fluid, World world, BlockPos pos) {
        this.fluid = fluid;
        this.world = world;
        this.pos = pos;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public static final void fireEvent(FluidEvent event) {
        MinecraftForge.EVENT_BUS.post(event);
    }

    public static class FluidSpilledEvent
    extends FluidEvent {
        public FluidSpilledEvent(FluidStack fluid, World world, BlockPos pos) {
            super(fluid, world, pos);
        }
    }

    public static class FluidDrainingEvent
    extends FluidEvent {
        private final IFluidTank tank;
        private final int amount;

        public FluidDrainingEvent(FluidStack fluid, World world, BlockPos pos, IFluidTank tank, int amount) {
            super(fluid, world, pos);
            this.amount = amount;
            this.tank = tank;
        }

        public IFluidTank getTank() {
            return this.tank;
        }

        public int getAmount() {
            return this.amount;
        }
    }

    public static class FluidFillingEvent
    extends FluidEvent {
        private final IFluidTank tank;
        private final int amount;

        public FluidFillingEvent(FluidStack fluid, World world, BlockPos pos, IFluidTank tank, int amount) {
            super(fluid, world, pos);
            this.tank = tank;
            this.amount = amount;
        }

        public IFluidTank getTank() {
            return this.tank;
        }

        public int getAmount() {
            return this.amount;
        }
    }

    public static class FluidMotionEvent
    extends FluidEvent {
        public FluidMotionEvent(FluidStack fluid, World world, BlockPos pos) {
            super(fluid, world, pos);
        }
    }
}

