/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.imageio.ImageIO;
import net.minecraft.client.resources.FileResourcePack;
import net.minecraftforge.fml.common.FMLContainerHolder;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ModContainer;

public class FMLFileResourcePack
extends FileResourcePack
implements FMLContainerHolder {
    private ModContainer container;

    public FMLFileResourcePack(ModContainer container) {
        super(container.getResource());
        this.container = container;
    }

    @Override
    public String getPackName() {
        return "FMLFileResourcePack:" + this.container.getName();
    }

    @Override
    protected InputStream getInputStreamByName(String resourceName) throws IOException {
        try {
            return super.getInputStreamByName(resourceName);
        }
        catch (IOException ioe) {
            if ("pack.mcmeta".equals(resourceName)) {
                FMLLog.log.debug("Mod {} is missing a pack.mcmeta file, substituting a dummy one", (Object)this.container.getName());
                return new ByteArrayInputStream(("{\n \"pack\": {\n   \"description\": \"dummy FML pack for " + this.container.getName() + "\",\n   \"pack_format\": 2\n}\n}").getBytes(StandardCharsets.UTF_8));
            }
            throw ioe;
        }
    }

    @Override
    public BufferedImage getPackImage() throws IOException {
        return ImageIO.read(this.getInputStreamByName(this.container.getMetadata().logoFile));
    }

    @Override
    public ModContainer getFMLContainer() {
        return this.container;
    }
}

