/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client;

import java.awt.Desktop;
import java.io.File;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiErrorScreen;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;

public class GuiErrorBase
extends GuiErrorScreen {
    static final File minecraftDir = new File(Loader.instance().getConfigDir().getParent());
    static final File logFile = new File(minecraftDir, "logs/latest.log");

    public GuiErrorBase() {
        super(null, null);
    }

    private String translateOrDefault(String translateKey, String alternative, Object ... format) {
        return I18n.hasKey(translateKey) ? I18n.format(translateKey, format) : String.format(alternative, format);
    }

    @Override
    public void initGui() {
        super.initGui();
        this.buttonList.clear();
        this.buttonList.add(new GuiButton(10, 50, this.height - 38, this.width / 2 - 55, 20, this.translateOrDefault("fml.button.open.mods.folder", "Open Mods Folder", new Object[0])));
        String openFileText = this.translateOrDefault("fml.button.open.file", "Open %s", logFile.getName());
        this.buttonList.add(new GuiButton(11, this.width / 2 + 5, this.height - 38, this.width / 2 - 55, 20, openFileText));
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        if (button.id == 10) {
            try {
                File modsDir = new File(minecraftDir, "mods");
                Desktop.getDesktop().open(modsDir);
            }
            catch (Exception e) {
                FMLLog.log.error("Problem opening mods folder", (Throwable)e);
            }
        } else if (button.id == 11) {
            try {
                Desktop.getDesktop().open(logFile);
            }
            catch (Exception e) {
                FMLLog.log.error("Problem opening log file {}", (Object)logFile, (Object)e);
            }
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        for (GuiButton button : this.buttonList) {
            button.drawButton(this.mc, mouseX, mouseY, partialTicks);
        }
    }
}

