/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client;

import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.GuiErrorBase;
import net.minecraftforge.fml.client.GuiScrollingList;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.MissingModsException;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.MultipleModsErrored;
import net.minecraftforge.fml.common.WrongMinecraftVersionException;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import org.lwjgl.input.Mouse;

public class GuiMultipleModsErrored
extends GuiErrorBase {
    private final List<WrongMinecraftVersionException> wrongMinecraftExceptions;
    private final List<MissingModsException> missingModsExceptions;
    private GuiList list;

    public GuiMultipleModsErrored(MultipleModsErrored exception) {
        this.wrongMinecraftExceptions = exception.wrongMinecraftExceptions;
        this.missingModsExceptions = exception.missingModsExceptions;
    }

    @Override
    public void initGui() {
        super.initGui();
        int additionalSize = this.missingModsExceptions.isEmpty() || this.wrongMinecraftExceptions.isEmpty() ? 20 : 55;
        for (MissingModsException exception : this.missingModsExceptions) {
            additionalSize += exception.getMissingModInfos().size() * 10;
        }
        this.list = new GuiList(this.wrongMinecraftExceptions.size() * 10 + this.missingModsExceptions.size() * 15 + additionalSize);
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.drawDefaultBackground();
        this.list.drawScreen(mouseX, mouseY, partialTicks);
        this.drawCenteredString(this.fontRenderer, I18n.format("fml.messages.mod.missing.multiple", this.missingModsExceptions.size() + this.wrongMinecraftExceptions.size()), this.width / 2, 10, 0xFFFFFF);
        super.drawScreen(mouseX, mouseY, partialTicks);
    }

    @Override
    public void actionPerformed(GuiButton button) {
        this.list.actionPerformed(button);
        super.actionPerformed(button);
    }

    @Override
    public void handleMouseInput() throws IOException {
        super.handleMouseInput();
        int mouseX = Mouse.getEventX() * this.width / this.mc.displayWidth;
        int mouseY = this.height - Mouse.getEventY() * this.height / this.mc.displayHeight - 1;
        this.list.handleMouseInput(mouseX, mouseY);
    }

    private class GuiList
    extends GuiScrollingList {
        public GuiList(int entryHeight) {
            super(GuiMultipleModsErrored.this.mc, GuiMultipleModsErrored.this.width - 20, GuiMultipleModsErrored.this.height - 30, 30, GuiMultipleModsErrored.this.height - 50, 10, entryHeight, GuiMultipleModsErrored.this.width, GuiMultipleModsErrored.this.height);
        }

        @Override
        protected int getSize() {
            return 1;
        }

        @Override
        protected void elementClicked(int index, boolean doubleClick) {
        }

        @Override
        protected boolean isSelected(int index) {
            return false;
        }

        @Override
        protected void drawBackground() {
            GuiMultipleModsErrored.this.drawDefaultBackground();
        }

        @Override
        protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
            int offset = slotTop;
            FontRenderer renderer = GuiMultipleModsErrored.this.fontRenderer;
            if (!GuiMultipleModsErrored.this.wrongMinecraftExceptions.isEmpty()) {
                renderer.drawString(String.valueOf((Object)TextFormatting.UNDERLINE) + I18n.format("fml.messages.mod.wrongminecraft", Loader.instance().getMinecraftModContainer().getVersion()), this.left, offset, 0xFFFFFF);
                offset += 15;
                for (WrongMinecraftVersionException wrongMinecraftVersionException : GuiMultipleModsErrored.this.wrongMinecraftExceptions) {
                    renderer.drawString(I18n.format("fml.messages.mod.wrongminecraft.requirement", String.valueOf((Object)TextFormatting.BOLD) + wrongMinecraftVersionException.mod.getName() + String.valueOf((Object)TextFormatting.RESET), wrongMinecraftVersionException.mod.getModId(), wrongMinecraftVersionException.mod.acceptableMinecraftVersionRange().toStringFriendly()), this.left, offset, 0xFFFFFF);
                    offset += 10;
                }
                renderer.drawString(I18n.format("fml.messages.mod.wrongminecraft.fix.multiple", new Object[0]), this.left, offset += 5, 0xFFFFFF);
                offset += 20;
            }
            if (!GuiMultipleModsErrored.this.missingModsExceptions.isEmpty()) {
                renderer.drawString(I18n.format("fml.messages.mod.missing.dependencies.multiple.issues", new Object[0]), this.left, offset, 0xFFFFFF);
                offset += 15;
                for (MissingModsException missingModsException : GuiMultipleModsErrored.this.missingModsExceptions) {
                    renderer.drawString(missingModsException.getModName() + ":", this.left, offset, 0xFFFFFF);
                    for (MissingModsException.MissingModInfo versionInfo : missingModsException.getMissingModInfos()) {
                        ModContainer acceptedMod;
                        DefaultArtifactVersion dav;
                        ArtifactVersion acceptedVersion = versionInfo.getAcceptedVersion();
                        String acceptedModId = acceptedVersion.getLabel();
                        ArtifactVersion currentVersion = versionInfo.getCurrentVersion();
                        String missingReason = currentVersion == null ? I18n.format("fml.messages.mod.missing.dependencies.missing", new Object[0]) : I18n.format("fml.messages.mod.missing.dependencies.you.have", currentVersion.getVersionString());
                        String acceptedModVersionString = acceptedVersion.getRangeString();
                        if (acceptedVersion instanceof DefaultArtifactVersion && (dav = (DefaultArtifactVersion)acceptedVersion).getRange() != null) {
                            acceptedModVersionString = dav.getRange().toStringFriendly();
                        }
                        String acceptedModName = (acceptedMod = Loader.instance().getIndexedModList().get(acceptedModId)) != null ? acceptedMod.getName() : acceptedModId;
                        String versionInfoText = String.format(String.valueOf((Object)TextFormatting.BOLD) + "%s " + String.valueOf((Object)TextFormatting.RESET) + "%s (%s)", acceptedModName, acceptedModVersionString, missingReason);
                        String message = versionInfo.isRequired() ? I18n.format("fml.messages.mod.missing.dependencies.requires", versionInfoText) : I18n.format("fml.messages.mod.missing.dependencies.compatible.with", versionInfoText);
                        renderer.drawString(message, this.left, offset += 10, 0xEEEEEE);
                    }
                    offset += 15;
                }
            }
        }
    }
}

