/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client;

import com.google.common.base.Strings;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.client.GuiModList;
import net.minecraftforge.fml.client.GuiScrollingList;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.ModContainer;

public class GuiSlotModList
extends GuiScrollingList {
    private static final ResourceLocation VERSION_CHECK_ICONS = new ResourceLocation("forge", "textures/gui/version_check_icons.png");
    private GuiModList parent;
    private ArrayList<ModContainer> mods;

    public GuiSlotModList(GuiModList parent, ArrayList<ModContainer> mods, int listWidth, int slotHeight) {
        super(parent.getMinecraftInstance(), listWidth, parent.height, 32, parent.height - 88 + 4, 10, slotHeight, parent.width, parent.height);
        this.parent = parent;
        this.mods = mods;
    }

    @Override
    protected int getSize() {
        return this.mods.size();
    }

    @Override
    protected void elementClicked(int index, boolean doubleClick) {
        this.parent.selectModIndex(index);
    }

    @Override
    protected boolean isSelected(int index) {
        return this.parent.modIndexSelected(index);
    }

    @Override
    protected void drawBackground() {
        this.parent.drawDefaultBackground();
    }

    @Override
    protected int getContentHeight() {
        return this.getSize() * 25 + 1;
    }

    ArrayList<ModContainer> getMods() {
        return this.mods;
    }

    @Override
    protected void drawSlot(int idx, int right, int top, int height, Tessellator tess) {
        ModContainer mc = this.mods.get(idx);
        String name = StringUtils.stripControlCodes(mc.getName());
        String version = StringUtils.stripControlCodes(Strings.isNullOrEmpty((String)mc.getDisplayVersion()) ? mc.getVersion() : mc.getDisplayVersion());
        FontRenderer font = this.parent.getFontRenderer();
        ForgeVersion.CheckResult vercheck = ForgeVersion.getCleanResult(mc);
        if (Loader.instance().getModState(mc) == LoaderState.ModState.DISABLED) {
            this.drawString(name, 10, top + 2, TextFormatting.RED);
            this.drawString(version, 5 + height, top + 12, TextFormatting.RED);
        } else {
            this.drawString(name, 10, top + 2, TextFormatting.WHITE);
            this.drawString(version, 5 + height, top + 12, TextFormatting.WHITE);
            if (vercheck != null && vercheck.status.shouldDraw()) {
                Minecraft.getMinecraft().getTextureManager().bindTexture(VERSION_CHECK_ICONS);
                GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
                GlStateManager.pushMatrix();
                Gui.drawModalRectWithCustomSizedTexture(right - (height / 2 + 4), top + (height / 2 - 4), vercheck.status.getSheetOffset() * 8, vercheck.status.isAnimated() && (System.currentTimeMillis() / 800L & 1L) == 1L ? 8.0f : 0.0f, 8, 8, 64.0f, 16.0f);
                GlStateManager.popMatrix();
            }
        }
    }

    protected void drawString(String text, int width, int y, TextFormatting color) {
        FontRenderer font = this.parent.getFontRenderer();
        TextComponentString textComponent = new TextComponentString(String.valueOf((Object)color) + font.trimStringToWidth(text, this.listWidth - width));
        font.drawString(textComponent.getFormattedText(), this.left + 3, y, 0);
    }
}

