/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client;

import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.toposort.ModSortingException;

public class GuiSortingProblem
extends GuiScreen {
    private ModSortingException.SortingExceptionData<ModContainer> failedList;

    public GuiSortingProblem(ModSortingException modSorting) {
        this.failedList = modSorting.getExceptionData();
    }

    @Override
    public void initGui() {
        super.initGui();
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.drawDefaultBackground();
        int offset = Math.max(85 - (this.failedList.getVisitedNodes().size() + 3) * 10, 10);
        this.drawCenteredString(this.fontRenderer, I18n.format("fml.messages.load.problem.found", new Object[0]), this.width / 2, offset, 0xFFFFFF);
        this.drawCenteredString(this.fontRenderer, "A mod sorting cycle was detected and loading cannot continue", this.width / 2, offset += 10, 0xFFFFFF);
        this.drawCenteredString(this.fontRenderer, String.format("The first mod in the cycle is %s", this.failedList.getFirstBadNode()), this.width / 2, offset += 10, 0xFFFFFF);
        this.drawCenteredString(this.fontRenderer, "The remainder of the cycle involves these mods", this.width / 2, offset += 10, 0xFFFFFF);
        offset += 5;
        for (ModContainer mc : this.failedList.getVisitedNodes()) {
            this.drawCenteredString(this.fontRenderer, String.format("%s : before: %s, after: %s", mc.toString(), mc.getDependants(), mc.getDependencies()), this.width / 2, offset += 10, 0xEEEEEE);
        }
        this.drawCenteredString(this.fontRenderer, "The file 'ForgeModLoader-client-0.log' contains more information", this.width / 2, offset += 20, 0xFFFFFF);
    }
}

