/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.GuiMessageDialog;
import net.minecraftforge.fml.client.config.GuiUnicodeGlyphButton;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.client.config.HoverChecker;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.lwjgl.input.Keyboard;

public class GuiConfig
extends GuiScreen {
    public final GuiScreen parentScreen;
    public String title = "Config GUI";
    @Nullable
    public String titleLine2;
    public final List<IConfigElement> configElements;
    public final List<GuiConfigEntries.IConfigEntry> initEntries;
    public GuiConfigEntries entryList;
    protected GuiButtonExt btnDefaultAll;
    protected GuiButtonExt btnUndoAll;
    protected GuiCheckBox chkApplyGlobally;
    public final String modID;
    @Nullable
    public final String configID;
    public final boolean isWorldRunning;
    public final boolean allRequireWorldRestart;
    public final boolean allRequireMcRestart;
    public boolean needsRefresh = true;
    protected HoverChecker undoHoverChecker;
    protected HoverChecker resetHoverChecker;
    protected HoverChecker checkBoxHoverChecker;

    public GuiConfig(GuiScreen parentScreen, String modid, String title) {
        this(parentScreen, modid, false, false, title, ConfigManager.getModConfigClasses(modid));
    }

    public GuiConfig(GuiScreen parentScreen, String modID, boolean allRequireWorldRestart, boolean allRequireMcRestart, String title, Class<?> ... configClasses) {
        this(parentScreen, GuiConfig.collectConfigElements(configClasses), modID, null, allRequireWorldRestart, allRequireMcRestart, title, null);
    }

    private static List<IConfigElement> collectConfigElements(Class<?>[] configClasses) {
        List<Object> toReturn;
        if (configClasses.length == 1) {
            toReturn = ConfigElement.from(configClasses[0]).getChildElements();
        } else {
            toReturn = new ArrayList();
            for (Class<?> clazz : configClasses) {
                toReturn.add(ConfigElement.from(clazz));
            }
        }
        toReturn.sort(Comparator.comparing(e -> I18n.format(e.getLanguageKey(), new Object[0])));
        return toReturn;
    }

    public GuiConfig(GuiScreen parentScreen, List<IConfigElement> configElements, String modID, String configID, boolean allRequireWorldRestart, boolean allRequireMcRestart, String title) {
        this(parentScreen, configElements, modID, configID, allRequireWorldRestart, allRequireMcRestart, title, null);
    }

    public GuiConfig(GuiScreen parentScreen, List<IConfigElement> configElements, String modID, boolean allRequireWorldRestart, boolean allRequireMcRestart, String title) {
        this(parentScreen, configElements, modID, null, allRequireWorldRestart, allRequireMcRestart, title, null);
    }

    public GuiConfig(GuiScreen parentScreen, List<IConfigElement> configElements, String modID, boolean allRequireWorldRestart, boolean allRequireMcRestart, String title, String titleLine2) {
        this(parentScreen, configElements, modID, null, allRequireWorldRestart, allRequireMcRestart, title, titleLine2);
    }

    public GuiConfig(GuiScreen parentScreen, List<IConfigElement> configElements, String modID, @Nullable String configID, boolean allRequireWorldRestart, boolean allRequireMcRestart, String title, @Nullable String titleLine2) {
        IConfigElement element;
        Iterator<IConfigElement> iterator;
        this.mc = Minecraft.getMinecraft();
        this.parentScreen = parentScreen;
        this.configElements = configElements;
        this.entryList = new GuiConfigEntries(this, this.mc);
        this.initEntries = new ArrayList<GuiConfigEntries.IConfigEntry>(this.entryList.listEntries);
        this.allRequireWorldRestart = allRequireWorldRestart;
        if (!allRequireWorldRestart) {
            iterator = configElements.iterator();
            if (iterator.hasNext()) {
                element = iterator.next();
                if (!element.requiresWorldRestart()) {
                    // empty if block
                }
            } else {
                allRequireWorldRestart = true;
            }
        }
        this.allRequireMcRestart = allRequireMcRestart;
        if (!allRequireMcRestart) {
            iterator = configElements.iterator();
            if (iterator.hasNext()) {
                element = iterator.next();
                if (!element.requiresMcRestart()) {
                    // empty if block
                }
            } else {
                allRequireMcRestart = true;
            }
        }
        this.modID = modID;
        this.configID = configID;
        boolean bl = this.isWorldRunning = this.mc.world != null;
        if (title != null) {
            this.title = title;
        }
        this.titleLine2 = titleLine2;
        if (this.titleLine2 != null && this.titleLine2.startsWith(" > ")) {
            this.titleLine2 = this.titleLine2.replaceFirst(" > ", "");
        }
    }

    public static String getAbridgedConfigPath(String path) {
        Minecraft mc = Minecraft.getMinecraft();
        if (mc.gameDir.getAbsolutePath().endsWith(".")) {
            return path.replace("\\", "/").replace(mc.gameDir.getAbsolutePath().replace("\\", "/").substring(0, mc.gameDir.getAbsolutePath().length() - 1), "/.minecraft/");
        }
        return path.replace("\\", "/").replace(mc.gameDir.getAbsolutePath().replace("\\", "/"), "/.minecraft");
    }

    @Override
    public void initGui() {
        Keyboard.enableRepeatEvents((boolean)true);
        if (this.entryList == null || this.needsRefresh) {
            this.entryList = new GuiConfigEntries(this, this.mc);
            this.needsRefresh = false;
        }
        int undoGlyphWidth = this.mc.fontRenderer.getStringWidth("\u21b6") * 2;
        int resetGlyphWidth = this.mc.fontRenderer.getStringWidth("\u2604") * 2;
        int doneWidth = Math.max(this.mc.fontRenderer.getStringWidth(I18n.format("gui.done", new Object[0])) + 20, 100);
        int undoWidth = this.mc.fontRenderer.getStringWidth(" " + I18n.format("fml.configgui.tooltip.undoChanges", new Object[0])) + undoGlyphWidth + 20;
        int resetWidth = this.mc.fontRenderer.getStringWidth(" " + I18n.format("fml.configgui.tooltip.resetToDefault", new Object[0])) + resetGlyphWidth + 20;
        int checkWidth = this.mc.fontRenderer.getStringWidth(I18n.format("fml.configgui.applyGlobally", new Object[0])) + 13;
        int buttonWidthHalf = (doneWidth + 5 + undoWidth + 5 + resetWidth + 5 + checkWidth) / 2;
        this.buttonList.add(new GuiButtonExt(2000, this.width / 2 - buttonWidthHalf, this.height - 29, doneWidth, 20, I18n.format("gui.done", new Object[0])));
        this.btnDefaultAll = new GuiUnicodeGlyphButton(2001, this.width / 2 - buttonWidthHalf + doneWidth + 5 + undoWidth + 5, this.height - 29, resetWidth, 20, " " + I18n.format("fml.configgui.tooltip.resetToDefault", new Object[0]), "\u2604", 2.0f);
        this.buttonList.add(this.btnDefaultAll);
        this.btnUndoAll = new GuiUnicodeGlyphButton(2002, this.width / 2 - buttonWidthHalf + doneWidth + 5, this.height - 29, undoWidth, 20, " " + I18n.format("fml.configgui.tooltip.undoChanges", new Object[0]), "\u21b6", 2.0f);
        this.buttonList.add(this.btnUndoAll);
        this.chkApplyGlobally = new GuiCheckBox(2003, this.width / 2 - buttonWidthHalf + doneWidth + 5 + undoWidth + 5 + resetWidth + 5, this.height - 24, I18n.format("fml.configgui.applyGlobally", new Object[0]), false);
        this.buttonList.add(this.chkApplyGlobally);
        this.undoHoverChecker = new HoverChecker(this.btnUndoAll, 800);
        this.resetHoverChecker = new HoverChecker(this.btnDefaultAll, 800);
        this.checkBoxHoverChecker = new HoverChecker(this.chkApplyGlobally, 800);
        this.entryList.initGui();
    }

    @Override
    public void onGuiClosed() {
        this.entryList.onGuiClosed();
        if (this.configID != null && this.parentScreen instanceof GuiConfig) {
            GuiConfig parentGuiConfig = (GuiConfig)this.parentScreen;
            parentGuiConfig.needsRefresh = true;
            parentGuiConfig.initGui();
        }
        if (!(this.parentScreen instanceof GuiConfig)) {
            Keyboard.enableRepeatEvents((boolean)false);
        }
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        if (button.id == 2000) {
            boolean flag = true;
            try {
                if ((this.configID != null || this.parentScreen == null || !(this.parentScreen instanceof GuiConfig)) && this.entryList.hasChangedEntry(true)) {
                    boolean requiresMcRestart = this.entryList.saveConfigElements();
                    if (Loader.isModLoaded(this.modID)) {
                        ConfigChangedEvent.OnConfigChangedEvent event = new ConfigChangedEvent.OnConfigChangedEvent(this.modID, this.configID, this.isWorldRunning, requiresMcRestart);
                        MinecraftForge.EVENT_BUS.post(event);
                        if (!event.getResult().equals((Object)Event.Result.DENY)) {
                            MinecraftForge.EVENT_BUS.post(new ConfigChangedEvent.PostConfigChangedEvent(this.modID, this.configID, this.isWorldRunning, requiresMcRestart));
                        }
                        if (requiresMcRestart) {
                            flag = false;
                            this.mc.displayGuiScreen(new GuiMessageDialog(this.parentScreen, "fml.configgui.gameRestartTitle", new TextComponentString(I18n.format("fml.configgui.gameRestartRequired", new Object[0])), "fml.configgui.confirmRestartMessage"));
                        }
                        if (this.parentScreen instanceof GuiConfig) {
                            ((GuiConfig)this.parentScreen).needsRefresh = true;
                        }
                    }
                }
            }
            catch (Throwable e) {
                FMLLog.log.error("Error performing GuiConfig action:", e);
            }
            if (flag) {
                this.mc.displayGuiScreen(this.parentScreen);
            }
        } else if (button.id == 2001) {
            this.entryList.setAllToDefault(this.chkApplyGlobally.isChecked());
        } else if (button.id == 2002) {
            this.entryList.undoAllChanges(this.chkApplyGlobally.isChecked());
        }
    }

    @Override
    public void handleMouseInput() throws IOException {
        super.handleMouseInput();
        this.entryList.handleMouseInput();
    }

    @Override
    protected void mouseClicked(int x, int y, int mouseEvent) throws IOException {
        if (mouseEvent != 0 || !this.entryList.mouseClicked(x, y, mouseEvent)) {
            this.entryList.mouseClickedPassThru(x, y, mouseEvent);
            super.mouseClicked(x, y, mouseEvent);
        }
    }

    @Override
    protected void mouseReleased(int x, int y, int mouseEvent) {
        if (mouseEvent != 0 || !this.entryList.mouseReleased(x, y, mouseEvent)) {
            super.mouseReleased(x, y, mouseEvent);
        }
    }

    @Override
    protected void keyTyped(char eventChar, int eventKey) {
        if (eventKey == 1) {
            this.mc.displayGuiScreen(this.parentScreen);
        } else {
            this.entryList.keyTyped(eventChar, eventKey);
        }
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        this.entryList.updateScreen();
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.drawDefaultBackground();
        this.entryList.drawScreen(mouseX, mouseY, partialTicks);
        this.drawCenteredString(this.fontRenderer, this.title, this.width / 2, 8, 0xFFFFFF);
        Object title2 = this.titleLine2;
        if (title2 != null) {
            int strWidth = this.mc.fontRenderer.getStringWidth((String)title2);
            int ellipsisWidth = this.mc.fontRenderer.getStringWidth("...");
            if (strWidth > this.width - 6 && strWidth > ellipsisWidth) {
                title2 = this.mc.fontRenderer.trimStringToWidth((String)title2, this.width - 6 - ellipsisWidth).trim() + "...";
            }
            this.drawCenteredString(this.fontRenderer, (String)title2, this.width / 2, 18, 0xFFFFFF);
        }
        this.btnUndoAll.enabled = this.entryList.areAnyEntriesEnabled(this.chkApplyGlobally.isChecked()) && this.entryList.hasChangedEntry(this.chkApplyGlobally.isChecked());
        this.btnDefaultAll.enabled = this.entryList.areAnyEntriesEnabled(this.chkApplyGlobally.isChecked()) && !this.entryList.areAllEntriesDefault(this.chkApplyGlobally.isChecked());
        super.drawScreen(mouseX, mouseY, partialTicks);
        this.entryList.drawScreenPost(mouseX, mouseY, partialTicks);
        if (this.undoHoverChecker.checkHover(mouseX, mouseY)) {
            this.drawToolTip(Arrays.asList(I18n.format("fml.configgui.tooltip.undoAll", new Object[0]).split("\n")), mouseX, mouseY);
        }
        if (this.resetHoverChecker.checkHover(mouseX, mouseY)) {
            this.drawToolTip(Arrays.asList(I18n.format("fml.configgui.tooltip.resetAll", new Object[0]).split("\n")), mouseX, mouseY);
        }
        if (this.checkBoxHoverChecker.checkHover(mouseX, mouseY)) {
            this.drawToolTip(Arrays.asList(I18n.format("fml.configgui.tooltip.applyGlobally", new Object[0]).split("\n")), mouseX, mouseY);
        }
    }

    public void drawToolTip(List<String> stringList, int x, int y) {
        GuiUtils.drawHoveringText(stringList, x, y, this.width, this.height, 300, this.fontRenderer);
    }
}

