/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiEditArrayEntries;
import net.minecraftforge.fml.client.config.GuiUnicodeGlyphButton;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.client.config.HoverChecker;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.common.FMLLog;

public class GuiEditArray
extends GuiScreen {
    protected GuiScreen parentScreen;
    protected IConfigElement configElement;
    protected GuiEditArrayEntries entryList;
    protected GuiButtonExt btnUndoChanges;
    protected GuiButtonExt btnDefault;
    protected GuiButtonExt btnDone;
    protected String title;
    protected String titleLine2;
    protected String titleLine3;
    protected int slotIndex;
    protected final Object[] beforeValues;
    protected Object[] currentValues;
    protected HoverChecker tooltipHoverChecker;
    protected List<String> toolTip;
    protected boolean enabled;

    public GuiEditArray(GuiScreen parentScreen, IConfigElement configElement, int slotIndex, Object[] currentValues, boolean enabled) {
        this.mc = Minecraft.getMinecraft();
        this.parentScreen = parentScreen;
        this.configElement = configElement;
        this.slotIndex = slotIndex;
        this.beforeValues = currentValues;
        this.currentValues = currentValues;
        this.toolTip = new ArrayList<String>();
        this.enabled = enabled;
        String propName = I18n.format(configElement.getLanguageKey(), new Object[0]);
        String comment = I18n.format(configElement.getLanguageKey() + ".tooltip", "\n" + String.valueOf((Object)TextFormatting.AQUA), configElement.getDefault(), configElement.getMinValue(), configElement.getMaxValue());
        if (!comment.equals(configElement.getLanguageKey() + ".tooltip")) {
            Collections.addAll(this.toolTip, (String.valueOf((Object)TextFormatting.GREEN) + propName + "\n" + String.valueOf((Object)TextFormatting.YELLOW) + comment).split("\n"));
        } else if (configElement.getComment() != null && !configElement.getComment().trim().isEmpty()) {
            Collections.addAll(this.toolTip, (String.valueOf((Object)TextFormatting.GREEN) + propName + "\n" + String.valueOf((Object)TextFormatting.YELLOW) + configElement.getComment()).split("\n"));
        } else {
            Collections.addAll(this.toolTip, (String.valueOf((Object)TextFormatting.GREEN) + propName + "\n" + String.valueOf((Object)TextFormatting.RED) + "No tooltip defined.").split("\n"));
        }
        if (parentScreen instanceof GuiConfig) {
            this.title = ((GuiConfig)parentScreen).title;
            if (((GuiConfig)parentScreen).titleLine2 != null) {
                this.titleLine2 = ((GuiConfig)parentScreen).titleLine2;
                this.titleLine3 = I18n.format(configElement.getLanguageKey(), new Object[0]);
            } else {
                this.titleLine2 = I18n.format(configElement.getLanguageKey(), new Object[0]);
            }
            this.tooltipHoverChecker = new HoverChecker(28, 37, 0, parentScreen.width, 800);
        } else {
            this.title = I18n.format(configElement.getLanguageKey(), new Object[0]);
            this.tooltipHoverChecker = new HoverChecker(8, 17, 0, parentScreen.width, 800);
        }
    }

    @Override
    public void initGui() {
        this.entryList = this.createEditArrayEntries();
        int undoGlyphWidth = this.mc.fontRenderer.getStringWidth("\u21b6") * 2;
        int resetGlyphWidth = this.mc.fontRenderer.getStringWidth("\u2604") * 2;
        int doneWidth = Math.max(this.mc.fontRenderer.getStringWidth(I18n.format("gui.done", new Object[0])) + 20, 100);
        int undoWidth = this.mc.fontRenderer.getStringWidth(" " + I18n.format("fml.configgui.tooltip.undoChanges", new Object[0])) + undoGlyphWidth + 20;
        int resetWidth = this.mc.fontRenderer.getStringWidth(" " + I18n.format("fml.configgui.tooltip.resetToDefault", new Object[0])) + resetGlyphWidth + 20;
        int buttonWidthHalf = (doneWidth + 5 + undoWidth + 5 + resetWidth) / 2;
        this.btnDone = new GuiButtonExt(2000, this.width / 2 - buttonWidthHalf, this.height - 29, doneWidth, 20, I18n.format("gui.done", new Object[0]));
        this.buttonList.add(this.btnDone);
        this.btnDefault = new GuiUnicodeGlyphButton(2001, this.width / 2 - buttonWidthHalf + doneWidth + 5 + undoWidth + 5, this.height - 29, resetWidth, 20, " " + I18n.format("fml.configgui.tooltip.resetToDefault", new Object[0]), "\u2604", 2.0f);
        this.buttonList.add(this.btnDefault);
        this.btnUndoChanges = new GuiUnicodeGlyphButton(2002, this.width / 2 - buttonWidthHalf + doneWidth + 5, this.height - 29, undoWidth, 20, " " + I18n.format("fml.configgui.tooltip.undoChanges", new Object[0]), "\u21b6", 2.0f);
        this.buttonList.add(this.btnUndoChanges);
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        if (button.id == 2000) {
            try {
                this.entryList.saveListChanges();
            }
            catch (Throwable e) {
                FMLLog.log.error("Error performing GuiEditArray action:", e);
            }
            this.mc.displayGuiScreen(this.parentScreen);
        } else if (button.id == 2001) {
            this.currentValues = this.configElement.getDefaults();
            this.entryList = this.createEditArrayEntries();
        } else if (button.id == 2002) {
            this.currentValues = Arrays.copyOf(this.beforeValues, this.beforeValues.length);
            this.entryList = this.createEditArrayEntries();
        }
    }

    protected GuiEditArrayEntries createEditArrayEntries() {
        return new GuiEditArrayEntries(this, this.mc, this.configElement, this.beforeValues, this.currentValues);
    }

    @Override
    public void handleMouseInput() throws IOException {
        super.handleMouseInput();
        this.entryList.handleMouseInput();
    }

    @Override
    protected void mouseClicked(int x, int y, int mouseEvent) throws IOException {
        if (mouseEvent != 0 || !this.entryList.mouseClicked(x, y, mouseEvent)) {
            this.entryList.mouseClickedPassThru(x, y, mouseEvent);
            super.mouseClicked(x, y, mouseEvent);
        }
    }

    @Override
    protected void mouseReleased(int x, int y, int mouseEvent) {
        if (mouseEvent != 0 || !this.entryList.mouseReleased(x, y, mouseEvent)) {
            super.mouseReleased(x, y, mouseEvent);
        }
    }

    @Override
    protected void keyTyped(char eventChar, int eventKey) {
        if (eventKey == 1) {
            this.mc.displayGuiScreen(this.parentScreen);
        } else {
            this.entryList.keyTyped(eventChar, eventKey);
        }
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        this.entryList.updateScreen();
    }

    @Override
    public void drawScreen(int par1, int par2, float par3) {
        this.drawDefaultBackground();
        this.entryList.drawScreen(par1, par2, par3);
        this.drawCenteredString(this.fontRenderer, this.title, this.width / 2, 8, 0xFFFFFF);
        if (this.titleLine2 != null) {
            this.drawCenteredString(this.fontRenderer, this.titleLine2, this.width / 2, 18, 0xFFFFFF);
        }
        if (this.titleLine3 != null) {
            this.drawCenteredString(this.fontRenderer, this.titleLine3, this.width / 2, 28, 0xFFFFFF);
        }
        this.btnDone.enabled = this.entryList.isListSavable();
        this.btnDefault.enabled = this.enabled && !this.entryList.isDefault();
        this.btnUndoChanges.enabled = this.enabled && this.entryList.isChanged();
        super.drawScreen(par1, par2, par3);
        this.entryList.drawScreenPost(par1, par2, par3);
        if (this.tooltipHoverChecker != null && this.tooltipHoverChecker.checkHover(par1, par2)) {
            this.drawToolTip(this.toolTip, par1, par2);
        }
    }

    public void drawToolTip(List<String> stringList, int x, int y) {
        GuiUtils.drawHoveringText(stringList, x, y, this.width, this.height, 300, this.fontRenderer);
    }
}

