/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.ConfigGuiType;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.GuiEditArray;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.client.config.HoverChecker;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.common.FMLLog;

public class GuiEditArrayEntries
extends GuiListExtended {
    protected GuiEditArray owningGui;
    public IConfigElement configElement;
    public List<IArrayEntry> listEntries;
    public boolean isDefault;
    public boolean isChanged;
    public boolean canAddMoreEntries;
    public final int controlWidth;
    public final Object[] beforeValues;
    public Object[] currentValues;

    public GuiEditArrayEntries(GuiEditArray parent, Minecraft mc, IConfigElement configElement, Object[] beforeValues, Object[] currentValues) {
        super(mc, parent.width, parent.height, parent.titleLine2 != null ? (parent.titleLine3 != null ? 43 : 33) : 23, parent.height - 32, 20);
        this.owningGui = parent;
        this.configElement = configElement;
        this.beforeValues = beforeValues;
        this.currentValues = currentValues;
        this.setShowSelectionBox(false);
        this.isChanged = !Arrays.deepEquals(beforeValues, currentValues);
        this.isDefault = Arrays.deepEquals(currentValues, configElement.getDefaults());
        this.canAddMoreEntries = !configElement.isListLengthFixed() && (configElement.getMaxListLength() == -1 || currentValues.length < configElement.getMaxListLength());
        this.listEntries = new ArrayList<IArrayEntry>();
        this.controlWidth = parent.width / 2 - (configElement.isListLengthFixed() ? 0 : 48);
        if (configElement.isList() && configElement.getArrayEntryClass() != null) {
            Class<? extends IArrayEntry> clazz = configElement.getArrayEntryClass();
            for (Object value : currentValues) {
                try {
                    this.listEntries.add(clazz.getConstructor(GuiEditArray.class, GuiEditArrayEntries.class, IConfigElement.class, Object.class).newInstance(this.owningGui, this, configElement, value));
                }
                catch (Throwable e) {
                    FMLLog.log.error("There was a critical error instantiating the custom IGuiEditListEntry for property {}.", (Object)configElement.getName(), (Object)e);
                }
            }
        } else if (configElement.isList() && configElement.getType().equals((Object)ConfigGuiType.BOOLEAN)) {
            for (Object value : currentValues) {
                this.listEntries.add(new BooleanEntry(this.owningGui, this, configElement, Boolean.valueOf(value.toString())));
            }
        } else if (configElement.isList() && configElement.getType().equals((Object)ConfigGuiType.INTEGER)) {
            for (Object value : currentValues) {
                this.listEntries.add(new IntegerEntry(this.owningGui, this, configElement, Integer.parseInt(value.toString())));
            }
        } else if (configElement.isList() && configElement.getType().equals((Object)ConfigGuiType.DOUBLE)) {
            for (Object value : currentValues) {
                this.listEntries.add(new DoubleEntry(this.owningGui, this, configElement, Double.parseDouble(value.toString())));
            }
        } else if (configElement.isList()) {
            for (Object value : currentValues) {
                this.listEntries.add(new StringEntry(this.owningGui, this, configElement, value.toString()));
            }
        }
        if (!configElement.isListLengthFixed()) {
            this.listEntries.add(new BaseEntry(this.owningGui, this, configElement));
        }
    }

    @Override
    protected int getScrollBarX() {
        return this.width - this.width / 4;
    }

    @Override
    public int getListWidth() {
        return this.owningGui.width;
    }

    @Override
    public IArrayEntry getListEntry(int index) {
        return this.listEntries.get(index);
    }

    @Override
    protected int getSize() {
        return this.listEntries.size();
    }

    public void addNewEntry(int index) {
        if (this.configElement.isList() && this.configElement.getArrayEntryClass() != null) {
            Class<? extends IArrayEntry> clazz = this.configElement.getArrayEntryClass();
            try {
                this.listEntries.add(index, clazz.getConstructor(GuiEditArray.class, GuiEditArrayEntries.class, IConfigElement.class, Object.class).newInstance(this.owningGui, this, this.configElement, switch (this.configElement.getType()) {
                    case ConfigGuiType.BOOLEAN -> true;
                    case ConfigGuiType.INTEGER -> 0;
                    case ConfigGuiType.DOUBLE -> 0.0;
                    default -> "";
                }));
            }
            catch (Throwable e) {
                FMLLog.log.error("There was a critical error instantiating the custom IGuiEditListEntry for property {}.", (Object)this.configElement.getName(), (Object)e);
            }
        } else if (this.configElement.isList() && this.configElement.getType() == ConfigGuiType.BOOLEAN) {
            this.listEntries.add(index, new BooleanEntry(this.owningGui, this, this.configElement, true));
        } else if (this.configElement.isList() && this.configElement.getType() == ConfigGuiType.INTEGER) {
            this.listEntries.add(index, new IntegerEntry(this.owningGui, this, this.configElement, 0));
        } else if (this.configElement.isList() && this.configElement.getType() == ConfigGuiType.DOUBLE) {
            this.listEntries.add(index, new DoubleEntry(this.owningGui, this, this.configElement, 0.0));
        } else if (this.configElement.isList()) {
            this.listEntries.add(index, new StringEntry(this.owningGui, this, this.configElement, ""));
        }
        this.canAddMoreEntries = !this.configElement.isListLengthFixed() && (this.configElement.getMaxListLength() == -1 || this.listEntries.size() - 1 < this.configElement.getMaxListLength());
        this.keyTyped('\u0000', 207);
    }

    public void removeEntry(int index) {
        this.listEntries.remove(index);
        this.canAddMoreEntries = !this.configElement.isListLengthFixed() && (this.configElement.getMaxListLength() == -1 || this.listEntries.size() - 1 < this.configElement.getMaxListLength());
        this.keyTyped('\u0000', 207);
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void recalculateState() {
        int i;
        int listLength;
        this.isDefault = true;
        this.isChanged = false;
        int n = listLength = this.configElement.isListLengthFixed() ? this.listEntries.size() : this.listEntries.size() - 1;
        if (listLength != this.configElement.getDefaults().length) {
            this.isDefault = false;
        }
        if (listLength != this.beforeValues.length) {
            this.isChanged = true;
        }
        if (this.isDefault) {
            for (i = 0; i < listLength; ++i) {
                if (this.configElement.getDefaults()[i].equals(this.listEntries.get(i).getValue())) continue;
                this.isDefault = false;
            }
        }
        if (!this.isChanged) {
            for (i = 0; i < listLength; ++i) {
                if (this.beforeValues[i].equals(this.listEntries.get(i).getValue())) continue;
                this.isChanged = true;
            }
        }
    }

    protected void keyTyped(char eventChar, int eventKey) {
        for (IArrayEntry entry : this.listEntries) {
            entry.keyTyped(eventChar, eventKey);
        }
        this.recalculateState();
    }

    protected void updateScreen() {
        for (IArrayEntry entry : this.listEntries) {
            entry.updateCursorCounter();
        }
    }

    protected void mouseClickedPassThru(int x, int y, int mouseEvent) {
        for (IArrayEntry entry : this.listEntries) {
            entry.mouseClicked(x, y, mouseEvent);
        }
    }

    protected boolean isListSavable() {
        for (IArrayEntry entry : this.listEntries) {
            if (entry.isValueSavable()) continue;
            return false;
        }
        return true;
    }

    protected void saveListChanges() {
        int listLength;
        int n = listLength = this.configElement.isListLengthFixed() ? this.listEntries.size() : this.listEntries.size() - 1;
        if (this.owningGui.slotIndex != -1 && this.owningGui.parentScreen != null && this.owningGui.parentScreen instanceof GuiConfig && ((GuiConfig)this.owningGui.parentScreen).entryList.getListEntry(this.owningGui.slotIndex) instanceof GuiConfigEntries.ArrayEntry) {
            GuiConfigEntries.ArrayEntry entry = (GuiConfigEntries.ArrayEntry)((GuiConfig)this.owningGui.parentScreen).entryList.getListEntry(this.owningGui.slotIndex);
            Object[] ao = new Object[listLength];
            for (int i = 0; i < listLength; ++i) {
                ao[i] = this.listEntries.get(i).getValue();
            }
            entry.setListFromChildScreen(ao);
        } else if (this.configElement.isList() && this.configElement.getType() == ConfigGuiType.BOOLEAN) {
            Object[] abol = new Boolean[listLength];
            for (int i = 0; i < listLength; ++i) {
                abol[i] = Boolean.valueOf(this.listEntries.get(i).getValue().toString());
            }
            this.configElement.set(abol);
        } else if (this.configElement.isList() && this.configElement.getType() == ConfigGuiType.INTEGER) {
            Object[] ai = new Integer[listLength];
            for (int i = 0; i < listLength; ++i) {
                ai[i] = Integer.valueOf(this.listEntries.get(i).getValue().toString());
            }
            this.configElement.set(ai);
        } else if (this.configElement.isList() && this.configElement.getType() == ConfigGuiType.DOUBLE) {
            Object[] ad = new Double[listLength];
            for (int i = 0; i < listLength; ++i) {
                ad[i] = Double.valueOf(this.listEntries.get(i).getValue().toString());
            }
            this.configElement.set(ad);
        } else if (this.configElement.isList()) {
            Object[] as = new String[listLength];
            for (int i = 0; i < listLength; ++i) {
                as[i] = this.listEntries.get(i).getValue().toString();
            }
            this.configElement.set(as);
        }
    }

    protected void drawScreenPost(int mouseX, int mouseY, float f) {
        for (IArrayEntry entry : this.listEntries) {
            entry.drawToolTip(mouseX, mouseY);
        }
    }

    public Minecraft getMC() {
        return this.mc;
    }

    public static interface IArrayEntry
    extends GuiListExtended.IGuiListEntry {
        public void keyTyped(char var1, int var2);

        public void updateCursorCounter();

        public void mouseClicked(int var1, int var2, int var3);

        public void drawToolTip(int var1, int var2);

        public boolean isValueSavable();

        public Object getValue();
    }

    public static class BooleanEntry
    extends BaseEntry {
        protected final GuiButtonExt btnValue;
        private boolean value;

        public BooleanEntry(GuiEditArray owningScreen, GuiEditArrayEntries owningEntryList, IConfigElement configElement, boolean value) {
            super(owningScreen, owningEntryList, configElement);
            this.value = value;
            this.btnValue = new GuiButtonExt(0, 0, 0, owningEntryList.controlWidth, 18, I18n.format(String.valueOf(value), new Object[0]));
            this.btnValue.enabled = owningScreen.enabled;
            this.isValidated = false;
        }

        @Override
        public void drawEntry(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partial) {
            super.drawEntry(slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected, partial);
            this.btnValue.x = listWidth / 4;
            this.btnValue.y = y;
            String trans = I18n.format(String.valueOf(this.value), new Object[0]);
            this.btnValue.displayString = !trans.equals(String.valueOf(this.value)) ? trans : String.valueOf(this.value);
            this.btnValue.packedFGColour = this.value ? GuiUtils.getColorCode('2', true) : GuiUtils.getColorCode('4', true);
            this.btnValue.drawButton(this.owningEntryList.getMC(), mouseX, mouseY, partial);
        }

        @Override
        public boolean mousePressed(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (this.btnValue.mousePressed(this.owningEntryList.getMC(), x, y)) {
                this.btnValue.playPressSound(this.owningEntryList.getMC().getSoundHandler());
                this.value = !this.value;
                this.owningEntryList.recalculateState();
                return true;
            }
            return super.mousePressed(index, x, y, mouseEvent, relativeX, relativeY);
        }

        @Override
        public void mouseReleased(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            this.btnValue.mouseReleased(x, y);
            super.mouseReleased(index, x, y, mouseEvent, relativeX, relativeY);
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }

    public static class IntegerEntry
    extends StringEntry {
        public IntegerEntry(GuiEditArray owningScreen, GuiEditArrayEntries owningEntryList, IConfigElement configElement, Integer value) {
            super(owningScreen, owningEntryList, configElement, value);
            this.isValidated = true;
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
            block7: {
                if (this.owningScreen.enabled || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                    String validChars = "0123456789";
                    String before = this.textFieldValue.getText();
                    if (validChars.contains(String.valueOf(eventChar)) || !before.startsWith("-") && this.textFieldValue.getCursorPosition() == 0 && eventChar == '-' || eventKey == 14 || eventKey == 211 || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                        this.textFieldValue.textboxKeyTyped(this.owningScreen.enabled ? eventChar : (char)'\u0000', eventKey);
                    }
                    if (!this.textFieldValue.getText().trim().isEmpty() && !this.textFieldValue.getText().trim().equals("-")) {
                        try {
                            long value = Long.parseLong(this.textFieldValue.getText().trim());
                            if (value < (long)Integer.valueOf(this.configElement.getMinValue().toString()).intValue() || value > (long)Integer.valueOf(this.configElement.getMaxValue().toString()).intValue()) {
                                this.isValidValue = false;
                                break block7;
                            }
                            this.isValidValue = true;
                        }
                        catch (Throwable e) {
                            this.isValidValue = false;
                        }
                    } else {
                        this.isValidValue = false;
                    }
                }
            }
        }

        @Override
        public Integer getValue() {
            try {
                return Integer.valueOf(this.textFieldValue.getText().trim());
            }
            catch (Throwable e) {
                return Integer.MAX_VALUE;
            }
        }
    }

    public static class DoubleEntry
    extends StringEntry {
        public DoubleEntry(GuiEditArray owningScreen, GuiEditArrayEntries owningEntryList, IConfigElement configElement, Double value) {
            super(owningScreen, owningEntryList, configElement, value);
            this.isValidated = true;
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
            block7: {
                if (this.owningScreen.enabled || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                    String validChars = "0123456789";
                    String before = this.textFieldValue.getText();
                    if (validChars.contains(String.valueOf(eventChar)) || !before.startsWith("-") && this.textFieldValue.getCursorPosition() == 0 && eventChar == '-' || !before.contains(".") && eventChar == '.' || eventKey == 14 || eventKey == 211 || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                        this.textFieldValue.textboxKeyTyped(this.owningScreen.enabled ? eventChar : (char)'\u0000', eventKey);
                    }
                    if (!this.textFieldValue.getText().trim().isEmpty() && !this.textFieldValue.getText().trim().equals("-")) {
                        try {
                            double value = Double.parseDouble(this.textFieldValue.getText().trim());
                            if (value < Double.valueOf(this.configElement.getMinValue().toString()) || value > Double.valueOf(this.configElement.getMaxValue().toString())) {
                                this.isValidValue = false;
                                break block7;
                            }
                            this.isValidValue = true;
                        }
                        catch (Throwable e) {
                            this.isValidValue = false;
                        }
                    } else {
                        this.isValidValue = false;
                    }
                }
            }
        }

        @Override
        public Double getValue() {
            try {
                return Double.valueOf(this.textFieldValue.getText().trim());
            }
            catch (Throwable e) {
                return Double.MAX_VALUE;
            }
        }
    }

    public static class StringEntry
    extends BaseEntry {
        protected final GuiTextField textFieldValue;

        public StringEntry(GuiEditArray owningScreen, GuiEditArrayEntries owningEntryList, IConfigElement configElement, Object value) {
            super(owningScreen, owningEntryList, configElement);
            this.textFieldValue = new GuiTextField(0, owningEntryList.getMC().fontRenderer, owningEntryList.width / 4 + 1, 0, owningEntryList.controlWidth - 3, 16);
            this.textFieldValue.setMaxStringLength(10000);
            this.textFieldValue.setText(value.toString());
            boolean bl = this.isValidated = configElement.getValidationPattern() != null;
            if (configElement.getValidationPattern() != null) {
                this.isValidValue = configElement.getValidationPattern().matcher(this.textFieldValue.getText().trim()).matches();
            }
        }

        @Override
        public void drawEntry(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partial) {
            super.drawEntry(slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected, partial);
            if (this.configElement.isListLengthFixed() || slotIndex != this.owningEntryList.listEntries.size() - 1) {
                this.textFieldValue.setVisible(true);
                this.textFieldValue.y = y + 1;
                this.textFieldValue.drawTextBox();
            } else {
                this.textFieldValue.setVisible(false);
            }
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
            if (this.owningScreen.enabled || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                this.textFieldValue.textboxKeyTyped(this.owningScreen.enabled ? eventChar : (char)'\u0000', eventKey);
                if (this.configElement.getValidationPattern() != null) {
                    this.isValidValue = this.configElement.getValidationPattern().matcher(this.textFieldValue.getText().trim()).matches();
                }
            }
        }

        @Override
        public void updateCursorCounter() {
            this.textFieldValue.updateCursorCounter();
        }

        @Override
        public void mouseClicked(int x, int y, int mouseEvent) {
            this.textFieldValue.mouseClicked(x, y, mouseEvent);
        }

        @Override
        public Object getValue() {
            return this.textFieldValue.getText().trim();
        }
    }

    public static class BaseEntry
    implements IArrayEntry {
        protected final GuiEditArray owningScreen;
        protected final GuiEditArrayEntries owningEntryList;
        protected final IConfigElement configElement;
        protected final GuiButtonExt btnAddNewEntryAbove;
        private final HoverChecker addNewEntryAboveHoverChecker;
        protected final GuiButtonExt btnRemoveEntry;
        private final HoverChecker removeEntryHoverChecker;
        private List<String> addNewToolTip;
        private List<String> removeToolTip;
        protected boolean isValidValue = true;
        protected boolean isValidated = false;

        public BaseEntry(GuiEditArray owningScreen, GuiEditArrayEntries owningEntryList, IConfigElement configElement) {
            this.owningScreen = owningScreen;
            this.owningEntryList = owningEntryList;
            this.configElement = configElement;
            this.btnAddNewEntryAbove = new GuiButtonExt(0, 0, 0, 18, 18, "+");
            this.btnAddNewEntryAbove.packedFGColour = GuiUtils.getColorCode('2', true);
            this.btnAddNewEntryAbove.enabled = owningScreen.enabled;
            this.btnRemoveEntry = new GuiButtonExt(0, 0, 0, 18, 18, "x");
            this.btnRemoveEntry.packedFGColour = GuiUtils.getColorCode('c', true);
            this.btnRemoveEntry.enabled = owningScreen.enabled;
            this.addNewEntryAboveHoverChecker = new HoverChecker(this.btnAddNewEntryAbove, 800);
            this.removeEntryHoverChecker = new HoverChecker(this.btnRemoveEntry, 800);
            this.addNewToolTip = new ArrayList<String>();
            this.removeToolTip = new ArrayList<String>();
            this.addNewToolTip.add(I18n.format("fml.configgui.tooltip.addNewEntryAbove", new Object[0]));
            this.removeToolTip.add(I18n.format("fml.configgui.tooltip.removeEntry", new Object[0]));
        }

        @Override
        public void drawEntry(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partial) {
            if (this.getValue() != null && this.isValidated) {
                this.owningEntryList.getMC().fontRenderer.drawString(this.isValidValue ? String.valueOf((Object)TextFormatting.GREEN) + "\u2714" : String.valueOf((Object)TextFormatting.RED) + "\u2715", listWidth / 4 - this.owningEntryList.getMC().fontRenderer.getStringWidth("\u2714") - 2, y + slotHeight / 2 - this.owningEntryList.getMC().fontRenderer.FONT_HEIGHT / 2, 0xFFFFFF);
            }
            int half = listWidth / 2;
            if (this.owningEntryList.canAddMoreEntries) {
                this.btnAddNewEntryAbove.visible = true;
                this.btnAddNewEntryAbove.x = half + (half / 2 - 44);
                this.btnAddNewEntryAbove.y = y;
                this.btnAddNewEntryAbove.drawButton(this.owningEntryList.getMC(), mouseX, mouseY, partial);
            } else {
                this.btnAddNewEntryAbove.visible = false;
            }
            if (!this.configElement.isListLengthFixed() && slotIndex != this.owningEntryList.listEntries.size() - 1) {
                this.btnRemoveEntry.visible = true;
                this.btnRemoveEntry.x = half + (half / 2 - 22);
                this.btnRemoveEntry.y = y;
                this.btnRemoveEntry.drawButton(this.owningEntryList.getMC(), mouseX, mouseY, partial);
            } else {
                this.btnRemoveEntry.visible = false;
            }
        }

        @Override
        public void drawToolTip(int mouseX, int mouseY) {
            boolean canHover;
            boolean bl = canHover = mouseY < this.owningEntryList.bottom && mouseY > this.owningEntryList.top;
            if (this.btnAddNewEntryAbove.visible && this.addNewEntryAboveHoverChecker.checkHover(mouseX, mouseY, canHover)) {
                this.owningScreen.drawToolTip(this.addNewToolTip, mouseX, mouseY);
            }
            if (this.btnRemoveEntry.visible && this.removeEntryHoverChecker.checkHover(mouseX, mouseY, canHover)) {
                this.owningScreen.drawToolTip(this.removeToolTip, mouseX, mouseY);
            }
        }

        @Override
        public boolean mousePressed(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (this.btnAddNewEntryAbove.mousePressed(this.owningEntryList.getMC(), x, y)) {
                this.btnAddNewEntryAbove.playPressSound(this.owningEntryList.getMC().getSoundHandler());
                this.owningEntryList.addNewEntry(index);
                this.owningEntryList.recalculateState();
                return true;
            }
            if (this.btnRemoveEntry.mousePressed(this.owningEntryList.getMC(), x, y)) {
                this.btnRemoveEntry.playPressSound(this.owningEntryList.getMC().getSoundHandler());
                this.owningEntryList.removeEntry(index);
                this.owningEntryList.recalculateState();
                return true;
            }
            return false;
        }

        @Override
        public void mouseReleased(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            this.btnAddNewEntryAbove.mouseReleased(x, y);
            this.btnRemoveEntry.mouseReleased(x, y);
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
        }

        @Override
        public void updateCursorCounter() {
        }

        @Override
        public void mouseClicked(int x, int y, int mouseEvent) {
        }

        @Override
        public boolean isValueSavable() {
            return this.isValidValue;
        }

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public void updatePosition(int p_178011_1_, int p_178011_2_, int p_178011_3_, float partial) {
        }
    }
}

