/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.VersionParser;

public class MetadataCollection {
    private ModMetadata[] modList;
    private final Map<String, ModMetadata> metadatas = Maps.newHashMap();

    public static MetadataCollection from(@Nullable InputStream inputStream, String sourceName) {
        if (inputStream == null) {
            return new MetadataCollection();
        }
        InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        try {
            MetadataCollection collection;
            Gson gson = new GsonBuilder().registerTypeAdapter(ArtifactVersion.class, (Object)new ArtifactVersionAdapter()).create();
            JsonElement rootElement = JsonParser.parseReader((Reader)reader);
            if (rootElement.isJsonArray()) {
                collection = new MetadataCollection();
                JsonArray jsonList = rootElement.getAsJsonArray();
                collection.modList = new ModMetadata[jsonList.size()];
                int i = 0;
                for (JsonElement mod : jsonList) {
                    collection.modList[i++] = (ModMetadata)gson.fromJson(mod, ModMetadata.class);
                }
            } else {
                collection = (MetadataCollection)gson.fromJson(rootElement, MetadataCollection.class);
            }
            collection.parseModMetadataList();
            return collection;
        }
        catch (JsonParseException e) {
            FMLLog.log.error("The mcmod.info file in {} cannot be parsed as valid JSON. It will be ignored", (Object)sourceName, (Object)e);
            return new MetadataCollection();
        }
    }

    private void parseModMetadataList() {
        for (ModMetadata modMetadata : this.modList) {
            this.metadatas.put(modMetadata.modId, modMetadata);
        }
    }

    public ModMetadata getMetadataForId(String modId, Map<String, Object> extraData) {
        if (!this.metadatas.containsKey(modId)) {
            ModMetadata dummy = new ModMetadata();
            dummy.modId = modId;
            dummy.name = (String)extraData.get("name");
            dummy.version = (String)extraData.get("version");
            dummy.autogenerated = true;
            this.metadatas.put(modId, dummy);
        }
        return this.metadatas.get(modId);
    }

    public static class ArtifactVersionAdapter
    extends TypeAdapter<ArtifactVersion> {
        public void write(JsonWriter out, ArtifactVersion value) throws IOException {
        }

        public ArtifactVersion read(JsonReader in) throws IOException {
            return VersionParser.parseVersionReference(in.nextString());
        }
    }
}

