/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.asm.transformers;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class SoundEngineFixTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        switch (transformedName) {
            case "paulscode.sound.Source": {
                ClassNode classNode = new ClassNode();
                ClassReader classReader = new ClassReader(basicClass);
                classReader.accept((ClassVisitor)classNode, 0);
                classNode.fields.add(new FieldNode(1, "removed", "Z", null, null));
                ClassWriter writer = new ClassWriter(1);
                classNode.accept((ClassVisitor)writer);
                return writer.toByteArray();
            }
            case "paulscode.sound.Library": {
                ClassNode classNode = new ClassNode();
                ClassReader classReader = new ClassReader(basicClass);
                classReader.accept((ClassVisitor)classNode, 0);
                MethodNode method = SoundEngineFixTransformer.getMethodNode(classNode, "removeSource", "(Ljava/lang/String;)V", transformedName, " - no removeSource method found");
                AbstractInsnNode referenceNode = null;
                for (AbstractInsnNode insn : method.instructions) {
                    if (!(insn instanceof MethodInsnNode) || !((MethodInsnNode)insn).owner.equals("paulscode/sound/Source") || !((MethodInsnNode)insn).name.equals("cleanup")) continue;
                    referenceNode = insn;
                    break;
                }
                if (referenceNode != null) {
                    LabelNode after = (LabelNode)referenceNode.getNext();
                    AbstractInsnNode beginning = referenceNode.getPrevious();
                    int varIndex = ((VarInsnNode)beginning).var;
                    method.instructions.insertBefore(beginning, (AbstractInsnNode)new VarInsnNode(25, varIndex));
                    method.instructions.insertBefore(beginning, (AbstractInsnNode)new FieldInsnNode(180, "paulscode/sound/Source", "toStream", "Z"));
                    LabelNode elseNode = new LabelNode();
                    method.instructions.insertBefore(beginning, (AbstractInsnNode)new JumpInsnNode(153, elseNode));
                    method.instructions.insertBefore(beginning, (AbstractInsnNode)new VarInsnNode(25, varIndex));
                    method.instructions.insertBefore(beginning, (AbstractInsnNode)new InsnNode(4));
                    method.instructions.insertBefore(beginning, (AbstractInsnNode)new FieldInsnNode(181, "paulscode/sound/Source", "removed", "Z"));
                    method.instructions.insertBefore(beginning, (AbstractInsnNode)new JumpInsnNode(167, after));
                    method.instructions.insertBefore(beginning, (AbstractInsnNode)elseNode);
                }
                ClassWriter writer = new ClassWriter(1);
                classNode.accept((ClassVisitor)writer);
                return writer.toByteArray();
            }
            case "paulscode.sound.StreamThread": {
                ClassNode classNode = new ClassNode();
                ClassReader classReader = new ClassReader(basicClass);
                classReader.accept((ClassVisitor)classNode, 0);
                MethodNode method = SoundEngineFixTransformer.getMethodNode(classNode, "run", "()V", transformedName, " - no run method found");
                AbstractInsnNode referenceNode = null;
                for (AbstractInsnNode insn : method.instructions) {
                    if (!(insn instanceof MethodInsnNode) || !((MethodInsnNode)insn).owner.equals("java/util/ListIterator") || !((MethodInsnNode)insn).name.equals("next")) continue;
                    referenceNode = insn.getNext().getNext();
                    break;
                }
                if (referenceNode != null) {
                    int varIndex = ((VarInsnNode)referenceNode).var;
                    LabelNode after = (LabelNode)referenceNode.getNext();
                    method.instructions.insertBefore((AbstractInsnNode)after, (AbstractInsnNode)new VarInsnNode(25, varIndex));
                    method.instructions.insertBefore((AbstractInsnNode)after, (AbstractInsnNode)new FieldInsnNode(180, "paulscode/sound/Source", "removed", "Z"));
                    method.instructions.insertBefore((AbstractInsnNode)after, (AbstractInsnNode)new JumpInsnNode(153, after));
                    method.instructions.insertBefore((AbstractInsnNode)after, (AbstractInsnNode)new VarInsnNode(25, varIndex));
                    method.instructions.insertBefore((AbstractInsnNode)after, (AbstractInsnNode)new MethodInsnNode(182, "paulscode/sound/Source", "cleanup", "()V", false));
                    method.instructions.insertBefore((AbstractInsnNode)after, (AbstractInsnNode)new InsnNode(1));
                    method.instructions.insertBefore((AbstractInsnNode)after, (AbstractInsnNode)new VarInsnNode(58, varIndex));
                }
                ClassWriter writer = new ClassWriter(1);
                classNode.accept((ClassVisitor)writer);
                return writer.toByteArray();
            }
        }
        return basicClass;
    }

    private static MethodNode getMethodNode(ClassNode classNode, String removeSource, String anObject, String transformedName, String x) {
        MethodNode method = null;
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals(removeSource) || !m.desc.equals(anObject)) continue;
            method = m;
            break;
        }
        if (method == null) {
            throw new RuntimeException("Error processing " + transformedName + x);
        }
        return method;
    }
}

