/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.gameevent;

import javax.annotation.Nonnull;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.Event;

public class PlayerEvent
extends Event {
    public final EntityPlayer player;

    private PlayerEvent(EntityPlayer player) {
        this.player = player;
    }

    public static class PlayerChangedDimensionEvent
    extends PlayerEvent {
        public final int fromDim;
        public final int toDim;

        public PlayerChangedDimensionEvent(EntityPlayer player, int fromDim, int toDim) {
            super(player);
            this.fromDim = fromDim;
            this.toDim = toDim;
        }
    }

    public static class PlayerRespawnEvent
    extends PlayerEvent {
        private final boolean endConquered;

        public PlayerRespawnEvent(EntityPlayer player, boolean endConquered) {
            super(player);
            this.endConquered = endConquered;
        }

        public boolean isEndConquered() {
            return this.endConquered;
        }
    }

    public static class PlayerLoggedOutEvent
    extends PlayerEvent {
        public PlayerLoggedOutEvent(EntityPlayer player) {
            super(player);
        }
    }

    public static class PlayerLoggedInEvent
    extends PlayerEvent {
        public PlayerLoggedInEvent(EntityPlayer player) {
            super(player);
        }
    }

    public static class ItemSmeltedEvent
    extends PlayerEvent {
        @Nonnull
        public final ItemStack smelting;

        public ItemSmeltedEvent(EntityPlayer player, @Nonnull ItemStack crafting) {
            super(player);
            this.smelting = crafting;
        }
    }

    public static class ItemCraftedEvent
    extends PlayerEvent {
        @Nonnull
        public final ItemStack crafting;
        public final IInventory craftMatrix;

        public ItemCraftedEvent(EntityPlayer player, @Nonnull ItemStack crafting, IInventory craftMatrix) {
            super(player);
            this.crafting = crafting;
            this.craftMatrix = craftMatrix;
        }
    }

    public static class ItemPickupEvent
    extends PlayerEvent {
        @Deprecated
        public final EntityItem pickedUp;
        private final EntityItem originalEntity;
        private final ItemStack stack;

        public ItemPickupEvent(EntityPlayer player, EntityItem entPickedUp, ItemStack stack) {
            super(player);
            this.originalEntity = entPickedUp;
            this.pickedUp = entPickedUp;
            this.stack = stack;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public EntityItem getOriginalEntity() {
            return this.originalEntity;
        }
    }
}

