/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network.internal;

import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.network.play.INetHandlerPlayServer;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.network.play.server.SPacketCustomPayload;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLNetworkException;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.handshake.NetworkDispatcher;
import net.minecraftforge.fml.relauncher.Side;

public class FMLProxyPacket
implements Packet<INetHandler> {
    final String channel;
    private Side target;
    private final PacketBuffer payload;
    private INetHandler netHandler;
    private NetworkDispatcher dispatcher;
    private static Multiset<String> badPackets = ConcurrentHashMultiset.create();
    private static int packetCountWarning = Integer.parseInt(System.getProperty("fml.badPacketCounter", "100"));
    static final int PART_SIZE = 1048496;
    public static final int MAX_LENGTH = 267366480;

    public FMLProxyPacket(SPacketCustomPayload original) {
        this(original.getBufferData(), original.getChannelName());
        this.target = Side.CLIENT;
    }

    public FMLProxyPacket(CPacketCustomPayload original) {
        this(original.getBufferData(), original.getChannelName());
        this.target = Side.SERVER;
    }

    public FMLProxyPacket(PacketBuffer payload, String channel) {
        this.channel = channel;
        this.payload = payload;
    }

    @Override
    public void readPacketData(PacketBuffer packetbuffer) throws IOException {
    }

    @Override
    public void writePacketData(PacketBuffer packetbuffer) throws IOException {
    }

    @Override
    public void processPacket(INetHandler inethandler) {
        this.netHandler = inethandler;
        FMLEmbeddedChannel internalChannel = NetworkRegistry.INSTANCE.getChannel(this.channel, this.target);
        if (internalChannel != null) {
            internalChannel.attr(NetworkRegistry.NET_HANDLER).set((Object)this.netHandler);
            try {
                if (internalChannel.writeInbound(new Object[]{this})) {
                    badPackets.add((Object)this.channel);
                    if (badPackets.size() % packetCountWarning == 0) {
                        FMLLog.log.fatal("Detected ongoing potential memory leak. {} packets have leaked. Top offenders", (Object)badPackets.size());
                        int i = 0;
                        for (Multiset.Entry s : Multisets.copyHighestCountFirst(badPackets).entrySet()) {
                            if (i++ > 10) break;
                            FMLLog.log.fatal("\t {} : {}", s.getElement(), (Object)s.getCount());
                        }
                    }
                }
                internalChannel.inboundMessages().clear();
            }
            catch (FMLNetworkException ne) {
                FMLLog.log.error("There was a network exception handling a packet on channel {}", (Object)this.channel, (Object)ne);
                this.dispatcher.rejectHandshake(ne.getMessage());
            }
            catch (Throwable t) {
                FMLLog.log.error("There was a critical exception handling a packet on channel {}", (Object)this.channel, (Object)t);
                this.dispatcher.rejectHandshake("A fatal error has occurred, this connection is terminated");
            }
        }
    }

    public String channel() {
        return this.channel;
    }

    public ByteBuf payload() {
        return this.payload;
    }

    public INetHandler handler() {
        return this.netHandler;
    }

    public Packet<INetHandlerPlayServer> toC17Packet() {
        return new CPacketCustomPayload(this.channel, this.payload);
    }

    public List<Packet<INetHandlerPlayClient>> toS3FPackets() throws IOException {
        ArrayList ret = Lists.newArrayList();
        byte[] data = this.payload.array();
        if (data.length < 1048496) {
            ret.add(new SPacketCustomPayload(this.channel, new PacketBuffer(this.payload.duplicate())));
        } else {
            int parts = (int)Math.ceil((double)data.length / 1048495.0);
            if (parts > 255) {
                throw new IllegalArgumentException("Payload may not be larger than 267366480 bytes");
            }
            PacketBuffer preamble = new PacketBuffer(Unpooled.buffer());
            preamble.writeString(this.channel);
            preamble.writeByte(parts);
            preamble.writeInt(data.length);
            ret.add(new SPacketCustomPayload("FML|MP", preamble));
            int offset = 0;
            for (int x = 0; x < parts; ++x) {
                int length = Math.min(1048496, data.length - offset + 1);
                byte[] tmp = new byte[length];
                tmp[0] = (byte)(x & 0xFF);
                System.arraycopy(data, offset, tmp, 1, tmp.length - 1);
                offset += tmp.length - 1;
                ret.add(new SPacketCustomPayload("FML|MP", new PacketBuffer(Unpooled.wrappedBuffer((byte[])tmp))));
            }
        }
        return ret;
    }

    public void setTarget(Side target) {
        this.target = target;
    }

    public void setDispatcher(NetworkDispatcher networkDispatcher) {
        this.dispatcher = networkDispatcher;
    }

    @Nullable
    public NetworkManager getOrigin() {
        return this.dispatcher != null ? this.dispatcher.manager : null;
    }

    public NetworkDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public Side getTarget() {
        return this.target;
    }

    public FMLProxyPacket copy() {
        FMLProxyPacket pkt = new FMLProxyPacket(new PacketBuffer(this.payload.duplicate()), this.channel);
        pkt.dispatcher = this.dispatcher;
        pkt.netHandler = this.netHandler;
        pkt.target = this.target;
        return pkt;
    }
}

