/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.network.internal.FMLMessage;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.GameData;

public class EntityRegistry {
    private static final EntityRegistry INSTANCE = new EntityRegistry();
    private final ListMultimap<ModContainer, EntityRegistration> entityRegistrations = ArrayListMultimap.create();
    private final BiMap<Class<? extends Entity>, EntityRegistration> entityClassRegistrations = HashBiMap.create();
    private final Map<Class<? extends Entity>, EntityEntry> entityClassEntries = GameData.getEntityClassMap();

    public static EntityRegistry instance() {
        return INSTANCE;
    }

    private EntityRegistry() {
    }

    @Deprecated
    public static void registerModEntity(ResourceLocation registryName, Class<? extends Entity> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.instance().doModEntityRegistration(registryName, entityClass, entityName, id, mod, trackingRange, updateFrequency, sendsVelocityUpdates);
    }

    @Deprecated
    public static void registerModEntity(ResourceLocation registryName, Class<? extends Entity> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int eggPrimary, int eggSecondary) {
        EntityRegistry.instance().doModEntityRegistration(registryName, entityClass, entityName, id, mod, trackingRange, updateFrequency, sendsVelocityUpdates);
        EntityRegistry.registerEgg(registryName, eggPrimary, eggSecondary);
    }

    private void doModEntityRegistration(ResourceLocation registryName, Class<? extends Entity> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        ModContainer mc = FMLCommonHandler.instance().findContainerFor(mod);
        EntityRegistration er = new EntityRegistration(this, mc, registryName, entityClass, entityName, id, trackingRange, updateFrequency, sendsVelocityUpdates);
        try {
            this.entityClassRegistrations.put(entityClass, (Object)er);
            if (!ForgeRegistries.ENTITIES.containsKey(registryName)) {
                EntityEntry entry = (EntityEntry)new EntityEntry(entityClass, entityName).setRegistryName(registryName);
                ForgeRegistries.ENTITIES.register(entry);
                FMLLog.log.trace("Automatically registered mod {} entity {} as {}", (Object)mc.getModId(), (Object)entityName, (Object)entry.getRegistryName());
            } else {
                FMLLog.log.debug("Skipping automatic mod {} entity registration for already registered entry {} class {}", (Object)mc.getModId(), (Object)registryName, (Object)entityClass.getName());
            }
        }
        catch (IllegalArgumentException e) {
            FMLLog.log.warn("The mod {} tried to register the entity (registry,name,class) ({},{},{}) one or both of which are already registered", (Object)mc.getModId(), (Object)registryName, (Object)entityName, (Object)entityClass.getName(), (Object)e);
            return;
        }
        this.entityRegistrations.put((Object)mc, (Object)er);
    }

    public static void registerEgg(ResourceLocation name, int primary, int secondary) {
        EntityEntry entry = ForgeRegistries.ENTITIES.getValue(name);
        if (entry == null) {
            FMLLog.bigWarning("Attempted to registry a entity egg for entity ({}) that is not in the Entity Registry", name);
            return;
        }
        entry.setEgg(new EntityList.EntityEggInfo(name, primary, secondary));
    }

    public static void addSpawn(Class<? extends EntityLiving> entityClass, int weightedProb, int min, int max, EnumCreatureType typeOfCreature, Biome ... biomes) {
        for (Biome biome : biomes) {
            List<Biome.SpawnListEntry> spawns = biome.getSpawnableList(typeOfCreature);
            boolean found = false;
            for (Biome.SpawnListEntry entry : spawns) {
                if (entry.entityClass != entityClass) continue;
                entry.itemWeight = weightedProb;
                entry.minGroupCount = min;
                entry.maxGroupCount = max;
                found = true;
                break;
            }
            if (found) continue;
            spawns.add(new Biome.SpawnListEntry(entityClass, weightedProb, min, max));
        }
    }

    public static void addSpawn(String entityName, int weightedProb, int min, int max, EnumCreatureType typeOfCreature, Biome ... biomes) {
        Class<?> entityClazz = null;
        if (EntityLiving.class.isAssignableFrom(entityClazz)) {
            EntityRegistry.addSpawn(entityClazz, weightedProb, min, max, typeOfCreature, biomes);
        }
    }

    public static void removeSpawn(Class<? extends EntityLiving> entityClass, EnumCreatureType typeOfCreature, Biome ... biomes) {
        for (Biome biome : biomes) {
            biome.getSpawnableList(typeOfCreature).removeIf(entry -> entry.entityClass == entityClass);
        }
    }

    public static void removeSpawn(String entityName, EnumCreatureType typeOfCreature, Biome ... biomes) {
        Class<?> entityClazz = null;
        if (EntityLiving.class.isAssignableFrom(entityClazz)) {
            EntityRegistry.removeSpawn(entityClazz, typeOfCreature, biomes);
        }
    }

    @Nullable
    public EntityRegistration lookupModSpawn(Class<? extends Entity> clazz, boolean keepLooking) {
        Class<? extends Entity> localClazz = clazz;
        do {
            EntityRegistration er;
            if ((er = (EntityRegistration)this.entityClassRegistrations.get(localClazz)) == null) continue;
            return er;
        } while (keepLooking &= !Object.class.equals(localClazz = localClazz.getSuperclass()));
        return null;
    }

    @Nullable
    public EntityRegistration lookupModSpawn(ModContainer mc, int modEntityId) {
        for (EntityRegistration er : this.entityRegistrations.get((Object)mc)) {
            if (er.getModEntityId() != modEntityId) continue;
            return er;
        }
        return null;
    }

    public boolean tryTrackingEntity(EntityTracker entityTracker, Entity entity) {
        EntityRegistration er = this.lookupModSpawn(entity.getClass(), true);
        if (er != null) {
            entityTracker.track(entity, er.getTrackingRange(), er.getUpdateFrequency(), er.sendsVelocityUpdates());
            return true;
        }
        return false;
    }

    @Nullable
    public static EntityEntry getEntry(Class<? extends Entity> entityClass) {
        return EntityRegistry.instance().entityClassEntries.get(entityClass);
    }

    final void insert(Class<? extends Entity> entity, EntityRegistration registration) {
        this.entityClassRegistrations.put(entity, (Object)registration);
        this.entityRegistrations.put((Object)registration.container, (Object)registration);
    }

    public class EntityRegistration {
        @Deprecated
        private Class<? extends Entity> entityClass;
        private Function<World, ? extends Entity> factory;
        private ModContainer container;
        private ResourceLocation regName;
        private String entityName;
        private int modId;
        private int trackingRange;
        private int updateFrequency;
        private boolean sendsVelocityUpdates;
        private Function<FMLMessage.EntitySpawnMessage, Entity> customSpawnCallback;
        private boolean usesVanillaSpawning;

        @Deprecated
        public EntityRegistration(EntityRegistry this$0, ModContainer mc, ResourceLocation registryName, Class<? extends Entity> entityClass, String entityName, int id, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
            this(this$0, mc, registryName, entityClass, entityName, id, trackingRange, updateFrequency, sendsVelocityUpdates, null);
        }

        public EntityRegistration(final EntityRegistry this$0, ModContainer mc, ResourceLocation registryName, Class<? extends Entity> entityClass, String entityName, int id, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, Function<World, ? extends Entity> factory) {
            this.container = mc;
            this.regName = registryName;
            this.entityClass = entityClass;
            this.entityName = entityName;
            this.modId = id;
            this.trackingRange = trackingRange;
            this.updateFrequency = updateFrequency;
            this.sendsVelocityUpdates = sendsVelocityUpdates;
            this.factory = factory != null ? factory : new EntityEntryBuilder.ConstructorFactory<Entity>(entityClass){

                @Override
                protected String describeEntity() {
                    return String.valueOf(EntityRegistration.this.getRegistryName());
                }
            };
        }

        public ResourceLocation getRegistryName() {
            return this.regName;
        }

        @Deprecated
        public Class<? extends Entity> getEntityClass() {
            return this.entityClass;
        }

        public Entity newInstance(World world) {
            return this.factory.apply(world);
        }

        public ModContainer getContainer() {
            return this.container;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public int getModEntityId() {
            return this.modId;
        }

        public int getTrackingRange() {
            return this.trackingRange;
        }

        public int getUpdateFrequency() {
            return this.updateFrequency;
        }

        public boolean sendsVelocityUpdates() {
            return this.sendsVelocityUpdates;
        }

        public boolean usesVanillaSpawning() {
            return this.usesVanillaSpawning;
        }

        public boolean hasCustomSpawning() {
            return this.customSpawnCallback != null;
        }

        public Entity doCustomSpawning(FMLMessage.EntitySpawnMessage spawnMsg) throws Exception {
            return this.customSpawnCallback.apply(spawnMsg);
        }

        public void setCustomSpawning(Function<FMLMessage.EntitySpawnMessage, Entity> callable, boolean usesVanillaSpawning) {
            this.customSpawnCallback = callable;
            this.usesVanillaSpawning = usesVanillaSpawning;
        }
    }
}

