/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.command.EntitySelector;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.IEntitySelectorFactory;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;

public class GameRegistry {
    private static Set<IWorldGenerator> worldGenerators = Sets.newHashSet();
    private static Map<IWorldGenerator, Integer> worldGeneratorIndex = Maps.newHashMap();
    private static List<IFuelHandler> fuelHandlers = Lists.newArrayList();
    private static List<IWorldGenerator> sortedGeneratorList;
    private static List<IEntitySelectorFactory> entitySelectorFactories;

    public static void registerWorldGenerator(IWorldGenerator generator, int modGenerationWeight) {
        worldGenerators.add(generator);
        worldGeneratorIndex.put(generator, modGenerationWeight);
        if (sortedGeneratorList != null) {
            sortedGeneratorList = null;
        }
    }

    public static void registerEntitySelector(IEntitySelectorFactory factory, String ... arguments) {
        entitySelectorFactories.add(factory);
        for (String s : arguments) {
            EntitySelector.addArgument(s);
        }
    }

    public static List<Predicate<Entity>> createEntitySelectors(Map<String, String> arguments, String mainSelector, ICommandSender sender, Vec3d position) {
        ArrayList selectors = Lists.newArrayList();
        for (IEntitySelectorFactory factory : entitySelectorFactories) {
            try {
                selectors.addAll(factory.createPredicates(arguments, mainSelector, sender, position));
            }
            catch (Exception e) {
                FMLLog.log.error("Exception caught during entity selector creation with {} for argument map {} of {} for {} at {}", (Object)factory, arguments, (Object)mainSelector, (Object)sender, (Object)position, (Object)e);
            }
        }
        return selectors;
    }

    public static void generateWorld(int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (sortedGeneratorList == null) {
            GameRegistry.computeSortedGeneratorList();
        }
        long worldSeed = world.getSeed();
        Random fmlRandom = new Random(worldSeed);
        long xSeed = fmlRandom.nextLong() >> 3;
        long zSeed = fmlRandom.nextLong() >> 3;
        long chunkSeed = xSeed * (long)chunkX + zSeed * (long)chunkZ ^ worldSeed;
        for (IWorldGenerator generator : sortedGeneratorList) {
            fmlRandom.setSeed(chunkSeed);
            generator.generate(fmlRandom, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
        }
    }

    private static void computeSortedGeneratorList() {
        ArrayList list = Lists.newArrayList(worldGenerators);
        list.sort(Comparator.comparingInt(o -> worldGeneratorIndex.get(o)));
        sortedGeneratorList = ImmutableList.copyOf((Collection)list);
    }

    private static <K extends IForgeRegistryEntry<K>> K register(K object) {
        return GameData.register_impl(object);
    }

    public static <K extends IForgeRegistryEntry<K>> IForgeRegistry<K> findRegistry(Class<K> registryType) {
        return RegistryManager.ACTIVE.getRegistry(registryType);
    }

    public static void addShapedRecipe(ResourceLocation name, ResourceLocation group, @Nonnull ItemStack output, Object ... params) {
        CraftingHelper.ShapedPrimer primer = CraftingHelper.parseShaped(params);
        GameRegistry.register((IRecipe)new ShapedRecipes(group == null ? "" : group.toString(), primer.width, primer.height, primer.input, output).setRegistryName(name));
    }

    public static void addShapelessRecipe(ResourceLocation name, ResourceLocation group, @Nonnull ItemStack output, Ingredient ... params) {
        NonNullList<Ingredient> lst = NonNullList.create();
        for (Ingredient i : params) {
            lst.add(i);
        }
        GameRegistry.register((IRecipe)new ShapelessRecipes(group == null ? "" : group.toString(), output, lst).setRegistryName(name));
    }

    public static void addSmelting(Block input, @Nonnull ItemStack output, float xp) {
        FurnaceRecipes.instance().addSmeltingRecipeForBlock(input, output, xp);
    }

    public static void addSmelting(Item input, @Nonnull ItemStack output, float xp) {
        FurnaceRecipes.instance().addSmelting(input, output, xp);
    }

    public static void addSmelting(@Nonnull ItemStack input, @Nonnull ItemStack output, float xp) {
        FurnaceRecipes.instance().addSmeltingRecipe(input, output, xp);
    }

    @Deprecated
    public static void registerTileEntity(Class<? extends TileEntity> tileEntityClass, String key) {
        GameData.checkPrefix(new ResourceLocation(key).toString(), true);
        TileEntity.register(key, tileEntityClass);
    }

    public static void registerTileEntity(Class<? extends TileEntity> tileEntityClass, ResourceLocation key) {
        GameRegistry.registerTileEntity(tileEntityClass, key.toString());
    }

    @Deprecated
    public static void registerFuelHandler(IFuelHandler handler) {
        fuelHandlers.add(handler);
    }

    @Deprecated
    public static int getFuelValue(@Nonnull ItemStack itemStack) {
        return ForgeEventFactory.getItemBurnTime(itemStack);
    }

    @Deprecated
    public static int getFuelValueLegacy(@Nonnull ItemStack itemStack) {
        int fuelValue = 0;
        for (IFuelHandler handler : fuelHandlers) {
            fuelValue = Math.max(fuelValue, handler.getBurnTime(itemStack));
        }
        return fuelValue;
    }

    @Nonnull
    public static ItemStack makeItemStack(String itemName, int meta, int stackSize, String nbtString) {
        if (itemName == null) {
            throw new IllegalArgumentException("The itemName cannot be null");
        }
        Item item = ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
        if (item == null) {
            FMLLog.log.trace("Unable to find item with name {}", (Object)itemName);
            return ItemStack.EMPTY;
        }
        ItemStack is = new ItemStack(item, stackSize, meta);
        if (!Strings.isNullOrEmpty((String)nbtString)) {
            try {
                is.setTagCompound(JsonToNBT.getTagFromJson(nbtString));
            }
            catch (NBTException e) {
                throw new RuntimeException("Encountered an exception parsing ItemStack NBT string " + nbtString, e);
            }
        }
        return is;
    }

    static {
        entitySelectorFactories = Lists.newArrayList();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ItemStackHolder {
        public String value();

        public int meta() default 0;

        public String nbt() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.FIELD})
    public static @interface ObjectHolder {
        public String value();
    }
}

