/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.cleanroommc.hackery.ReflectionHackery;
import java.lang.reflect.Field;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.GameRegistry;
import zone.rong.imaginebreaker.ImagineBreaker;

class ItemStackHolderRef {
    private Field field;
    private String itemName;
    private int meta;
    private String serializednbt;

    ItemStackHolderRef(Field field, String itemName, int meta, String serializednbt) {
        this.field = field;
        this.itemName = itemName;
        this.meta = meta;
        this.serializednbt = serializednbt;
        ItemStackHolderRef.makeWritable(field);
    }

    private static void makeWritable(Field f) {
        try {
            f.setAccessible(true);
            ReflectionHackery.stripFieldOfFinalModifier(f);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public void apply() {
        ItemStack is;
        try {
            is = GameRegistry.makeItemStack(this.itemName, this.meta, 1, this.serializednbt);
        }
        catch (RuntimeException e) {
            FMLLog.log.error("Caught exception processing itemstack {},{},{} in annotation at {}.{}", (Object)this.itemName, (Object)this.meta, (Object)this.serializednbt, (Object)this.field.getClass().getName(), (Object)this.field.getName());
            throw e;
        }
        try {
            ImagineBreaker.lookup().ensureInitialized(this.field.getDeclaringClass());
            ReflectionHackery.unsafe.putObject(ReflectionHackery.unsafe.staticFieldBase(this.field), ReflectionHackery.unsafe.staticFieldOffset(this.field), is);
        }
        catch (Exception e) {
            FMLLog.log.warn("Unable to set {} with value {},{},{}", (Object)this.field, (Object)this.itemName, (Object)this.meta, (Object)this.serializednbt);
        }
    }
}

