/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.relauncher.libraries;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraftforge.fml.common.FMLLog;

public class SnapshotJson
implements Comparable<SnapshotJson> {
    public static final DateFormat TIMESTAMP = new SimpleDateFormat("yyyyMMdd.hhmmss");
    public static final String META_JSON_FILE = "maven-metadata.json";
    private static final Gson GSON = new GsonBuilder().create();
    private static final Comparator<Entry> SORTER = (o1, o2) -> o2.timestamp.compareTo(o1.timestamp);
    private String latest;
    private List<Entry> versions;

    public static SnapshotJson create(File target) {
        if (!target.exists()) {
            return new SnapshotJson();
        }
        try {
            String json = Files.asCharSource((File)target, (Charset)StandardCharsets.UTF_8).read();
            SnapshotJson obj = (SnapshotJson)GSON.fromJson(json, SnapshotJson.class);
            obj.updateLatest();
            return obj;
        }
        catch (JsonSyntaxException jse) {
            FMLLog.log.info(FMLLog.log.getMessageFactory().newMessage("Failed to parse snapshot json file {}.", new Object[]{target}), (Throwable)jse);
        }
        catch (IOException ioe) {
            FMLLog.log.info(FMLLog.log.getMessageFactory().newMessage("Failed to read snapshot json file {}.", new Object[]{target}), (Throwable)ioe);
        }
        return new SnapshotJson();
    }

    public String getLatest() {
        return this.latest;
    }

    public void add(Entry data) {
        if (this.versions == null) {
            this.versions = new ArrayList<Entry>();
        }
        this.versions.add(data);
        this.updateLatest();
    }

    public void merge(SnapshotJson o) {
        if (o.versions != null) {
            if (this.versions == null) {
                this.versions = new ArrayList<Entry>(o.versions);
            } else {
                o.versions.stream().filter(e -> this.versions.stream().anyMatch(e2 -> e.timestamp.equals(e2.timestamp))).forEach(e -> this.versions.add((Entry)e));
            }
            this.updateLatest();
        }
    }

    public boolean remove(String timestamp) {
        if (this.versions == null) {
            return false;
        }
        if (this.versions.removeIf(e -> e.timestamp.equals(timestamp))) {
            this.updateLatest();
        }
        return false;
    }

    public String updateLatest() {
        if (this.versions == null) {
            this.latest = null;
            return null;
        }
        Collections.sort(this.versions, SORTER);
        this.latest = this.versions.isEmpty() ? null : this.versions.get((int)0).timestamp;
        return this.latest;
    }

    public void write(File target) throws IOException {
        Files.write((CharSequence)GSON.toJson((Object)this), (File)target, (Charset)StandardCharsets.UTF_8);
    }

    @Override
    public int compareTo(SnapshotJson o) {
        return o == null ? 1 : (o.latest == null ? (this.latest == null ? 0 : 1) : (this.latest == null ? -1 : o.latest.compareTo(this.latest)));
    }

    public static class Entry {
        private String timestamp;
        private String md5;

        public Entry(String timestamp, String md5) {
            this.timestamp = timestamp;
            this.md5 = md5;
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public String getMd5() {
            return this.md5;
        }
    }
}

