/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.oredict;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ShapedOreRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IShapedRecipe {
    @Deprecated
    public static final int MAX_CRAFT_GRID_WIDTH = 3;
    @Deprecated
    public static final int MAX_CRAFT_GRID_HEIGHT = 3;
    @Nonnull
    protected ItemStack output = ItemStack.EMPTY;
    protected NonNullList<Ingredient> input = null;
    protected int width = 0;
    protected int height = 0;
    protected boolean mirrored = true;
    protected ResourceLocation group;

    public ShapedOreRecipe(ResourceLocation group, Block result, Object ... recipe) {
        this(group, new ItemStack(result), recipe);
    }

    public ShapedOreRecipe(ResourceLocation group, Item result, Object ... recipe) {
        this(group, new ItemStack(result), recipe);
    }

    public ShapedOreRecipe(ResourceLocation group, @Nonnull ItemStack result, Object ... recipe) {
        this(group, result, CraftingHelper.parseShaped(recipe));
    }

    public ShapedOreRecipe(ResourceLocation group, @Nonnull ItemStack result, CraftingHelper.ShapedPrimer primer) {
        this.group = group;
        this.output = result.copy();
        this.width = primer.width;
        this.height = primer.height;
        this.input = primer.input;
        this.mirrored = primer.mirrored;
    }

    @Override
    @Nonnull
    public ItemStack getCraftingResult(@Nonnull InventoryCrafting var1) {
        return this.output.copy();
    }

    @Override
    @Nonnull
    public ItemStack getRecipeOutput() {
        return this.output;
    }

    @Override
    public boolean matches(@Nonnull InventoryCrafting inv, @Nonnull World world) {
        for (int x = 0; x <= inv.getWidth() - this.width; ++x) {
            for (int y = 0; y <= inv.getHeight() - this.height; ++y) {
                if (this.checkMatch(inv, x, y, false)) {
                    return true;
                }
                if (!this.mirrored || !this.checkMatch(inv, x, y, true)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < inv.getWidth(); ++x) {
            for (int y = 0; y < inv.getHeight(); ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Ingredient target = Ingredient.EMPTY;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? this.input.get(this.width - subX - 1 + subY * this.width) : this.input.get(subX + subY * this.width);
                }
                if (target.apply(inv.getStackInRowAndColumn(x, y))) continue;
                return false;
            }
        }
        return true;
    }

    public ShapedOreRecipe setMirrored(boolean mirror) {
        this.mirrored = mirror;
        return this;
    }

    @Override
    @Nonnull
    public NonNullList<Ingredient> getIngredients() {
        return this.input;
    }

    @Deprecated
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getRecipeWidth() {
        return this.getWidth();
    }

    @Deprecated
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getRecipeHeight() {
        return this.getHeight();
    }

    @Override
    @Nonnull
    public String getGroup() {
        return this.group == null ? "" : this.group.toString();
    }

    @Override
    public boolean canFit(int p_194133_1_, int p_194133_2_) {
        return p_194133_1_ >= this.width && p_194133_2_ >= this.height;
    }

    public static ShapedOreRecipe factory(JsonContext context, JsonObject json) {
        String group = JsonUtils.getString(json, "group", "");
        HashMap ingMap = Maps.newHashMap();
        for (Map.Entry entry : JsonUtils.getJsonObject(json, "key").entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            ingMap.put(Character.valueOf(((String)entry.getKey()).toCharArray()[0]), CraftingHelper.getIngredient((JsonElement)entry.getValue(), context));
        }
        ingMap.put(Character.valueOf(' '), Ingredient.EMPTY);
        JsonArray patternJ = JsonUtils.getJsonArray(json, "pattern");
        if (patternJ.size() == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        String[] pattern = new String[patternJ.size()];
        for (int x = 0; x < pattern.length; ++x) {
            String line = JsonUtils.getString(patternJ.get(x), "pattern[" + x + "]");
            if (x > 0 && pattern[0].length() != line.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must  be the same width");
            }
            pattern[x] = line;
        }
        CraftingHelper.ShapedPrimer primer = new CraftingHelper.ShapedPrimer();
        primer.width = pattern[0].length();
        primer.height = pattern.length;
        primer.mirrored = JsonUtils.getBoolean(json, "mirrored", true);
        primer.input = NonNullList.withSize(primer.width * primer.height, Ingredient.EMPTY);
        HashSet keys = Sets.newHashSet(ingMap.keySet());
        keys.remove(Character.valueOf(' '));
        int x = 0;
        for (String line : pattern) {
            for (char chr : line.toCharArray()) {
                Ingredient ing = (Ingredient)ingMap.get(Character.valueOf(chr));
                if (ing == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + chr + "' but it's not defined in the key");
                }
                primer.input.set(x++, ing);
                keys.remove(Character.valueOf(chr));
            }
        }
        if (!keys.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + String.valueOf(keys));
        }
        ItemStack result = CraftingHelper.getItemStack(JsonUtils.getJsonObject(json, "result"), context);
        return new ShapedOreRecipe(group.isEmpty() ? null : new ResourceLocation(group), result, primer);
    }
}

