/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.oredict;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ShapelessOreRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    @Nonnull
    protected ItemStack output = ItemStack.EMPTY;
    protected NonNullList<Ingredient> input = NonNullList.create();
    protected ResourceLocation group;
    protected boolean isSimple = true;

    public ShapelessOreRecipe(ResourceLocation group, Block result, Object ... recipe) {
        this(group, new ItemStack(result), recipe);
    }

    public ShapelessOreRecipe(ResourceLocation group, Item result, Object ... recipe) {
        this(group, new ItemStack(result), recipe);
    }

    public ShapelessOreRecipe(ResourceLocation group, NonNullList<Ingredient> input, @Nonnull ItemStack result) {
        this.group = group;
        this.output = result.copy();
        this.input = input;
        for (Ingredient i : input) {
            this.isSimple &= i.isSimple();
        }
    }

    public ShapelessOreRecipe(ResourceLocation group, @Nonnull ItemStack result, Object ... recipe) {
        this.group = group;
        this.output = result.copy();
        for (Object in : recipe) {
            Ingredient ing = CraftingHelper.getIngredient(in);
            if (ing != null) {
                this.input.add(ing);
                this.isSimple &= ing.isSimple();
                continue;
            }
            Object ret = "Invalid shapeless ore recipe: ";
            for (Object tmp : recipe) {
                ret = (String)ret + String.valueOf(tmp) + ", ";
            }
            ret = (String)ret + String.valueOf(this.output);
            throw new RuntimeException((String)ret);
        }
    }

    @Override
    @Nonnull
    public ItemStack getRecipeOutput() {
        return this.output;
    }

    @Override
    @Nonnull
    public ItemStack getCraftingResult(@Nonnull InventoryCrafting var1) {
        return this.output.copy();
    }

    @Override
    public boolean matches(@Nonnull InventoryCrafting inv, @Nonnull World world) {
        int ingredientCount = 0;
        RecipeItemHelper recipeItemHelper = new RecipeItemHelper();
        ArrayList items = Lists.newArrayList();
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            ItemStack itemstack = inv.getStackInSlot(i);
            if (itemstack.isEmpty()) continue;
            ++ingredientCount;
            if (this.isSimple) {
                recipeItemHelper.accountStack(itemstack, 1);
                continue;
            }
            items.add(itemstack);
        }
        if (ingredientCount != this.input.size()) {
            return false;
        }
        if (this.isSimple) {
            return recipeItemHelper.canCraft(this, null);
        }
        return RecipeMatcher.findMatches(items, this.input) != null;
    }

    @Override
    @Nonnull
    public NonNullList<Ingredient> getIngredients() {
        return this.input;
    }

    @Override
    @Nonnull
    public String getGroup() {
        return this.group == null ? "" : this.group.toString();
    }

    @Override
    public boolean canFit(int p_194133_1_, int p_194133_2_) {
        return p_194133_1_ * p_194133_2_ >= this.input.size();
    }

    public static ShapelessOreRecipe factory(JsonContext context, JsonObject json) {
        String group = JsonUtils.getString(json, "group", "");
        NonNullList<Ingredient> ings = NonNullList.create();
        for (JsonElement ele : JsonUtils.getJsonArray(json, "ingredients")) {
            ings.add(CraftingHelper.getIngredient(ele, context));
        }
        if (ings.isEmpty()) {
            throw new JsonParseException("No ingredients for shapeless recipe");
        }
        ItemStack itemstack = CraftingHelper.getItemStack(JsonUtils.getJsonObject(json, "result"), context);
        return new ShapelessOreRecipe(group.isEmpty() ? null : new ResourceLocation(group), ings, itemstack);
    }
}

