/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockObserver;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionType;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.util.registry.RegistryNamespacedDefaultedByKey;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.EnhancedRuntimeException;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLContainer;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.InjectedModContainer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.StartupQuery;
import net.minecraftforge.fml.common.ZipperUtil;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.registries.DataSerializerEntry;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryInternal;
import net.minecraftforge.registries.ILockableRegistry;
import net.minecraftforge.registries.NamespacedDefaultedWrapper;
import net.minecraftforge.registries.NamespacedWrapper;
import net.minecraftforge.registries.ObjectHolderRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryManager;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.Level;

public class GameData {
    public static final ResourceLocation BLOCKS = new ResourceLocation("minecraft:blocks");
    public static final ResourceLocation ITEMS = new ResourceLocation("minecraft:items");
    public static final ResourceLocation POTIONS = new ResourceLocation("minecraft:potions");
    public static final ResourceLocation BIOMES = new ResourceLocation("minecraft:biomes");
    public static final ResourceLocation SOUNDEVENTS = new ResourceLocation("minecraft:soundevents");
    public static final ResourceLocation POTIONTYPES = new ResourceLocation("minecraft:potiontypes");
    public static final ResourceLocation ENCHANTMENTS = new ResourceLocation("minecraft:enchantments");
    public static final ResourceLocation ENTITIES = new ResourceLocation("minecraft:entities");
    public static final ResourceLocation RECIPES = new ResourceLocation("minecraft:recipes");
    public static final ResourceLocation PROFESSIONS = new ResourceLocation("minecraft:villagerprofessions");
    public static final ResourceLocation SERIALIZERS = new ResourceLocation("minecraft:dataserializers");
    private static final int MAX_BLOCK_ID = 4095;
    private static final int MIN_ITEM_ID = 4096;
    private static final int MAX_ITEM_ID = 31999;
    private static final int MAX_POTION_ID = 255;
    private static final int MAX_BIOME_ID = 255;
    private static final int MAX_SOUND_ID = 0x3FFFFFF;
    private static final int MAX_POTIONTYPE_ID = 0x3FFFFFF;
    private static final int MAX_ENCHANTMENT_ID = 32766;
    private static final int MAX_ENTITY_ID = 0x3FFFFFF;
    private static final int MAX_RECIPE_ID = 0x3FFFFFF;
    private static final int MAX_PROFESSION_ID = 1024;
    private static final int MIN_SERIALIZER_ID = 256;
    private static final int MAX_SERIALIZER_ID = 0x3FFFFFF;
    private static final ResourceLocation BLOCK_TO_ITEM = new ResourceLocation("minecraft:blocktoitemmap");
    private static final ResourceLocation BLOCKSTATE_TO_ID = new ResourceLocation("minecraft:blockstatetoid");
    private static final ResourceLocation ENTITY_CLASS_TO_ENTRY = new ResourceLocation("forge:entity_class_to_entry");
    private static final ResourceLocation SERIALIZER_TO_ENTRY = new ResourceLocation("forge:serializer_to_entry");
    private static boolean hasInit = false;
    private static final boolean DISABLE_VANILLA_REGISTRIES = Boolean.parseBoolean(System.getProperty("forge.disableVanillaGameData", "false"));
    private static final BiConsumer<ResourceLocation, ForgeRegistry<?>> LOCK_VANILLA = (name, reg) -> reg.slaves.values().stream().filter(o -> o instanceof ILockableRegistry).forEach(o -> ((ILockableRegistry)o).lock());
    private static ForgeRegistry<EntityEntry> entityRegistry;
    private static Field regName;

    public static void init() {
        if (DISABLE_VANILLA_REGISTRIES) {
            FMLLog.bigWarning("DISABLING VANILLA REGISTRY CREATION AS PER SYSTEM VARIABLE SETTING! forge.disableVanillaGameData", new Object[0]);
            return;
        }
        if (hasInit) {
            return;
        }
        hasInit = true;
        GameData.makeRegistry(BLOCKS, Block.class, 4095, new ResourceLocation("air")).addCallback(BlockCallbacks.INSTANCE).create();
        GameData.makeRegistry(ITEMS, Item.class, 4096, 31999).addCallback(ItemCallbacks.INSTANCE).create();
        GameData.makeRegistry(POTIONS, Potion.class, 255).create();
        GameData.makeRegistry(BIOMES, Biome.class, 255).create();
        GameData.makeRegistry(SOUNDEVENTS, SoundEvent.class, 0x3FFFFFF).create();
        GameData.makeRegistry(POTIONTYPES, PotionType.class, 0x3FFFFFF, new ResourceLocation("empty")).create();
        GameData.makeRegistry(ENCHANTMENTS, Enchantment.class, 32766).create();
        GameData.makeRegistry(RECIPES, IRecipe.class, 0x3FFFFFF).disableSaving().allowModification().addCallback(RecipeCallbacks.INSTANCE).create();
        GameData.makeRegistry(PROFESSIONS, VillagerRegistry.VillagerProfession.class, 1024).create();
        GameData.makeRegistry(SERIALIZERS, DataSerializerEntry.class, 256, 0x3FFFFFF).disableSaving().disableOverrides().addCallback(SerializerCallbacks.INSTANCE).create();
        entityRegistry = (ForgeRegistry)GameData.makeRegistry(ENTITIES, EntityEntry.class, 0x3FFFFFF).addCallback(EntityCallbacks.INSTANCE).create();
    }

    private static <T extends IForgeRegistryEntry<T>> RegistryBuilder<T> makeRegistry(ResourceLocation name, Class<T> type, int min, int max) {
        return new RegistryBuilder().setName(name).setType(type).setIDRange(min, max).addCallback(new NamespacedWrapper.Factory());
    }

    private static <T extends IForgeRegistryEntry<T>> RegistryBuilder<T> makeRegistry(ResourceLocation name, Class<T> type, int max) {
        return new RegistryBuilder().setName(name).setType(type).setMaxID(max).addCallback(new NamespacedWrapper.Factory());
    }

    private static <T extends IForgeRegistryEntry<T>> RegistryBuilder<T> makeRegistry(ResourceLocation name, Class<T> type, int max, ResourceLocation _default) {
        return new RegistryBuilder().setName(name).setType(type).setMaxID(max).addCallback(new NamespacedDefaultedWrapper.Factory()).setDefaultKey(_default);
    }

    public static <V extends IForgeRegistryEntry<V>> RegistryNamespacedDefaultedByKey<ResourceLocation, V> getWrapperDefaulted(Class<V> cls) {
        IForgeRegistry<V> reg = GameRegistry.findRegistry(cls);
        Validate.notNull(reg, (String)("Attempted to get vanilla wrapper for unknown registry: " + cls.toString()), (Object[])new Object[0]);
        RegistryNamespacedDefaultedByKey ret = reg.getSlaveMap(NamespacedDefaultedWrapper.Factory.ID, NamespacedDefaultedWrapper.class);
        Validate.notNull((Object)ret, (String)("Attempted to get vanilla wrapper for registry created incorrectly: " + cls.toString()), (Object[])new Object[0]);
        return ret;
    }

    public static <V extends IForgeRegistryEntry<V>> RegistryNamespaced<ResourceLocation, V> getWrapper(Class<V> cls) {
        IForgeRegistry<V> reg = GameRegistry.findRegistry(cls);
        Validate.notNull(reg, (String)("Attempted to get vanilla wrapper for unknown registry: " + cls.toString()), (Object[])new Object[0]);
        RegistryNamespaced ret = reg.getSlaveMap(NamespacedWrapper.Factory.ID, NamespacedWrapper.class);
        Validate.notNull((Object)ret, (String)("Attempted to get vanilla wrapper for registry created incorrectly: " + cls.toString()), (Object[])new Object[0]);
        return ret;
    }

    public static BiMap<Block, Item> getBlockItemMap() {
        return GameRegistry.findRegistry(Item.class).getSlaveMap(BLOCK_TO_ITEM, BiMap.class);
    }

    public static ObjectIntIdentityMap<IBlockState> getBlockStateIDMap() {
        return GameRegistry.findRegistry(Block.class).getSlaveMap(BLOCKSTATE_TO_ID, ObjectIntIdentityMap.class);
    }

    public static Map<Class<? extends Entity>, EntityEntry> getEntityClassMap() {
        return GameRegistry.findRegistry(EntityEntry.class).getSlaveMap(ENTITY_CLASS_TO_ENTRY, Map.class);
    }

    public static Map<DataSerializer<?>, DataSerializerEntry> getSerializerMap() {
        return GameRegistry.findRegistry(DataSerializerEntry.class).getSlaveMap(SERIALIZER_TO_ENTRY, Map.class);
    }

    public static <K extends IForgeRegistryEntry<K>> K register_impl(K value) {
        Validate.notNull(value, (String)"Attempted to register a null object", (Object[])new Object[0]);
        Validate.notNull((Object)value.getRegistryName(), (String)String.format("Attempt to register object without having set a registry name %s (type %s)", value, value.getClass().getName()), (Object[])new Object[0]);
        IForgeRegistry<K> registry = GameRegistry.findRegistry(value.getRegistryType());
        Validate.notNull(registry, (String)("Attempted to registry object without creating registry first: " + value.getRegistryType().getName()), (Object[])new Object[0]);
        registry.register(value);
        return value;
    }

    public static void vanillaSnapshot() {
        FMLLog.log.debug("Creating vanilla freeze snapshot");
        for (Map.Entry r : RegistryManager.ACTIVE.registries.entrySet()) {
            Class clazz = RegistryManager.ACTIVE.getSuperType((ResourceLocation)r.getKey());
            GameData.loadRegistry((ResourceLocation)r.getKey(), RegistryManager.ACTIVE, RegistryManager.VANILLA, clazz, true);
        }
        RegistryManager.VANILLA.registries.forEach((name, reg) -> {
            reg.validateContent((ResourceLocation)name);
            reg.freeze();
        });
        RegistryManager.VANILLA.registries.forEach(LOCK_VANILLA);
        RegistryManager.ACTIVE.registries.forEach(LOCK_VANILLA);
        FMLLog.log.debug("Vanilla freeze snapshot created");
    }

    public static void freezeData() {
        FMLLog.log.debug("Freezing registries");
        for (Map.Entry r : RegistryManager.ACTIVE.registries.entrySet()) {
            Class clazz = RegistryManager.ACTIVE.getSuperType((ResourceLocation)r.getKey());
            GameData.loadRegistry((ResourceLocation)r.getKey(), RegistryManager.ACTIVE, RegistryManager.FROZEN, clazz, true);
        }
        RegistryManager.FROZEN.registries.forEach((name, reg) -> {
            reg.validateContent((ResourceLocation)name);
            reg.freeze();
        });
        RegistryManager.ACTIVE.registries.forEach((name, reg) -> reg.freeze());
        Loader.instance().fireRemapEvent((Map<ResourceLocation, Map<ResourceLocation, Integer[]>>)ImmutableMap.of(), true);
        FMLLog.log.debug("All registries frozen");
    }

    public static void revertToFrozen() {
        if (RegistryManager.FROZEN.registries.isEmpty()) {
            FMLLog.log.warn("Can't revert to frozen GameData state without freezing first.");
            return;
        }
        RegistryManager.ACTIVE.registries.forEach((name, reg) -> reg.resetDelegates());
        FMLLog.log.debug("Reverting to frozen data state.");
        for (Map.Entry r : RegistryManager.ACTIVE.registries.entrySet()) {
            Class clazz = RegistryManager.ACTIVE.getSuperType((ResourceLocation)r.getKey());
            GameData.loadRegistry((ResourceLocation)r.getKey(), RegistryManager.FROZEN, RegistryManager.ACTIVE, clazz, true);
        }
        Loader.instance().fireRemapEvent((Map<ResourceLocation, Map<ResourceLocation, Integer[]>>)ImmutableMap.of(), true);
        ObjectHolderRegistry.INSTANCE.applyObjectHolders();
        FMLLog.log.debug("Frozen state restored.");
    }

    public static void revert(RegistryManager state, ResourceLocation registry, boolean lock) {
        FMLLog.log.debug("Reverting {} to {}", (Object)registry, (Object)state.getName());
        Class clazz = RegistryManager.ACTIVE.getSuperType(registry);
        GameData.loadRegistry(registry, state, RegistryManager.ACTIVE, clazz, lock);
        FMLLog.log.debug("Reverting complete");
    }

    public static ForgeRegistry<EntityEntry> getEntityRegistry() {
        return entityRegistry;
    }

    public static void registerEntity(int id, ResourceLocation key, Class<? extends Entity> clazz, String oldName) {
        RegistryNamespaced<ResourceLocation, EntityEntry> reg = GameData.getWrapper(EntityEntry.class);
        reg.register(id, key, new EntityEntry(clazz, oldName));
    }

    private static <T extends IForgeRegistryEntry<T>> void loadRegistry(final ResourceLocation registryName, final RegistryManager from, final RegistryManager to, Class<T> regType, boolean freeze) {
        ForgeRegistry fromRegistry = from.getRegistry(registryName);
        if (fromRegistry == null) {
            ForgeRegistry toRegistry = to.getRegistry(registryName);
            if (toRegistry == null) {
                throw new EnhancedRuntimeException("Could not find registry to load: " + String.valueOf(registryName)){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected void printStackTrace(EnhancedRuntimeException.WrappedPrintStream stream) {
                        stream.println("Looking For: " + String.valueOf(registryName));
                        stream.println("Found From:");
                        for (ResourceLocation name : from.registries.keySet()) {
                            stream.println("  " + String.valueOf(name));
                        }
                        stream.println("Found To:");
                        for (ResourceLocation name : to.registries.keySet()) {
                            stream.println("  " + String.valueOf(name));
                        }
                    }
                };
            }
        } else {
            ForgeRegistry toRegistry = to.getRegistry(registryName, from);
            toRegistry.sync(registryName, fromRegistry);
            if (freeze) {
                toRegistry.isFrozen = true;
            }
        }
    }

    public static Multimap<ResourceLocation, ResourceLocation> injectSnapshot(Map<ResourceLocation, ForgeRegistry.Snapshot> snapshot, boolean injectFrozenData, boolean isLocalWorld) {
        List missingRegs;
        FMLLog.log.info("Injecting existing registry data into this {} instance", (Object)(FMLCommonHandler.instance().getEffectiveSide().isServer() ? "server" : "client"));
        RegistryManager.ACTIVE.registries.forEach((name, reg) -> reg.validateContent((ResourceLocation)name));
        RegistryManager.ACTIVE.registries.forEach((name, reg) -> reg.dump((ResourceLocation)name));
        RegistryManager.ACTIVE.registries.forEach((name, reg) -> reg.resetDelegates());
        if (isLocalWorld && (missingRegs = snapshot.keySet().stream().filter(name -> !RegistryManager.ACTIVE.registries.containsKey(name)).collect(Collectors.toList())).size() > 0) {
            String text = "Forge Mod Loader detected missing/unknown registrie(s).\n\nThere are " + missingRegs.size() + " missing registries in this save.\nIf you continue the missing registries will get removed.\nThis may cause issues, it is advised that you create a world backup before continuing.\n\nMissing Registries:\n";
            for (ResourceLocation s : missingRegs) {
                text = text + s.toString() + "\n";
            }
            if (!StartupQuery.confirm(text)) {
                StartupQuery.abort();
            }
        }
        RegistryManager STAGING = new RegistryManager("STAGING");
        HashMap remaps = Maps.newHashMap();
        LinkedHashMap missing = Maps.newLinkedHashMap();
        snapshot.forEach((key, value) -> {
            Class clazz = RegistryManager.ACTIVE.getSuperType((ResourceLocation)key);
            remaps.put(key, Maps.newLinkedHashMap());
            missing.put(key, Maps.newHashMap());
            GameData.loadPersistentDataToStagingRegistry(RegistryManager.ACTIVE, STAGING, (Map)remaps.get(key), (Map)missing.get(key), key, value, clazz);
        });
        snapshot.forEach((key, value) -> value.dummied.forEach(dummy -> {
            Map m = (Map)missing.get(key);
            ForgeRegistry reg = STAGING.getRegistry((ResourceLocation)key);
            if (m.containsKey(dummy)) {
                if (reg.markDummy((ResourceLocation)dummy, (Integer)m.get(dummy))) {
                    m.remove(dummy);
                }
            } else if (isLocalWorld) {
                if (ForgeRegistry.DEBUG) {
                    FMLLog.log.debug("Registry {}: Resuscitating dummy entry {}", key, dummy);
                }
            } else {
                int id = reg.getID((ResourceLocation)dummy);
                FMLLog.log.warn("Registry {}: The ID {} @ {} is currently locally mapped - it will be replaced with a dummy for this session", dummy, key, (Object)id);
                reg.markDummy((ResourceLocation)dummy, id);
            }
        }));
        int count = missing.values().stream().mapToInt(Map::size).sum();
        if (count > 0) {
            FMLLog.log.debug("There are {} mappings missing - attempting a mod remap", (Object)count);
            ArrayListMultimap defaulted = ArrayListMultimap.create();
            ArrayListMultimap failed = ArrayListMultimap.create();
            missing.entrySet().stream().filter(e -> ((Map)e.getValue()).size() > 0).forEach(arg_0 -> GameData.lambda$injectSnapshot$20(STAGING, (Multimap)failed, remaps, (Multimap)defaulted, isLocalWorld, arg_0));
            if (!defaulted.isEmpty() && !isLocalWorld) {
                return defaulted;
            }
            if (!defaulted.isEmpty()) {
                StringBuilder buf = new StringBuilder();
                buf.append("Forge Mod Loader detected missing registry entries.\n\n").append("There are ").append(defaulted.size()).append(" missing entries in this save.\n").append("If you continue the missing entries will get removed.\n").append("A world backup will be automatically created in your saves directory.\n\n");
                defaulted.asMap().forEach((name, entries) -> {
                    buf.append("Missing ").append(name).append(":\n");
                    entries.forEach(rl -> buf.append("    ").append(rl).append("\n"));
                });
                boolean confirmed = StartupQuery.confirm(buf.toString());
                if (!confirmed) {
                    StartupQuery.abort();
                }
                try {
                    String skip = System.getProperty("fml.doNotBackup");
                    if (skip == null || !"true".equals(skip)) {
                        ZipperUtil.backupWorld();
                    } else {
                        for (int x = 0; x < 10; ++x) {
                            FMLLog.log.error("!!!!!!!!!! UPDATING WORLD WITHOUT DOING BACKUP !!!!!!!!!!!!!!!!");
                        }
                    }
                }
                catch (IOException e2) {
                    StartupQuery.notify("The world backup couldn't be created.\n\n" + String.valueOf(e2));
                    StartupQuery.abort();
                }
            }
            if (!defaulted.isEmpty() && isLocalWorld) {
                FMLLog.log.error("There are unidentified mappings in this world - we are going to attempt to process anyway");
            }
        }
        if (injectFrozenData) {
            missing.forEach((name, m) -> {
                ForgeRegistry reg = STAGING.getRegistry((ResourceLocation)name);
                m.forEach((rl, id) -> reg.markDummy((ResourceLocation)rl, (int)id));
            });
            RegistryManager.ACTIVE.registries.forEach((name, reg) -> {
                Class clazz = RegistryManager.ACTIVE.getSuperType((ResourceLocation)name);
                GameData.loadFrozenDataToStagingRegistry(STAGING, name, (Map)remaps.get(name), clazz);
            });
        }
        STAGING.registries.forEach((name, reg) -> reg.validateContent((ResourceLocation)name));
        for (Map.Entry r : RegistryManager.ACTIVE.registries.entrySet()) {
            Class registrySuperType = RegistryManager.ACTIVE.getSuperType((ResourceLocation)r.getKey());
            GameData.loadRegistry((ResourceLocation)r.getKey(), STAGING, RegistryManager.ACTIVE, registrySuperType, true);
        }
        RegistryManager.ACTIVE.registries.forEach((name, reg) -> reg.dump((ResourceLocation)name));
        Loader.instance().fireRemapEvent(remaps, false);
        ObjectHolderRegistry.INSTANCE.applyObjectHolders();
        return ArrayListMultimap.create();
    }

    private static <T extends IForgeRegistryEntry<T>> void loadPersistentDataToStagingRegistry(RegistryManager pool, RegistryManager to, Map<ResourceLocation, Integer[]> remaps, Map<ResourceLocation, Integer> missing, ResourceLocation name, ForgeRegistry.Snapshot snap, Class<T> regType) {
        ForgeRegistry active = pool.getRegistry(name);
        if (active == null) {
            return;
        }
        ForgeRegistry _new = to.getRegistry(name, RegistryManager.ACTIVE);
        snap.aliases.forEach(_new::addAlias);
        snap.blocked.forEach(_new::block);
        snap.dummied.forEach(_new::addDummy);
        _new.loadIds(snap.ids, snap.overrides, missing, remaps, active, name);
    }

    private static <T extends IForgeRegistryEntry<T>> void processMissing(Class<T> clazz, ResourceLocation name, RegistryManager STAGING, RegistryEvent.MissingMappings<?> e, Map<ResourceLocation, Integer> missing, Map<ResourceLocation, Integer[]> remaps, Collection<ResourceLocation> defaulted, Collection<ResourceLocation> failed, boolean injectNetworkDummies) {
        ImmutableList<RegistryEvent.MissingMappings.Mapping<?>> mappings = e.getAllMappings();
        ForgeRegistry active = RegistryManager.ACTIVE.getRegistry(name);
        ForgeRegistry staging = STAGING.getRegistry(name);
        staging.processMissingEvent(name, active, mappings, missing, remaps, defaulted, failed, injectNetworkDummies);
    }

    private static <T extends IForgeRegistryEntry<T>> void loadFrozenDataToStagingRegistry(RegistryManager STAGING, ResourceLocation name, Map<ResourceLocation, Integer[]> remaps, Class<T> clazz) {
        ForgeRegistry frozen = RegistryManager.FROZEN.getRegistry(name);
        ForgeRegistry newRegistry = STAGING.getRegistry(name, RegistryManager.FROZEN);
        HashMap _new = Maps.newHashMap();
        frozen.getKeys().stream().filter(key -> !newRegistry.containsKey((ResourceLocation)key)).forEach(key -> _new.put(key, frozen.getID((ResourceLocation)key)));
        newRegistry.loadIds(_new, frozen.getOverrideOwners(), Maps.newLinkedHashMap(), remaps, frozen, name);
    }

    public static void fireCreateRegistryEvents() {
        MinecraftForge.EVENT_BUS.post(new RegistryEvent.NewRegistry());
    }

    public static void fireRegistryEvents() {
        GameData.fireRegistryEvents(rl -> true);
    }

    public static void fireRegistryEvents(Predicate<ResourceLocation> filter) {
        ArrayList keys = Lists.newArrayList((Iterable)RegistryManager.ACTIVE.registries.keySet());
        Collections.sort(keys, (o1, o2) -> o1.toString().compareToIgnoreCase(o2.toString()));
        if (filter.test(BLOCKS)) {
            MinecraftForge.EVENT_BUS.post(RegistryManager.ACTIVE.getRegistry(BLOCKS).getRegisterEvent(BLOCKS));
            ObjectHolderRegistry.INSTANCE.applyObjectHolders();
        }
        if (filter.test(ITEMS)) {
            MinecraftForge.EVENT_BUS.post(RegistryManager.ACTIVE.getRegistry(ITEMS).getRegisterEvent(ITEMS));
            ObjectHolderRegistry.INSTANCE.applyObjectHolders();
        }
        for (ResourceLocation rl : keys) {
            if (!filter.test(rl) || rl == BLOCKS || rl == ITEMS) continue;
            MinecraftForge.EVENT_BUS.post(RegistryManager.ACTIVE.getRegistry(rl).getRegisterEvent(rl));
        }
        ObjectHolderRegistry.INSTANCE.applyObjectHolders();
    }

    @Deprecated
    public static ResourceLocation checkPrefix(String name) {
        return GameData.checkPrefix(name, true);
    }

    public static ResourceLocation checkPrefix(String name, boolean warnOverrides) {
        String prefix;
        int index = name.lastIndexOf(58);
        String oldPrefix = index == -1 ? "" : name.substring(0, index).toLowerCase(Locale.ROOT);
        name = index == -1 ? name : name.substring(index + 1);
        ModContainer mc = Loader.instance().activeModContainer();
        String string = prefix = mc == null || mc instanceof InjectedModContainer && ((InjectedModContainer)mc).wrappedContainer instanceof FMLContainer ? "minecraft" : mc.getModId().toLowerCase(Locale.ROOT);
        if (warnOverrides && !oldPrefix.equals(prefix) && oldPrefix.length() > 0) {
            FMLLog.log.warn("Potentially Dangerous alternative prefix `{}` for name `{}`, expected `{}`. This could be a intended override, but in most cases indicates a broken mod.", (Object)oldPrefix, (Object)name, (Object)prefix);
            prefix = oldPrefix;
        }
        return new ResourceLocation(prefix, name);
    }

    private static void forceRegistryName(IForgeRegistryEntry<?> entry, ResourceLocation name) {
        if (regName == null) {
            try {
                regName = IForgeRegistryEntry.Impl.class.getDeclaredField("registryName");
                regName.setAccessible(true);
            }
            catch (NoSuchFieldException | SecurityException e) {
                FMLLog.log.error("Could not get `registryName` field from IForgeRegistryEntry.Impl");
                FMLLog.log.throwing(Level.ERROR, (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        try {
            regName.set(entry, name);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            FMLLog.log.error("Could not set `registryName` field in IForgeRegistryEntry.Impl to `{}`", (Object)name.toString());
            FMLLog.log.throwing(Level.ERROR, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void lambda$injectSnapshot$20(RegistryManager STAGING, Multimap failed, Map remaps, Multimap defaulted, boolean isLocalWorld, Map.Entry m) {
        ResourceLocation name = (ResourceLocation)m.getKey();
        ForgeRegistry reg = STAGING.getRegistry(name);
        RegistryEvent.MissingMappings<?> event = reg.getMissingEvent(name, (Map)m.getValue());
        MinecraftForge.EVENT_BUS.post(event);
        List<RegistryEvent.MissingMappings.Mapping> lst = event.getAllMappings().stream().filter(e -> e.getAction() == RegistryEvent.MissingMappings.Action.DEFAULT).sorted((a, b) -> a.toString().compareTo(b.toString())).collect(Collectors.toList());
        if (!lst.isEmpty()) {
            FMLLog.log.error("Unidentified mapping from registry {}", (Object)name);
            lst.forEach(map -> FMLLog.log.error("    {}: {}", (Object)map.key, (Object)map.id));
        }
        event.getAllMappings().stream().filter(e -> e.getAction() == RegistryEvent.MissingMappings.Action.FAIL).forEach(fail -> failed.put((Object)name, (Object)fail.key));
        Class clazz = RegistryManager.ACTIVE.getSuperType(name);
        GameData.processMissing(clazz, name, STAGING, event, (Map)m.getValue(), (Map)remaps.get(name), defaulted.get((Object)name), failed.get((Object)name), !isLocalWorld);
    }

    static {
        GameData.init();
    }

    private static class BlockCallbacks
    implements IForgeRegistry.AddCallback<Block>,
    IForgeRegistry.ClearCallback<Block>,
    IForgeRegistry.CreateCallback<Block>,
    IForgeRegistry.DummyFactory<Block> {
        static final BlockCallbacks INSTANCE = new BlockCallbacks();

        private BlockCallbacks() {
        }

        @Override
        public void onAdd(IForgeRegistryInternal<Block> owner, RegistryManager stage, int id, Block block, @Nullable Block oldBlock) {
            BiMap blockToItem;
            Item item;
            ClearableObjectIntIdentityMap blockstateMap = owner.getSlaveMap(BLOCKSTATE_TO_ID, ClearableObjectIntIdentityMap.class);
            if (oldBlock != null) {
                for (IBlockState state : oldBlock.getBlockState().getValidStates()) {
                    blockstateMap.remove(state);
                }
            }
            if ("minecraft:tripwire".equals(block.getRegistryName().toString())) {
                for (int meta = 0; meta < 15; ++meta) {
                    blockstateMap.put(block.getStateFromMeta(meta), id << 4 | meta);
                }
            }
            boolean[] usedMeta = new boolean[16];
            for (IBlockState state : block.getBlockState().getValidStates()) {
                int meta = block.getMetaFromState(state);
                blockstateMap.put(state, id << 4 | meta);
                usedMeta[meta] = true;
            }
            for (int meta = 0; meta < 16; ++meta) {
                if (block.getClass() == BlockObserver.class || !usedMeta[meta]) continue;
                blockstateMap.put(block.getStateFromMeta(meta), id << 4 | meta);
            }
            if (oldBlock != null && (item = (Item)(blockToItem = owner.getSlaveMap(BLOCK_TO_ITEM, BiMap.class)).get((Object)oldBlock)) != null) {
                blockToItem.forcePut((Object)block, (Object)item);
            }
        }

        @Override
        public void onClear(IForgeRegistryInternal<Block> owner, RegistryManager stage) {
            owner.getSlaveMap(BLOCKSTATE_TO_ID, ClearableObjectIntIdentityMap.class).clear();
        }

        @Override
        public void onCreate(IForgeRegistryInternal<Block> owner, RegistryManager stage) {
            ClearableObjectIntIdentityMap<IBlockState> idMap = new ClearableObjectIntIdentityMap<IBlockState>(this){

                @Override
                public int get(IBlockState key) {
                    Integer integer = (Integer)this.identityMap.get(key);
                    if (integer == null && key != null) {
                        integer = (Integer)this.identityMap.get(key.getBlock().getStateFromMeta(key.getBlock().getMetaFromState(key)));
                    }
                    return integer == null ? -1 : integer;
                }
            };
            owner.setSlaveMap(BLOCKSTATE_TO_ID, idMap);
            owner.setSlaveMap(BLOCK_TO_ITEM, HashBiMap.create());
        }

        @Override
        public Block createDummy(ResourceLocation key) {
            Block ret = new BlockDummyAir().setTranslationKey("air");
            GameData.forceRegistryName(ret, key);
            return ret;
        }

        private static class BlockDummyAir
        extends BlockAir {
            private BlockDummyAir() {
            }
        }
    }

    private static class ItemCallbacks
    implements IForgeRegistry.AddCallback<Item>,
    IForgeRegistry.ClearCallback<Item>,
    IForgeRegistry.CreateCallback<Item> {
        static final ItemCallbacks INSTANCE = new ItemCallbacks();

        private ItemCallbacks() {
        }

        @Override
        public void onAdd(IForgeRegistryInternal<Item> owner, RegistryManager stage, int id, Item item, @Nullable Item oldItem) {
            BiMap blockToItem;
            if (oldItem instanceof ItemBlock) {
                blockToItem = owner.getSlaveMap(BLOCK_TO_ITEM, BiMap.class);
                blockToItem.remove((Object)((ItemBlock)oldItem).getBlock());
            }
            if (item instanceof ItemBlock) {
                blockToItem = owner.getSlaveMap(BLOCK_TO_ITEM, BiMap.class);
                blockToItem.forcePut((Object)((ItemBlock)item).getBlock(), (Object)item);
            }
        }

        @Override
        public void onClear(IForgeRegistryInternal<Item> owner, RegistryManager stage) {
            owner.getSlaveMap(BLOCK_TO_ITEM, BiMap.class).clear();
        }

        @Override
        public void onCreate(IForgeRegistryInternal<Item> owner, RegistryManager stage) {
            BiMap map = stage.getRegistry(BLOCKS).getSlaveMap(BLOCK_TO_ITEM, BiMap.class);
            owner.setSlaveMap(BLOCK_TO_ITEM, map);
        }
    }

    private static class RecipeCallbacks
    implements IForgeRegistry.ValidateCallback<IRecipe>,
    IForgeRegistry.MissingFactory<IRecipe> {
        static final RecipeCallbacks INSTANCE = new RecipeCallbacks();

        private RecipeCallbacks() {
        }

        @Override
        public void onValidate(IForgeRegistryInternal<IRecipe> owner, RegistryManager stage, int id, ResourceLocation key, IRecipe obj) {
            if (stage != RegistryManager.ACTIVE) {
                return;
            }
            Item item = obj.getRecipeOutput().getItem();
            if (!stage.getRegistry(Item.class).containsValue(item)) {
                throw new IllegalStateException(String.format("Recipe %s (%s) produces unregistered item %s (%s)", key, obj, item.getRegistryName(), item));
            }
        }

        @Override
        public IRecipe createMissing(ResourceLocation key, boolean isNetwork) {
            return isNetwork ? new DummyRecipe().setRegistryName(key) : null;
        }

        private static class DummyRecipe
        implements IRecipe {
            private static ItemStack result = new ItemStack(Items.DIAMOND, 64);
            private ResourceLocation name;

            private DummyRecipe() {
            }

            @Override
            public IRecipe setRegistryName(ResourceLocation name) {
                this.name = name;
                return this;
            }

            @Override
            public ResourceLocation getRegistryName() {
                return this.name;
            }

            @Override
            public Class<IRecipe> getRegistryType() {
                return IRecipe.class;
            }

            @Override
            public boolean matches(InventoryCrafting inv, World worldIn) {
                return false;
            }

            @Override
            public ItemStack getCraftingResult(InventoryCrafting inv) {
                return result;
            }

            @Override
            public boolean canFit(int width, int height) {
                return false;
            }

            @Override
            public ItemStack getRecipeOutput() {
                return result;
            }

            @Override
            public boolean isDynamic() {
                return true;
            }
        }
    }

    private static class SerializerCallbacks
    implements IForgeRegistry.AddCallback<DataSerializerEntry>,
    IForgeRegistry.ClearCallback<DataSerializerEntry>,
    IForgeRegistry.CreateCallback<DataSerializerEntry> {
        static final SerializerCallbacks INSTANCE = new SerializerCallbacks();

        private SerializerCallbacks() {
        }

        @Override
        public void onAdd(IForgeRegistryInternal<DataSerializerEntry> owner, RegistryManager stage, int id, DataSerializerEntry entry, @Nullable DataSerializerEntry oldEntry) {
            Map map = owner.getSlaveMap(SERIALIZER_TO_ENTRY, Map.class);
            if (oldEntry != null) {
                map.remove(oldEntry.getSerializer());
            }
            map.put(entry.getSerializer(), entry);
        }

        @Override
        public void onClear(IForgeRegistryInternal<DataSerializerEntry> owner, RegistryManager stage) {
            owner.getSlaveMap(SERIALIZER_TO_ENTRY, Map.class).clear();
        }

        @Override
        public void onCreate(IForgeRegistryInternal<DataSerializerEntry> owner, RegistryManager stage) {
            owner.setSlaveMap(SERIALIZER_TO_ENTRY, new IdentityHashMap());
        }
    }

    private static class EntityCallbacks
    implements IForgeRegistry.AddCallback<EntityEntry>,
    IForgeRegistry.ClearCallback<EntityEntry>,
    IForgeRegistry.CreateCallback<EntityEntry> {
        static final EntityCallbacks INSTANCE = new EntityCallbacks();

        private EntityCallbacks() {
        }

        @Override
        public void onAdd(IForgeRegistryInternal<EntityEntry> owner, RegistryManager stage, int id, EntityEntry entry, @Nullable EntityEntry oldEntry) {
            if (entry instanceof EntityEntryBuilder.BuiltEntityEntry) {
                ((EntityEntryBuilder.BuiltEntityEntry)entry).addedToRegistry();
            }
            if (entry.getEgg() != null) {
                EntityList.ENTITY_EGGS.put(entry.getRegistryName(), entry.getEgg());
            }
            Map map = owner.getSlaveMap(ENTITY_CLASS_TO_ENTRY, Map.class);
            if (oldEntry != null) {
                map.remove(oldEntry.getEntityClass());
            }
            map.put(entry.getEntityClass(), entry);
        }

        @Override
        public void onClear(IForgeRegistryInternal<EntityEntry> owner, RegistryManager stage) {
            owner.getSlaveMap(ENTITY_CLASS_TO_ENTRY, Map.class).clear();
        }

        @Override
        public void onCreate(IForgeRegistryInternal<EntityEntry> owner, RegistryManager stage) {
            owner.setSlaveMap(ENTITY_CLASS_TO_ENTRY, new IdentityHashMap());
        }
    }

    static class ClearableObjectIntIdentityMap<I>
    extends ObjectIntIdentityMap<I> {
        ClearableObjectIntIdentityMap() {
        }

        void clear() {
            this.identityMap.clear();
            this.objectList.clear();
        }

        void remove(I key) {
            Integer prev = (Integer)this.identityMap.remove(key);
            if (prev != null) {
                this.objectList.set(prev, null);
            }
        }
    }
}

