/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryNamespacedDefaultedByKey;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryInternal;
import net.minecraftforge.registries.ILockableRegistry;
import net.minecraftforge.registries.RegistryManager;
import org.apache.commons.lang3.Validate;

class NamespacedDefaultedWrapper<V extends IForgeRegistryEntry<V>>
extends RegistryNamespacedDefaultedByKey<ResourceLocation, V>
implements ILockableRegistry {
    private boolean locked = false;
    private ForgeRegistry<V> delegate;

    private NamespacedDefaultedWrapper(ForgeRegistry<V> owner) {
        super(null);
        this.delegate = owner;
    }

    @Override
    public void register(int id, ResourceLocation key, V value) {
        int realId;
        if (this.locked) {
            throw new IllegalStateException("Can not register to a locked registry. Modder should use Forge Register methods.");
        }
        Validate.notNull(value);
        if (value.getRegistryName() == null) {
            value.setRegistryName(key);
        }
        if ((realId = this.delegate.add(id, value)) != id && id != -1) {
            FMLLog.log.warn("Registered object did not get ID it asked for. Name: {} Type: {} Expected: {} Got: {}", (Object)key, (Object)value.getRegistryType().getName(), (Object)id, (Object)realId);
        }
    }

    @Override
    public void putObject(ResourceLocation key, V value) {
        this.register(-1, key, value);
    }

    @Override
    public void validateKey() {
        this.delegate.validateKey();
    }

    @Override
    @Nullable
    public V getObject(@Nullable ResourceLocation name) {
        return this.delegate.getValue(name);
    }

    @Override
    @Nullable
    public ResourceLocation getNameForObject(V value) {
        return this.delegate.getKey(value);
    }

    @Override
    public boolean containsKey(ResourceLocation key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public int getIDForObject(@Nullable V value) {
        return this.delegate.getID(value);
    }

    @Override
    @Nullable
    public V getObjectById(int id) {
        return this.delegate.getValue(id);
    }

    @Override
    public Iterator<V> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Set<ResourceLocation> getKeys() {
        return this.delegate.getKeys();
    }

    @Override
    @Nullable
    public V getRandomObject(Random random) {
        Collection<V> values = this.delegate.getValuesCollection();
        return (V)((IForgeRegistryEntry)values.stream().skip(random.nextInt(values.size())).findFirst().orElse(this.delegate.getDefault()));
    }

    @Override
    public void lock() {
        this.locked = true;
    }

    public static class Factory<V extends IForgeRegistryEntry<V>>
    implements IForgeRegistry.CreateCallback<V> {
        public static final ResourceLocation ID = new ResourceLocation("forge", "registry_defaulted_wrapper");

        @Override
        public void onCreate(IForgeRegistryInternal<V> owner, RegistryManager stage) {
            owner.setSlaveMap(ID, new NamespacedDefaultedWrapper((ForgeRegistry)owner));
        }
    }
}

