/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentBase;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.WorldWorkerManager;
import net.minecraftforge.server.command.TextComponentHelper;

public class ChunkGenWorker
implements WorldWorkerManager.IWorker {
    private final ICommandSender listener;
    protected final BlockPos start;
    protected final int total;
    private final int dim;
    private final Queue<BlockPos> queue;
    private final int notificationFrequency;
    private int lastNotification = 0;
    private long lastNotifcationTime = 0L;
    private int genned = 0;
    private Boolean keepingLoaded;

    public ChunkGenWorker(ICommandSender listener, BlockPos start, int total, int dim, int interval) {
        this.listener = listener;
        this.start = start;
        this.total = total;
        this.dim = dim;
        this.queue = this.buildQueue();
        this.notificationFrequency = interval != -1 ? interval : Math.max(total / 20, 100);
        this.lastNotifcationTime = System.currentTimeMillis();
    }

    protected Queue<BlockPos> buildQueue() {
        ArrayDeque<BlockPos> ret = new ArrayDeque<BlockPos>();
        ret.add(this.start);
        int radius = 1;
        while (ret.size() < this.total) {
            int q;
            for (q = -radius + 1; q <= radius && ret.size() < this.total; ++q) {
                ret.add(this.start.add(radius, 0, q));
            }
            for (q = radius - 1; q >= -radius && ret.size() < this.total; --q) {
                ret.add(this.start.add(q, 0, radius));
            }
            for (q = radius - 1; q >= -radius && ret.size() < this.total; --q) {
                ret.add(this.start.add(-radius, 0, q));
            }
            for (q = -radius + 1; q <= radius && ret.size() < this.total; ++q) {
                ret.add(this.start.add(q, 0, -radius));
            }
            ++radius;
        }
        return ret;
    }

    @Deprecated
    public TextComponentTranslation getStartMessage() {
        return new TextComponentTranslation("commands.forge.gen.start", this.total, this.start.getX(), this.start.getZ(), this.dim);
    }

    public TextComponentBase getStartMessage(ICommandSender sender) {
        return TextComponentHelper.createComponentTranslation(sender, "commands.forge.gen.start", this.total, this.start.getX(), this.start.getZ(), this.dim);
    }

    @Override
    public boolean hasWork() {
        return this.queue.size() > 0;
    }

    @Override
    public boolean doWork() {
        AnvilChunkLoader loader;
        WorldServer world = DimensionManager.getWorld(this.dim);
        if (world == null) {
            DimensionManager.initDimension(this.dim);
            world = DimensionManager.getWorld(this.dim);
            if (world == null) {
                this.listener.sendMessage(TextComponentHelper.createComponentTranslation(this.listener, "commands.forge.gen.dim_fail", this.dim));
                this.queue.clear();
                return false;
            }
        }
        AnvilChunkLoader anvilChunkLoader = loader = world.getChunkProvider().chunkLoader instanceof AnvilChunkLoader ? (AnvilChunkLoader)world.getChunkProvider().chunkLoader : null;
        if (loader != null && loader.getPendingSaveCount() > 100) {
            if (this.lastNotifcationTime < System.currentTimeMillis() - 10000L) {
                this.listener.sendMessage(TextComponentHelper.createComponentTranslation(this.listener, "commands.forge.gen.progress", this.total - this.queue.size(), this.total));
                this.lastNotifcationTime = System.currentTimeMillis();
            }
            return false;
        }
        BlockPos next = this.queue.poll();
        if (next != null) {
            if (this.keepingLoaded == null) {
                this.keepingLoaded = DimensionManager.keepDimensionLoaded(this.dim, true);
            }
            if (++this.lastNotification >= this.notificationFrequency || this.lastNotifcationTime < System.currentTimeMillis() - 60000L) {
                this.listener.sendMessage(TextComponentHelper.createComponentTranslation(this.listener, "commands.forge.gen.progress", this.total - this.queue.size(), this.total));
                this.lastNotification = 0;
                this.lastNotifcationTime = System.currentTimeMillis();
            }
            int x = next.getX();
            int z = next.getZ();
            Chunk target = world.getChunk(x, z);
            Chunk[] chunks = new Chunk[]{target};
            if (!target.isTerrainPopulated()) {
                chunks = new Chunk[]{target, world.getChunk(x + 1, z), world.getChunk(x + 1, z + 1), world.getChunk(x, z + 1)};
                try {
                    world.getChunkProvider().chunkLoader.saveChunk(world, target);
                }
                catch (IOException | MinecraftException e) {
                    this.listener.sendMessage(TextComponentHelper.createComponentTranslation(this.listener, "commands.forge.gen.saveerror", e.getMessage()));
                }
                ++this.genned;
            }
            for (Chunk chunk : chunks) {
                PlayerChunkMapEntry watchers = world.getPlayerChunkMap().getEntry(chunk.x, chunk.z);
                if (watchers != null) continue;
                world.getChunkProvider().queueUnload(chunk);
            }
        }
        if (this.queue.size() == 0) {
            this.listener.sendMessage(TextComponentHelper.createComponentTranslation(this.listener, "commands.forge.gen.complete", this.genned, this.total, this.dim));
            if (this.keepingLoaded != null && this.keepingLoaded.booleanValue()) {
                DimensionManager.keepDimensionLoaded(this.dim, false);
            }
            return false;
        }
        return true;
    }
}

