/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.EntityList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.server.command.CommandTreeBase;
import net.minecraftforge.server.command.CommandTreeHelp;
import net.minecraftforge.server.command.TextComponentHelper;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

class CommandEntity
extends CommandTreeBase {
    public CommandEntity() {
        this.addSubcommand(new EntityListCommand());
        this.addSubcommand(new CommandTreeHelp(this));
    }

    @Override
    public String getUsage(ICommandSender sender) {
        return "commands.forge.entity.usage";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getName() {
        return "entity";
    }

    private static class EntityListCommand
    extends CommandBase {
        private EntityListCommand() {
        }

        @Override
        public String getName() {
            return "list";
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 2;
        }

        @Override
        public String getUsage(ICommandSender sender) {
            return "commands.forge.entity.list.usage";
        }

        @Override
        public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            String filter = "*";
            if (args.length > 0) {
                filter = args[0];
            }
            String cleanFilter = filter.replace("?", ".?").replace("*", ".*?");
            Set names = EntityList.getEntityNameList().stream().filter(n -> n.toString().matches(cleanFilter)).collect(Collectors.toSet());
            if (names.isEmpty()) {
                throw new WrongUsageException("commands.forge.entity.list.invalid", new Object[0]);
            }
            int dim = args.length > 1 ? EntityListCommand.parseInt(args[1]) : sender.getEntityWorld().provider.getDimension();
            WorldServer world = DimensionManager.getWorld(dim);
            if (world == null) {
                throw new WrongUsageException("commands.forge.entity.list.invalidworld", dim);
            }
            HashMap list = Maps.newHashMap();
            List entities = world.loadedEntityList;
            entities.forEach(e -> {
                ResourceLocation key = EntityList.getKey(e);
                MutablePair info = list.computeIfAbsent(key, k -> MutablePair.of((Object)0, (Object)Maps.newHashMap()));
                ChunkPos chunk = new ChunkPos(e.getPosition());
                MutablePair mutablePair = info;
                Integer n = (Integer)mutablePair.left;
                mutablePair.left = (Integer)mutablePair.left + 1;
                ((Map)info.right).put(chunk, ((Map)info.right).getOrDefault(chunk, 0) + 1);
            });
            if (names.size() == 1) {
                ResourceLocation name = (ResourceLocation)names.iterator().next();
                Pair info = (Pair)list.get(name);
                if (info == null) {
                    throw new WrongUsageException("commands.forge.entity.list.none", new Object[0]);
                }
                sender.sendMessage(TextComponentHelper.createComponentTranslation(sender, "commands.forge.entity.list.single.header", name, info.getLeft()));
                ArrayList toSort = new ArrayList();
                toSort.addAll(((Map)info.getRight()).entrySet());
                toSort.sort((a, b) -> {
                    if (Objects.equals(a.getValue(), b.getValue())) {
                        return ((ChunkPos)a.getKey()).toString().compareTo(((ChunkPos)b.getKey()).toString());
                    }
                    return (Integer)b.getValue() - (Integer)a.getValue();
                });
                long limit = 10L;
                for (Map.Entry entry : toSort) {
                    if (limit-- != 0L) {
                        sender.sendMessage(new TextComponentString("  " + String.valueOf(entry.getValue()) + ": " + ((ChunkPos)entry.getKey()).x + ", " + ((ChunkPos)entry.getKey()).z));
                        continue;
                    }
                    break;
                }
            } else {
                ArrayList info = new ArrayList();
                list.forEach((key, value) -> {
                    if (names.contains(key)) {
                        Pair of = Pair.of((Object)key, (Object)((Integer)value.left));
                        info.add(of);
                    }
                });
                info.sort((a, b) -> {
                    if (Objects.equals(a.getRight(), b.getRight())) {
                        return ((ResourceLocation)a.getKey()).toString().compareTo(((ResourceLocation)b.getKey()).toString());
                    }
                    return (Integer)b.getRight() - (Integer)a.getRight();
                });
                if (info.size() == 0) {
                    throw new WrongUsageException("commands.forge.entity.list.none", new Object[0]);
                }
                int count = info.stream().mapToInt(Pair::getRight).sum();
                sender.sendMessage(TextComponentHelper.createComponentTranslation(sender, "commands.forge.entity.list.multiple.header", count));
                info.forEach(e -> sender.sendMessage(new TextComponentString("  " + String.valueOf(e.getValue()) + ": " + String.valueOf(e.getKey()))));
            }
        }

        @Override
        public List<String> getTabCompletions(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
            if (args.length == 1) {
                String[] entityNames = (String[])EntityList.getEntityNameList().stream().map(ResourceLocation::toString).sorted().toArray(String[]::new);
                return EntityListCommand.getListOfStringsMatchingLastWord(args, entityNames);
            }
            return Collections.emptyList();
        }
    }
}

