/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.WorldWorkerManager;
import net.minecraftforge.server.command.ChunkGenWorker;

class CommandGenerate
extends CommandBase {
    CommandGenerate() {
    }

    @Override
    public String getName() {
        return "generate";
    }

    @Override
    public List<String> getAliases() {
        return Collections.singletonList("gen");
    }

    @Override
    public String getUsage(ICommandSender sender) {
        return "commands.forge.gen.usage";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 4;
    }

    @Override
    public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 4) {
            throw new WrongUsageException("commands.forge.gen.usage", new Object[0]);
        }
        BlockPos blockpos = CommandGenerate.parseBlockPos(sender, args, 0, false);
        int count = CommandGenerate.parseInt(args[3], 10);
        int dim = args.length >= 5 ? CommandGenerate.parseInt(args[4]) : sender.getEntityWorld().provider.getDimension();
        int interval = args.length >= 6 ? CommandGenerate.parseInt(args[5]) : -1;
        BlockPos chunkpos = new BlockPos(blockpos.getX() >> 4, 0, blockpos.getZ() >> 4);
        ChunkGenWorker worker = new ChunkGenWorker(sender, chunkpos, count, dim, interval);
        sender.sendMessage(worker.getStartMessage(sender));
        WorldWorkerManager.addWorker(worker);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length < 4) {
            return CommandGenerate.getTabCompletionCoordinate(args, 0, targetPos);
        }
        return Collections.emptyList();
    }
}

