/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ITeleporter;

public class CommandSetDimension
extends CommandBase {
    @Override
    public String getName() {
        return "setdimension";
    }

    @Override
    public List<String> getAliases() {
        return Collections.singletonList("setdim");
    }

    @Override
    public String getUsage(ICommandSender sender) {
        return "commands.forge.setdim.usage";
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length > 2 && args.length <= 5) {
            return CommandSetDimension.getTabCompletionCoordinate(args, 2, targetPos);
        }
        return Collections.emptyList();
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length != 2 && args.length != 5) {
            throw new WrongUsageException("commands.forge.setdim.usage", new Object[0]);
        }
        Entity entity = CommandSetDimension.getEntity(server, sender, args[0]);
        if (!CommandSetDimension.checkEntity(entity)) {
            throw new CommandException("commands.forge.setdim.invalid.entity", entity.getName());
        }
        int dimension = CommandSetDimension.parseInt(args[1]);
        if (!DimensionManager.isDimensionRegistered(dimension)) {
            throw new CommandException("commands.forge.setdim.invalid.dim", dimension);
        }
        if (dimension == entity.dimension) {
            throw new CommandException("commands.forge.setdim.invalid.nochange", entity.getName(), dimension);
        }
        BlockPos pos = args.length == 5 ? CommandSetDimension.parseBlockPos(sender, args, 2, false) : sender.getPosition();
        entity.changeDimension(dimension, new CommandTeleporter(pos));
    }

    private static boolean checkEntity(Entity entity) {
        return !entity.isRiding() && !entity.isBeingRidden() && entity.isNonBoss();
    }

    private static class CommandTeleporter
    implements ITeleporter {
        private final BlockPos targetPos;

        private CommandTeleporter(BlockPos targetPos) {
            this.targetPos = targetPos;
        }

        @Override
        public void placeEntity(World world, Entity entity, float yaw) {
            entity.moveToBlockPosAndAngles(this.targetPos, yaw, entity.rotationPitch);
        }
    }
}

