/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.server.command.TextComponentHelper;

public abstract class CommandTreeBase
extends CommandBase {
    private final Map<String, ICommand> commandMap = new HashMap<String, ICommand>();
    private final Map<String, ICommand> commandAliasMap = new HashMap<String, ICommand>();

    public void addSubcommand(ICommand command) {
        this.commandMap.put(command.getName(), command);
        for (String alias : command.getAliases()) {
            this.commandAliasMap.put(alias, command);
        }
    }

    public Collection<ICommand> getSubCommands() {
        return this.commandMap.values();
    }

    @Nullable
    public ICommand getSubCommand(String command) {
        ICommand cmd = this.commandMap.get(command);
        if (cmd != null) {
            return cmd;
        }
        return this.commandAliasMap.get(command);
    }

    public Map<String, ICommand> getCommandMap() {
        return Collections.unmodifiableMap(this.commandMap);
    }

    public List<ICommand> getSortedCommandList() {
        ArrayList<ICommand> list = new ArrayList<ICommand>(this.getSubCommands());
        Collections.sort(list);
        return list;
    }

    private static String[] shiftArgs(@Nullable String[] s) {
        if (s == null || s.length == 0) {
            return new String[0];
        }
        String[] s1 = new String[s.length - 1];
        System.arraycopy(s, 1, s1, 0, s1.length);
        return s1;
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        if (args.length == 1) {
            ArrayList<String> keys = new ArrayList<String>();
            for (ICommand c : this.getSubCommands()) {
                if (!c.checkPermission(server, sender)) continue;
                keys.add(c.getName());
            }
            keys.sort(null);
            return CommandTreeBase.getListOfStringsMatchingLastWord(args, keys);
        }
        ICommand cmd = this.getSubCommand(args[0]);
        if (cmd != null) {
            return cmd.getTabCompletions(server, sender, CommandTreeBase.shiftArgs(args), pos);
        }
        return super.getTabCompletions(server, sender, args, pos);
    }

    @Override
    public boolean isUsernameIndex(String[] args, int index) {
        ICommand cmd;
        if (index > 0 && args.length > 1 && (cmd = this.getSubCommand(args[0])) != null) {
            return cmd.isUsernameIndex(CommandTreeBase.shiftArgs(args), index - 1);
        }
        return false;
    }

    @Override
    public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            String subCommandsString = this.getAvailableSubCommandsString(server, sender);
            sender.sendMessage(TextComponentHelper.createComponentTranslation(sender, "commands.tree_base.available_subcommands", subCommandsString));
        } else {
            ICommand cmd = this.getSubCommand(args[0]);
            if (cmd == null) {
                String subCommandsString = this.getAvailableSubCommandsString(server, sender);
                throw new CommandException("commands.tree_base.invalid_cmd.list_subcommands", args[0], subCommandsString);
            }
            if (!cmd.checkPermission(server, sender)) {
                throw new CommandException("commands.generic.permission", new Object[0]);
            }
            cmd.execute(server, sender, CommandTreeBase.shiftArgs(args));
        }
    }

    private String getAvailableSubCommandsString(MinecraftServer server, ICommandSender sender) {
        ArrayList<String> availableCommands = new ArrayList<String>();
        for (ICommand command : this.getSubCommands()) {
            if (!command.checkPermission(server, sender)) continue;
            availableCommands.add(command.getName());
        }
        return CommandBase.joinNiceStringFromCollection(availableCommands);
    }
}

