/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.server.command.CommandTreeBase;
import net.minecraftforge.server.command.TextComponentHelper;

public class CommandTreeHelp
extends CommandTreeBase {
    private final ICommand parent;

    public CommandTreeHelp(CommandTreeBase parent) {
        this.parent = parent;
        for (ICommand command : parent.getSubCommands()) {
            this.addSubcommand(new HelpSubCommand(this, command));
        }
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 0;
    }

    @Override
    public String getName() {
        return "help";
    }

    @Override
    public String getUsage(ICommandSender sender) {
        return "commands.forge.usage.help";
    }

    @Override
    public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            sender.sendMessage(TextComponentHelper.createComponentTranslation(sender, this.parent.getUsage(sender), new Object[0]));
            for (ICommand subCommand : this.getSubCommands()) {
                if (!(subCommand instanceof HelpSubCommand) || !subCommand.checkPermission(server, sender)) continue;
                subCommand.execute(server, sender, args);
            }
            return;
        }
        super.execute(server, sender, args);
    }

    public static class HelpSubCommand
    extends CommandBase {
        private final CommandTreeHelp parent;
        private final ICommand command;

        public HelpSubCommand(CommandTreeHelp parent, ICommand command) {
            this.parent = parent;
            this.command = command;
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return this.command.getName();
        }

        @Override
        public String getUsage(ICommandSender sender) {
            return this.command.getUsage(sender);
        }

        @Override
        public boolean checkPermission(MinecraftServer server, ICommandSender sender) {
            return this.command.checkPermission(server, sender);
        }

        @Override
        public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            sender.sendMessage(TextComponentHelper.createComponentTranslation(sender, this.command.getUsage(sender), new Object[0]));
        }
    }
}

